/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.execution.ui.TagButton;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.EditorTextComponent;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Alarm;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.DefaultCaret;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.swing.SwingUtilities2;

public class ComponentValidator {
    private static final String PROPERTY_NAME = "JComponent.componentValidator";
    private static final JBValue MAX_WIDTH = new JBValue.UIInteger("ValidationTooltip.maxWidth", 384);
    public static final Function<JComponent, JComponent> CWBB_PROVIDER = c -> ((ComponentWithBrowseButton)c).getChildComponent();
    private final Disposable parentDisposable;
    private Supplier<? extends ValidationInfo> validator;
    private Supplier<? extends ValidationInfo> focusValidator;
    private Function<? super JComponent, ? extends JComponent> outlineProvider;
    private HyperlinkListener hyperlinkListener;
    private ValidationInfo validationInfo;
    private final Alarm popupAlarm;
    private boolean isOverPopup;
    private ComponentPopupBuilder popupBuilder;
    private JBPopup popup;
    private RelativePoint popupLocation;
    private Dimension popupSize;
    private boolean disableValidation;
    private JEditorPane tipComponent;

    public ComponentValidator(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            ComponentValidator.$$$reportNull$$$0(0);
        }
        this.outlineProvider = Function.identity();
        this.popupAlarm = new Alarm();
        this.parentDisposable = parentDisposable;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public ComponentValidator withValidator(@NotNull Consumer<? super ComponentValidator> validator2) {
        if (validator2 == null) {
            ComponentValidator.$$$reportNull$$$0(1);
        }
        this.validator = () -> {
            validator2.accept(this);
            return this.validationInfo;
        };
        return this;
    }

    public ComponentValidator withValidator(@NotNull Supplier<? extends ValidationInfo> validator2) {
        if (validator2 == null) {
            ComponentValidator.$$$reportNull$$$0(2);
        }
        this.validator = validator2;
        return this;
    }

    public ComponentValidator withFocusValidator(@NotNull Supplier<? extends ValidationInfo> focusValidator) {
        if (focusValidator == null) {
            ComponentValidator.$$$reportNull$$$0(3);
        }
        this.focusValidator = focusValidator;
        return this;
    }

    public ComponentValidator withHyperlinkListener(@NotNull HyperlinkListener hyperlinkListener) {
        if (hyperlinkListener == null) {
            ComponentValidator.$$$reportNull$$$0(4);
        }
        this.hyperlinkListener = hyperlinkListener;
        return this;
    }

    public ComponentValidator withOutlineProvider(@NotNull Function<? super JComponent, ? extends JComponent> outlineProvider) {
        if (outlineProvider == null) {
            ComponentValidator.$$$reportNull$$$0(5);
        }
        this.outlineProvider = outlineProvider;
        return this;
    }

    public ComponentValidator andStartOnFocusLost() {
        this.disableValidation = true;
        return this;
    }

    public ComponentValidator installOn(@NotNull JComponent component) {
        if (component == null) {
            ComponentValidator.$$$reportNull$$$0(6);
        }
        Component fc = ComponentValidator.getFocusable(component).orElse(this.outlineProvider.apply(component));
        component.putClientProperty(PROPERTY_NAME, this);
        ValidationFocusListener focusListener = new ValidationFocusListener();
        ValidationMouseListener mouseListener = new ValidationMouseListener();
        ComponentAdapter componentListener = new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                if (ComponentValidator.this.popup != null && ComponentValidator.this.popup.isVisible() && ComponentValidator.this.popupLocation != null) {
                    ComponentValidator.this.popup.setLocation(ComponentValidator.this.popupLocation.getScreenPoint());
                }
            }
        };
        PropertyChangeListener ancestorListener = e -> {
            Window w = (Window)ComponentUtil.findParentByCondition((Component)((Component)e.getSource()), v -> v instanceof Window);
            if (w != null) {
                if (e.getNewValue() != null) {
                    w.addComponentListener(componentListener);
                } else {
                    w.removeComponentListener(componentListener);
                }
            }
        };
        Window w = (Window)ComponentUtil.findParentByCondition((Component)component, v -> v instanceof Window);
        if (w != null) {
            w.addComponentListener(componentListener);
        } else {
            component.addPropertyChangeListener("ancestor", ancestorListener);
        }
        fc.addFocusListener(focusListener);
        fc.addMouseListener(mouseListener);
        Disposer.register((Disposable)this.parentDisposable, () -> {
            fc.removeFocusListener(focusListener);
            fc.removeMouseListener(mouseListener);
            if (w != null) {
                w.removeComponentListener(componentListener);
            }
            this.reset();
        });
        return this;
    }

    public ComponentValidator andRegisterOnDocumentListener(final @NotNull JTextComponent textComponent) {
        if (textComponent == null) {
            ComponentValidator.$$$reportNull$$$0(7);
        }
        textComponent.getDocument().addDocumentListener((javax.swing.event.DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull javax.swing.event.DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                ComponentValidator.getInstance(textComponent).ifPresent(ComponentValidator::revalidate);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/ui/ComponentValidator$2", "textChanged"));
            }
        });
        return this;
    }

    public <T extends JComponent> ComponentValidator andRegisterOnDocumentListener(final @NotNull T textComponent) {
        if (textComponent == null) {
            ComponentValidator.$$$reportNull$$$0(8);
        }
        ((EditorTextComponent)((Object)textComponent)).getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                ComponentValidator.getInstance(textComponent).ifPresent(ComponentValidator::revalidate);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/ui/ComponentValidator$3", "documentChanged"));
            }
        }, this.parentDisposable);
        return this;
    }

    public void revalidate() {
        if (this.validator != null) {
            this.updateInfo(this.validator.get());
        }
    }

    public static Optional<ComponentValidator> getInstance(@NotNull JComponent component) {
        if (component == null) {
            ComponentValidator.$$$reportNull$$$0(9);
        }
        return Optional.ofNullable((ComponentValidator)component.getClientProperty(PROPERTY_NAME));
    }

    private void reset() {
        if (this.validationInfo != null && this.validationInfo.component != null) {
            this.outlineProvider.apply(this.validationInfo.component).putClientProperty("JComponent.outline", null);
            this.validationInfo.component.revalidate();
            this.validationInfo.component.repaint();
        }
        this.hidePopup(true);
        this.popupBuilder = null;
        this.tipComponent = null;
        this.popupLocation = null;
        this.popupSize = null;
        this.validationInfo = null;
    }

    @Nullable
    public ValidationInfo getValidationInfo() {
        return this.validationInfo;
    }

    public void updateInfo(@Nullable ValidationInfo info) {
        boolean hasNewInfo;
        if (this.disableValidation) {
            return;
        }
        boolean resetInfo = info == null && this.validationInfo != null;
        boolean bl = hasNewInfo = info != null && !info.equals(this.validationInfo);
        if (resetInfo) {
            this.reset();
        } else if (hasNewInfo) {
            this.validationInfo = info;
            if (this.popup != null && this.popup.isVisible() && this.tipComponent != null) {
                this.popup.pack(true, ComponentValidator.convertMessage(info.message, this.tipComponent));
            } else {
                JComponent component = this.validationInfo.component;
                if (component != null) {
                    this.outlineProvider.apply(component).putClientProperty("JComponent.outline", this.validationInfo.warning ? "warning" : "error");
                    component.revalidate();
                    component.repaint();
                }
                if (!StringUtil.isEmptyOrSpaces((String)info.message)) {
                    this.popupBuilder = ComponentValidator.createPopupBuilder(this.validationInfo, (? super JEditorPane editorPane) -> {
                        this.tipComponent = editorPane;
                        editorPane.addHyperlinkListener(this.hyperlinkListener);
                        editorPane.addMouseListener(new TipComponentMouseListener());
                        this.popupSize = editorPane.getPreferredSize();
                    }).setCancelOnMouseOutCallback(e -> e.getID() == 501 && !ComponentValidator.withinComponent(info, e));
                    ComponentValidator.getFocusable(component).ifPresent(fc -> {
                        if (fc.hasFocus()) {
                            this.showPopup();
                        }
                    });
                }
            }
        }
    }

    @NotNull
    private static ComponentPopupBuilder createPopupBuilder(boolean isWarning, @Nullable Consumer<? super JEditorPane> configurator) {
        JEditorPane tipComponent = new JEditorPane();
        tipComponent.setContentType("text/html");
        tipComponent.setEditable(false);
        tipComponent.setEditorKit(UIUtil.getHTMLEditorKit());
        EditorKit kit = tipComponent.getEditorKit();
        if (kit instanceof HTMLEditorKit) {
            StyleSheet css = ((HTMLEditorKit)kit).getStyleSheet();
            css.addRule("a, a:link {color:#" + ColorUtil.toHex((Color)JBUI.CurrentTheme.Link.Foreground.ENABLED) + ";}");
            css.addRule("a:visited {color:#" + ColorUtil.toHex((Color)JBUI.CurrentTheme.Link.Foreground.VISITED) + ";}");
            css.addRule("a:hover {color:#" + ColorUtil.toHex((Color)JBUI.CurrentTheme.Link.Foreground.HOVERED) + ";}");
            css.addRule("a:active {color:#" + ColorUtil.toHex((Color)JBUI.CurrentTheme.Link.Foreground.PRESSED) + ";}");
            css.addRule("body {background-color:#" + ColorUtil.toHex((Color)(isWarning ? JBUI.CurrentTheme.Validator.warningBackgroundColor() : JBUI.CurrentTheme.Validator.errorBackgroundColor())) + ";}");
        }
        if (tipComponent.getCaret() instanceof DefaultCaret) {
            ((DefaultCaret)tipComponent.getCaret()).setUpdatePolicy(1);
        }
        tipComponent.setCaretPosition(0);
        tipComponent.setBackground(isWarning ? JBUI.CurrentTheme.Validator.warningBackgroundColor() : JBUI.CurrentTheme.Validator.errorBackgroundColor());
        tipComponent.setOpaque(true);
        tipComponent.setBorder(ComponentValidator.getBorder());
        if (configurator != null) {
            configurator.accept(tipComponent);
        }
        ComponentPopupBuilder componentPopupBuilder = JBPopupFactory.getInstance().createComponentPopupBuilder(tipComponent, null).setBorderColor(isWarning ? JBUI.CurrentTheme.Validator.warningBorderColor() : JBUI.CurrentTheme.Validator.errorBorderColor()).setCancelOnClickOutside(false).setShowShadow(true);
        if (componentPopupBuilder == null) {
            ComponentValidator.$$$reportNull$$$0(10);
        }
        return componentPopupBuilder;
    }

    @NlsSafe
    private static boolean convertMessage(@Nls String message, @NotNull JEditorPane component) {
        View v;
        if (component == null) {
            ComponentValidator.$$$reportNull$$$0(11);
        }
        boolean widerText = (v = BasicHTML.createHTMLView(component, String.format("<html>%s</html>", message))).getPreferredSpan(0) > (float)MAX_WIDTH.get();
        HtmlChunk.Element div = widerText ? HtmlChunk.div().attr("width", MAX_WIDTH.get()).addRaw(ComponentValidator.trimMessage(message, component)) : HtmlChunk.div().addRaw(message);
        component.setText(div.wrapWith("body").wrapWith("html").toString());
        return widerText;
    }

    @NotNull
    public static ComponentPopupBuilder createPopupBuilder(@NotNull ValidationInfo info, @Nullable Consumer<? super JEditorPane> configurator) {
        if (info == null) {
            ComponentValidator.$$$reportNull$$$0(12);
        }
        return ComponentValidator.createPopupBuilder(info.warning, (? super JEditorPane tipComponent) -> {
            ComponentValidator.convertMessage(info.message, tipComponent);
            if (configurator != null) {
                configurator.accept((JEditorPane)tipComponent);
            }
        });
    }

    @Nls
    private static String trimMessage(@Nls String message, JComponent c) {
        String[] words = message.split("\\s+");
        @Nls StringBuilder result = new StringBuilder();
        for (String word : words) {
            word = SwingUtilities2.clipStringIfNecessary(c, c.getFontMetrics(c.getFont()), word, MAX_WIDTH.get());
            result.append(word).append(" ");
        }
        return result.toString();
    }

    public static boolean withinComponent(@NotNull ValidationInfo info, @NotNull MouseEvent e) {
        if (info == null) {
            ComponentValidator.$$$reportNull$$$0(13);
        }
        if (e == null) {
            ComponentValidator.$$$reportNull$$$0(14);
        }
        if (info.component != null && info.component.isShowing()) {
            Rectangle screenBounds = new Rectangle(info.component.getLocationOnScreen(), info.component.getSize());
            return screenBounds.contains(e.getLocationOnScreen());
        }
        return false;
    }

    private void showPopup() {
        if ((this.popup == null || !this.popup.isVisible()) && this.popupBuilder != null && this.validationInfo != null && this.validationInfo.component != null && this.validationInfo.component.isEnabled()) {
            this.popup = this.popupBuilder.createPopup();
            Insets i2 = this.validationInfo.component.getInsets();
            Point point = new Point(JBUIScale.scale((int)40), i2.top - JBUIScale.scale((int)6) - this.popupSize.height);
            this.popupLocation = new RelativePoint((Component)this.validationInfo.component, point);
            this.popup.show(this.popupLocation);
        }
    }

    private void hidePopup(boolean now) {
        if (this.popup != null && this.popup.isVisible()) {
            if (now || this.hyperlinkListener == null) {
                this.popup.cancel();
                this.popup = null;
            } else {
                this.popupAlarm.addRequest(() -> {
                    if (!this.isOverPopup || this.hyperlinkListener == null) {
                        this.hidePopup(true);
                    }
                }, Registry.intValue((String)"ide.tooltip.initialDelay.highlighter"));
            }
        }
    }

    public static Border getBorder() {
        Insets i2 = UIManager.getInsets("ValidationTooltip.borderInsets");
        return i2 != null ? new JBEmptyBorder(i2) : JBUI.Borders.empty((int)4, (int)8);
    }

    private static Optional<Component> getFocusable(Component source) {
        return source instanceof JComboBox && !((JComboBox)source).isEditable() || source instanceof JCheckBox || source instanceof JRadioButton || source instanceof TagButton ? Optional.of(source) : ((JBTreeTraverser)UIUtil.uiTraverser((Component)source).filter(c -> c instanceof JTextComponent && c.isFocusable())).toList().stream().findFirst();
    }

    public void enableValidation() {
        this.disableValidation = false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "focusValidator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hyperlinkListener";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outlineProvider";
                break;
            }
            case 6: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textComponent";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/ui/ComponentValidator";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/ui/ComponentValidator";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "withValidator";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "withFocusValidator";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "withHyperlinkListener";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "withOutlineProvider";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "installOn";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "andRegisterOnDocumentListener";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "convertMessage";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createPopupBuilder";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "withinComponent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class TipComponentMouseListener
    extends MouseAdapter {
        private TipComponentMouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            ComponentValidator.this.isOverPopup = true;
        }

        @Override
        public void mouseExited(MouseEvent e) {
            ComponentValidator.this.isOverPopup = false;
            if (ComponentValidator.this.popup != null) {
                ComponentValidator.getFocusable(ComponentValidator.this.validationInfo.component).ifPresent(fc -> {
                    if (!fc.hasFocus()) {
                        ComponentValidator.this.popup.cancel();
                        ComponentValidator.this.popup = null;
                    }
                });
            }
        }
    }

    private class ValidationMouseListener
    extends MouseAdapter {
        private ValidationMouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            ComponentValidator.this.showPopup();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (ComponentValidator.this.validationInfo != null) {
                ComponentValidator.getFocusable(ComponentValidator.this.validationInfo.component).ifPresent(fc -> {
                    if (!fc.hasFocus()) {
                        ComponentValidator.this.hidePopup(false);
                    }
                });
            }
        }
    }

    private class ValidationFocusListener
    implements FocusListener {
        private ValidationFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            ComponentValidator.this.showPopup();
        }

        @Override
        public void focusLost(FocusEvent e) {
            ComponentValidator.this.hidePopup(false);
            if (ComponentValidator.this.focusValidator != null) {
                ComponentValidator.this.updateInfo(ComponentValidator.this.focusValidator.get());
            }
            if (ComponentValidator.this.disableValidation) {
                ComponentValidator.this.enableValidation();
                ComponentValidator.this.revalidate();
            }
        }
    }
}

