/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class ExtendableSettingsEditor<T>
extends SettingsEditor<T> {
    private final SettingsEditor<T> myMainEditor;
    private final List<SettingsEditor<T>> myExtensionEditors;

    public ExtendableSettingsEditor(SettingsEditor<T> mainEditor) {
        this.myMainEditor = mainEditor;
        Disposer.register((Disposable)this, this.myMainEditor);
        this.myExtensionEditors = new ArrayList<SettingsEditor<T>>();
    }

    @Override
    protected void resetEditorFrom(@NotNull T s) {
        if (s == null) {
            ExtendableSettingsEditor.$$$reportNull$$$0(0);
        }
        this.myMainEditor.resetFrom(s);
        for (SettingsEditor<T> extensionEditor : this.myExtensionEditors) {
            extensionEditor.resetFrom(s);
        }
    }

    @Override
    protected void applyEditorTo(@NotNull T s) throws ConfigurationException {
        if (s == null) {
            ExtendableSettingsEditor.$$$reportNull$$$0(1);
        }
        this.myMainEditor.applyTo(s);
        for (SettingsEditor<T> extensionEditor : this.myExtensionEditors) {
            extensionEditor.applyTo(s);
        }
    }

    public void addExtensionEditor(@NotNull SettingsEditor<T> extensionSettingsEditor) {
        if (extensionSettingsEditor == null) {
            ExtendableSettingsEditor.$$$reportNull$$$0(2);
        }
        this.myExtensionEditors.add(extensionSettingsEditor);
        Disposer.register((Disposable)this, extensionSettingsEditor);
    }

    @Override
    @NotNull
    protected JComponent createEditor() {
        JPanel result = new JPanel();
        result.setLayout(new GridBagLayout());
        JComponent mainEditorComponent = this.myMainEditor.getComponent();
        GridBagConstraints c = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, (Insets)JBUI.emptyInsets(), 0, 0);
        result.add((Component)mainEditorComponent, c);
        for (int i2 = 0; i2 < this.myExtensionEditors.size(); ++i2) {
            c = (GridBagConstraints)c.clone();
            c.gridy = i2 + 1;
            result.add((Component)this.myExtensionEditors.get(i2).getComponent(), c);
        }
        JPanel jPanel = result;
        if (jPanel == null) {
            ExtendableSettingsEditor.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionSettingsEditor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/options/ExtendableSettingsEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/options/ExtendableSettingsEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addExtensionEditor";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

