/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeCoreBundle;
import com.intellij.openapi.fileTypes.INativeFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class NativeFileType
implements INativeFileType {
    public static final NativeFileType INSTANCE = new NativeFileType();

    private NativeFileType() {
    }

    @Override
    @NotNull
    public String getName() {
        return "Native";
    }

    @Override
    @NotNull
    public String getDescription() {
        String string = IdeCoreBundle.message("filetype.native.description", new Object[0]);
        if (string == null) {
            NativeFileType.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = IdeCoreBundle.message("filetype.native.display.name", new Object[0]);
        if (string == null) {
            NativeFileType.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String getDefaultExtension() {
        return "";
    }

    @Override
    public Icon getIcon() {
        return AllIcons.FileTypes.Custom;
    }

    @Override
    public boolean isBinary() {
        return true;
    }

    @Override
    public boolean openFileInAssociatedApplication(Project project, @NotNull VirtualFile file) {
        if (file == null) {
            NativeFileType.$$$reportNull$$$0(2);
        }
        return NativeFileType.openAssociatedApplication(file);
    }

    @Override
    public boolean useNativeIcon() {
        return true;
    }

    public static boolean openAssociatedApplication(@NotNull VirtualFile file) {
        if (file == null) {
            NativeFileType.$$$reportNull$$$0(3);
        }
        if (!file.isInLocalFileSystem()) {
            throw new IllegalArgumentException("Non-local file: " + file + "; FS=" + file.getFileSystem());
        }
        ArrayList<String> commands = new ArrayList<String>();
        if (SystemInfo.isWindows) {
            commands.add("rundll32.exe");
            commands.add("url.dll,FileProtocolHandler");
        } else if (SystemInfo.isMac) {
            commands.add("/usr/bin/open");
        } else if (SystemInfo.hasXdgOpen()) {
            commands.add("xdg-open");
        } else {
            return false;
        }
        commands.add(file.getPresentableUrl());
        try {
            new GeneralCommandLine(commands).createProcess();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileTypes/NativeFileType";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileTypes/NativeFileType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "openFileInAssociatedApplication";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "openAssociatedApplication";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

