/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.PathChooserDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.io.FilenameFilter;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileChooser {
    private static final Logger LOG = Logger.getInstance(FileChooser.class);

    private FileChooser() {
    }

    public static VirtualFile @NotNull [] chooseFiles(@NotNull FileChooserDescriptor descriptor, @Nullable Project project, @Nullable VirtualFile toSelect) {
        if (descriptor == null) {
            FileChooser.$$$reportNull$$$0(0);
        }
        return FileChooser.chooseFiles(descriptor, null, project, toSelect);
    }

    public static VirtualFile @NotNull [] chooseFiles(@NotNull FileChooserDescriptor descriptor, @Nullable Component parent, @Nullable Project project, @Nullable VirtualFile toSelect) {
        if (descriptor == null) {
            FileChooser.$$$reportNull$$$0(1);
        }
        FileChooserDialog chooser = FileChooserFactory.getInstance().createFileChooser(descriptor, project, parent);
        VirtualFile[] virtualFileArray = chooser.choose(project, toSelect);
        if (virtualFileArray == null) {
            FileChooser.$$$reportNull$$$0(2);
        }
        return virtualFileArray;
    }

    @Nullable
    public static VirtualFile chooseFile(@NotNull FileChooserDescriptor descriptor, @Nullable Project project, @Nullable VirtualFile toSelect) {
        if (descriptor == null) {
            FileChooser.$$$reportNull$$$0(3);
        }
        return FileChooser.chooseFile(descriptor, null, project, toSelect);
    }

    @Nullable
    public static VirtualFile chooseFile(@NotNull FileChooserDescriptor descriptor, @Nullable Component parent, @Nullable Project project, @Nullable VirtualFile toSelect) {
        if (descriptor == null) {
            FileChooser.$$$reportNull$$$0(4);
        }
        Component parentComponent = parent == null ? KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow() : parent;
        LOG.assertTrue(!descriptor.isChooseMultiple());
        return (VirtualFile)ArrayUtil.getFirstElement((Object[])FileChooser.chooseFiles(descriptor, parentComponent, project, toSelect));
    }

    public static void chooseFiles(@NotNull FileChooserDescriptor descriptor, @Nullable Project project, @Nullable VirtualFile toSelect, @NotNull Consumer<? super List<VirtualFile>> callback) {
        if (descriptor == null) {
            FileChooser.$$$reportNull$$$0(5);
        }
        if (callback == null) {
            FileChooser.$$$reportNull$$$0(6);
        }
        FileChooser.chooseFiles(descriptor, project, null, toSelect, callback);
    }

    public static void chooseFiles(@NotNull FileChooserDescriptor descriptor, @Nullable Project project, @Nullable Component parent, @Nullable VirtualFile toSelect, @NotNull Consumer<? super List<VirtualFile>> callback) {
        if (descriptor == null) {
            FileChooser.$$$reportNull$$$0(7);
        }
        if (callback == null) {
            FileChooser.$$$reportNull$$$0(8);
        }
        Component parentComponent = parent == null ? WindowManager.getInstance().suggestParentWindow(project) : parent;
        FileChooserFactory factory = FileChooserFactory.getInstance();
        PathChooserDialog pathChooser = factory.createPathChooser(descriptor, project, parentComponent);
        pathChooser.choose(toSelect, callback);
    }

    public static void chooseFile(@NotNull FileChooserDescriptor descriptor, @Nullable Project project, @Nullable VirtualFile toSelect, @NotNull Consumer<? super VirtualFile> callback) {
        if (descriptor == null) {
            FileChooser.$$$reportNull$$$0(9);
        }
        if (callback == null) {
            FileChooser.$$$reportNull$$$0(10);
        }
        FileChooser.chooseFile(descriptor, project, null, toSelect, callback);
    }

    public static void chooseFile(@NotNull FileChooserDescriptor descriptor, @Nullable Project project, @Nullable Component parent, @Nullable VirtualFile toSelect, @NotNull Consumer<? super VirtualFile> callback) {
        if (descriptor == null) {
            FileChooser.$$$reportNull$$$0(11);
        }
        if (callback == null) {
            FileChooser.$$$reportNull$$$0(12);
        }
        LOG.assertTrue(!descriptor.isChooseMultiple());
        FileChooser.chooseFiles(descriptor, project, parent, toSelect, (Consumer<? super List<VirtualFile>>)((Consumer)files -> callback.consume(files.get(0))));
    }

    @NotNull
    public static FilenameFilter safeInvokeFilter(@NotNull FilenameFilter filter, boolean defaultValue) {
        if (filter == null) {
            FileChooser.$$$reportNull$$$0(13);
        }
        FilenameFilter filenameFilter = (dir, name) -> {
            try {
                return filter.accept(dir, name);
            }
            catch (Throwable e) {
                LOG.error(e);
                return defaultValue;
            }
        };
        if (filenameFilter == null) {
            FileChooser.$$$reportNull$$$0(14);
        }
        return filenameFilter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileChooser/FileChooser";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileChooser/FileChooser";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "chooseFiles";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "safeInvokeFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "chooseFiles";
                break;
            }
            case 2: 
            case 14: {
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "chooseFile";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "safeInvokeFilter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface FileChooserConsumer
    extends Consumer<List<VirtualFile>> {
        public void cancelled();
    }
}

