/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.LineWrapPositionStrategy;
import com.intellij.openapi.project.Project;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.IntObjectMap;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericLineWrapPositionStrategy
implements LineWrapPositionStrategy {
    private static final int NON_ID_WEIGHT = 4;
    private final IntObjectMap<Rule> myRules = ContainerUtil.createConcurrentIntObjectMap();
    private final Storage myOffset2weight = new Storage();

    @Override
    public int calculateWrapPosition(@NotNull Document document, @Nullable Project project, int startOffset, int endOffset, int maxPreferredOffset, boolean allowToBeyondMaxPreferredOffset, boolean isSoftWrap) {
        if (document == null) {
            GenericLineWrapPositionStrategy.$$$reportNull$$$0(0);
        }
        if (endOffset <= startOffset) {
            return endOffset;
        }
        this.myOffset2weight.clear();
        this.myOffset2weight.anchor = startOffset;
        CharSequence text2 = document.getCharsSequence();
        int maxPreferredOffsetToUse = maxPreferredOffset >= endOffset ? endOffset - 1 : maxPreferredOffset;
        maxPreferredOffsetToUse = Math.max(maxPreferredOffsetToUse, startOffset);
        for (int i2 = Math.min(maxPreferredOffsetToUse, text2.length() - 1); i2 > startOffset; --i2) {
            char c = text2.charAt(i2);
            if (c == '\n') {
                return i2 + 1;
            }
            if (!this.canUseOffset(document, i2, isSoftWrap)) continue;
            Rule rule = (Rule)this.myRules.get((int)c);
            if (rule != null) {
                if (rule.condition == WrapCondition.BOTH || rule.condition == WrapCondition.AFTER) {
                    int target;
                    if (rule.symbol != ' ') {
                        for (target = i2 + 1; target < maxPreferredOffsetToUse && text2.charAt(target) == ' '; ++target) {
                        }
                    }
                    if (target <= maxPreferredOffsetToUse) {
                        this.myOffset2weight.store(target, rule.weight);
                    }
                }
                if (rule.condition != WrapCondition.BOTH && rule.condition != WrapCondition.BEFORE) continue;
                this.myOffset2weight.store(i2, rule.weight);
                continue;
            }
            if (GenericLineWrapPositionStrategy.isIdSymbol(c) || i2 <= startOffset + 1 || !GenericLineWrapPositionStrategy.isIdSymbol(text2.charAt(i2 - 1)) || this.myRules.containsKey((int)text2.charAt(i2 - 1))) continue;
            this.myOffset2weight.store(i2, 4.0);
        }
        int result = this.chooseOffset();
        if (result > 0) {
            return result;
        }
        if (!allowToBeyondMaxPreferredOffset) {
            return -1;
        }
        for (int i3 = Math.min(maxPreferredOffsetToUse + 1, text2.length() - 1); i3 < endOffset; ++i3) {
            char c = text2.charAt(i3);
            if (c == '\n') {
                return i3 + 1;
            }
            if (!this.canUseOffset(document, i3, isSoftWrap)) continue;
            Rule rule = (Rule)this.myRules.get((int)c);
            if (rule != null) {
                switch (rule.condition) {
                    case BOTH: 
                    case BEFORE: {
                        return i3;
                    }
                    case AFTER: {
                        if (i3 >= endOffset - 1) break;
                        return i3 + 1;
                    }
                }
            }
            if (GenericLineWrapPositionStrategy.isIdSymbol(c) || i3 >= endOffset - 1 || !GenericLineWrapPositionStrategy.isIdSymbol(text2.charAt(i3 + 1))) continue;
            return i3;
        }
        return -1;
    }

    protected boolean canUseOffset(@NotNull Document document, int offset, boolean virtual) {
        if (document == null) {
            GenericLineWrapPositionStrategy.$$$reportNull$$$0(1);
        }
        return true;
    }

    public void addRule(@NotNull Rule rule) throws IllegalArgumentException {
        Rule existing;
        if (rule == null) {
            GenericLineWrapPositionStrategy.$$$reportNull$$$0(2);
        }
        if ((existing = (Rule)this.myRules.get((int)rule.symbol)) != null) {
            throw new IllegalArgumentException(String.format("Can't register given wrap rule (%s) within the current line wrap position strategy. Reason: another rule is already registered for it - '%s'", rule, existing));
        }
        existing = (Rule)this.myRules.put((int)rule.symbol, (Object)rule);
        assert (existing == null);
    }

    private static boolean isIdSymbol(char c) {
        return c == '_' || c == '$' || c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private int chooseOffset() {
        if (this.myOffset2weight.end <= 0) {
            return -1;
        }
        double[] resultingWeight = new double[1];
        int[] resultingOffset = new int[1];
        for (int i2 = this.myOffset2weight.end - 1; i2 >= 0; --i2) {
            boolean change;
            if (this.myOffset2weight.data[i2] == 0.0) continue;
            if (resultingWeight[0] <= 0.0) {
                resultingWeight[0] = this.myOffset2weight.data[i2];
                resultingOffset[0] = i2;
                continue;
            }
            if (!(resultingWeight[0] < this.myOffset2weight.data[i2])) continue;
            boolean bl = change = this.myOffset2weight.data[i2] * (double)i2 > (double)resultingOffset[0] * resultingWeight[0];
            if (!change) continue;
            resultingWeight[0] = this.myOffset2weight.data[i2];
            resultingOffset[0] = i2;
        }
        return resultingOffset[0] + this.myOffset2weight.anchor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rule";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/GenericLineWrapPositionStrategy";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateWrapPosition";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "canUseOffset";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addRule";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Storage {
        public double[] data = new double[256];
        public int anchor;
        public int end;

        private Storage() {
        }

        public void store(int key, double value2) {
            int index = key - this.anchor;
            if (index >= this.data.length) {
                int newLength;
                for (newLength = this.data.length << 1; newLength <= index && newLength > 0; newLength <<= 1) {
                }
                this.data = ArrayUtil.realloc((double[])this.data, (int)newLength);
            }
            this.data[index] = value2;
            if (index >= this.end) {
                this.end = index + 1;
            }
        }

        public void clear() {
            this.anchor = 0;
            this.end = 0;
            Arrays.fill(this.data, 0.0);
        }
    }

    public static class Rule {
        public static final int DEFAULT_WEIGHT = 10;
        public final char symbol;
        public final WrapCondition condition;
        public final double weight;

        public Rule(char symbol) {
            this(symbol, WrapCondition.BOTH, 10.0);
        }

        public Rule(char symbol, WrapCondition condition) {
            this(symbol, condition, 10.0);
        }

        public Rule(char symbol, double weight) {
            this(symbol, WrapCondition.BOTH, weight);
        }

        public Rule(char symbol, WrapCondition condition, double weight) {
            this.symbol = symbol;
            this.condition = condition;
            this.weight = weight;
        }
    }

    public static enum WrapCondition {
        AFTER,
        BEFORE,
        BOTH;

    }
}

