/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.XmlDomReader;
import com.intellij.util.XmlElement;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ApplicationNamesInfo {
    private final String myProductName;
    private final String myFullProductName;
    private final String myEditionName;
    private final String myScriptName;
    private final String myDefaultLauncherName;
    private final String myMotto;
    private static volatile ApplicationNamesInfo instance;

    @NotNull
    private static XmlElement loadData() {
        XmlElement xmlElement;
        String prefix;
        block20: {
            prefix = System.getProperty("idea.platform.prefix", "");
            if (Boolean.getBoolean("idea.use.dev.build.server")) {
                String module = null;
                if (prefix.isEmpty() || prefix.equals("idea")) {
                    module = "intellij.idea.ultimate.resources";
                } else if (prefix.equals("WebStorm")) {
                    module = "intellij.webstorm";
                }
                if (module != null) {
                    XmlElement xmlElement2;
                    Path file = Paths.get(PathManager.getHomePath() + "/out/classes/production/" + module + "/idea/" + (prefix.equals("idea") ? "" : prefix) + "ApplicationInfo.xml", new String[0]);
                    try {
                        xmlElement2 = XmlDomReader.readXmlAsModel((InputStream)Files.newInputStream(file, new OpenOption[0]));
                    }
                    catch (NoSuchFileException noSuchFileException) {
                        break block20;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Cannot load " + file, e);
                    }
                    if (xmlElement2 == null) {
                        ApplicationNamesInfo.$$$reportNull$$$0(0);
                    }
                    return xmlElement2;
                }
            } else {
                String customAppInfo;
                if (prefix.equals("Gateway") && (customAppInfo = System.getProperty("idea.application.info.value")) != null) {
                    XmlElement xmlElement3;
                    try {
                        Path file = Paths.get(customAppInfo, new String[0]);
                        xmlElement3 = XmlDomReader.readXmlAsModel((InputStream)Files.newInputStream(file, new OpenOption[0]));
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Cannot load custom application info file " + customAppInfo, e);
                    }
                    if (xmlElement3 == null) {
                        ApplicationNamesInfo.$$$reportNull$$$0(1);
                    }
                    return xmlElement3;
                }
                String appInfoData = ApplicationNamesInfo.getAppInfoData();
                if (!appInfoData.isEmpty()) {
                    XmlElement xmlElement4 = XmlDomReader.readXmlAsModel((byte[])appInfoData.getBytes(StandardCharsets.UTF_8));
                    if (xmlElement4 == null) {
                        ApplicationNamesInfo.$$$reportNull$$$0(2);
                    }
                    return xmlElement4;
                }
            }
        }
        String resource = "idea/" + (prefix.equals("idea") ? "" : prefix) + "ApplicationInfo.xml";
        InputStream stream = ApplicationNamesInfo.class.getClassLoader().getResourceAsStream(resource);
        if (stream == null) {
            throw new RuntimeException("Resource not found: " + resource);
        }
        try {
            xmlElement = XmlDomReader.readXmlAsModel((InputStream)stream);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot load resource: " + resource, e);
        }
        if (xmlElement == null) {
            ApplicationNamesInfo.$$$reportNull$$$0(3);
        }
        return xmlElement;
    }

    private static String getAppInfoData() {
        return "<component xmlns=\"http://jetbrains.org/intellij/schema/application-info\"\n           xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n           xsi:schemaLocation=\"http://jetbrains.org/intellij/schema/application-info http://jetbrains.org/intellij/schema/ApplicationInfo.xsd\">\n  <version major=\"2021\" minor=\"3.2\" suffix=\"\"/>\n  <company name=\"JetBrains s.r.o.\" url=\"https://www.jetbrains.com\"/>\n  <build number=\"IC-213.6777.52\" date=\"202201280347\" majorReleaseDate=\"20211130\" />\n  <logo url=\"/idea_community_logo.png\" textcolor=\"ffffff\" progressColor=\"ffae00\" progressY=\"396\" progressHeight=\"4\" />\n  <about url=\"/idea_community_about.png\" foreground=\"ffffff\" copyrightForeground=\"ffffff\" linkColor=\"095fdc\" logoX=\"540\" logoY=\"300\" logoW=\"100\" logoH=\"100\"/>\n  <icon ico=\"idea_CE.ico\" svg=\"/idea-ce.svg\" svg-small=\"/idea-ce_16.svg\"/>\n  <icon-eap svg=\"/idea-ce-eap.svg\" svg-small=\"/idea-ce-eap_16.svg\"/>\n  <names product=\"IDEA\" fullname=\"IntelliJ IDEA\" edition=\"Community Edition\" script=\"idea\" motto=\"Capable and Ergonomic IDE for JVM\"/>\n  <essential-plugin>com.intellij.java</essential-plugin>\n  <essential-plugin>com.intellij.java.ide</essential-plugin>\n\n  <welcome-screen logo-url=\"/Logo_welcomeScreen_CE.png\"/>\n\n  <editor background-url=\"/idea_logo_welcome.png\"/>\n\n  <plugins url=\"https://plugins.jetbrains.com/\"\n           builtin-url=\"\"/>\n  <update-urls check=\"https://www.jetbrains.com/updates/updates.xml\"\n               patches=\"https://download.jetbrains.com/idea/\"/>\n\n  <help webhelp-url=\"https://www.jetbrains.com/help/idea/\"/>\n  <documentation url=\"https://www.jetbrains.com/idea/resources/\"/>\n  <support url=\"https://intellij-support.jetbrains.com/hc/en-us/requests/new?ticket_form_id=66731&amp;product=IDEA&amp;build=$BUILD&amp;os=$OS&amp;timezone=$TIMEZONE\"/>\n  <youtrack url=\"https://youtrack.jetbrains.com/newissue?project=IDEA&amp;clearDraft=true&amp;description=$DESCR\" />\n  <feedback url=\"https://www.jetbrains.com/feedback/feedback.jsp?product=IDEA&amp;build=$BUILD&amp;timezone=$TIMEZONE&amp;eval=$EVAL\"\n    zendesk-form-id=\"360001912739\" zendesk-url=\"https://jbsintellij.zendesk.com\">\n    <field id=\"28147552\" value=\"ij_idea\"/>\n    <field id=\"28102551\" value=\"sl_unknown\"/>   <!-- country -->\n    <field id=\"29444529\" type=\"rating\"/>\n    <field id=\"28500325\" type=\"build\"/>\n    <field id=\"28151042\" type=\"os\"/>\n    <field id=\"28500645\" type=\"timezone\"/>\n    <field id=\"28351649\" type=\"eval\"/>\n    <field id=\"360021010939\" type=\"systeminfo\"/>\n    <field id=\"22996310\" type=\"needsupport\"/>\n    <field id=\"28116681\" type=\"topic\"/>\n  </feedback>\n  <whatsnew url=\"https://www.jetbrains.com/idea/whatsnew/\" eligibility=\"auto\"/>\n  <keymap win=\"https://www.jetbrains.com/idea/docs/IntelliJIDEA_ReferenceCard.pdf\"\n          mac=\"https://www.jetbrains.com/idea/docs/IntelliJIDEA_ReferenceCard_Mac.pdf\"/>\n  <jetbrains-tv url=\"https://www.youtube.com/user/intellijideavideo\"/>\n\n  <statistics settings=\"https://www.jetbrains.com/idea/statistics/stat-assistant.xml\"\n              service=\"https://www.jetbrains.com/idea/statistics/index.jsp\"\n              fus-settings=\"https://www.jetbrains.com/idea/statistics/fus-assistant.xml\"\n              event-log-settings=\"https://resources.jetbrains.com/storage/fus/config/v4/%s/%s.json\"\n  />\n</component>\n";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    @NotNull
    public static XmlElement initAndGetRawData() {
        Class<ApplicationNamesInfo> clazz = ApplicationNamesInfo.class;
        synchronized (ApplicationNamesInfo.class) {
            XmlElement data = ApplicationNamesInfo.loadData();
            if (instance == null) {
                instance = new ApplicationNamesInfo(data);
            }
            XmlElement xmlElement = data;
            // ** MonitorExit[var0] (shouldn't be in output)
            if (xmlElement == null) {
                ApplicationNamesInfo.$$$reportNull$$$0(4);
            }
            return xmlElement;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public static ApplicationNamesInfo getInstance() {
        ApplicationNamesInfo result = instance;
        if (result == null) {
            Class<ApplicationNamesInfo> clazz = ApplicationNamesInfo.class;
            // MONITORENTER : com.intellij.openapi.application.ApplicationNamesInfo.class
            result = instance;
            if (result == null) {
                instance = result = new ApplicationNamesInfo(ApplicationNamesInfo.loadData());
            }
            // MONITOREXIT : clazz
        }
        ApplicationNamesInfo applicationNamesInfo = result;
        if (applicationNamesInfo != null) return applicationNamesInfo;
        ApplicationNamesInfo.$$$reportNull$$$0(5);
        return applicationNamesInfo;
    }

    private ApplicationNamesInfo(@NotNull XmlElement rootElement) {
        if (rootElement == null) {
            ApplicationNamesInfo.$$$reportNull$$$0(6);
        }
        XmlElement names = rootElement.getChild("names");
        assert (names != null);
        this.myProductName = names.getAttributeValue("product");
        this.myFullProductName = names.getAttributeValue("fullname", this.myProductName);
        this.myEditionName = names.getAttributeValue("edition");
        this.myScriptName = names.getAttributeValue("script");
        this.myDefaultLauncherName = names.getAttributeValue("default-launcher-name", this.myScriptName);
        this.myMotto = names.getAttributeValue("motto", "The Drive to Develop");
    }

    @NlsSafe
    public String getProductName() {
        return this.myProductName;
    }

    @NlsSafe
    public String getFullProductName() {
        return this.myFullProductName;
    }

    @NlsSafe
    public String getFullProductNameWithEdition() {
        return this.myEditionName == null ? this.myFullProductName : this.myFullProductName + ' ' + this.myEditionName;
    }

    @NlsSafe
    @Nullable
    public String getEditionName() {
        return this.myEditionName;
    }

    public String getLowercaseProductName() {
        String s = this.myProductName.toLowerCase(Locale.ENGLISH);
        return Character.isUpperCase(s.charAt(0)) ? s : Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    public String getScriptName() {
        return this.myScriptName;
    }

    public String getDefaultLauncherName() {
        return this.myDefaultLauncherName;
    }

    @NotNull
    public String getMotto() {
        String string = this.myMotto;
        if (string == null) {
            ApplicationNamesInfo.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/application/ApplicationNamesInfo";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "loadData";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "initAndGetRawData";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/application/ApplicationNamesInfo";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMotto";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

