/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.wizard;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.ide.wizard.Step;
import com.intellij.ide.wizard.StepAdapter;
import com.intellij.ide.wizard.StepListener;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.JBCardLayout;
import com.intellij.ui.components.panels.OpaquePanel;
import com.intellij.ui.mac.touchbar.Touchbar;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractWizard<T extends Step>
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(AbstractWizard.class);
    public static final Key<AbstractWizard<?>> KEY = Key.create((String)"AbstractWizard");
    protected int myCurrentStep;
    protected final ArrayList<T> mySteps;
    private JButton myPreviousButton;
    private JButton myNextButton;
    private JButton myCancelButton;
    private JButton myHelpButton;
    protected JPanel myContentPanel;
    protected TallImageComponent myIcon;
    private Component myCurrentStepComponent;
    private JBCardLayout.SwipeDirection myTransitionDirection = JBCardLayout.SwipeDirection.AUTO;
    private final Map<Component, String> myComponentToIdMap = new HashMap<Component, String>();
    private final StepListener myStepListener = new StepListener(){

        @Override
        public void stateChanged() {
            AbstractWizard.this.updateStep();
        }
    };

    public AbstractWizard(@NlsContexts.DialogTitle String title, Component dialogParent) {
        super(dialogParent, true);
        this.mySteps = new ArrayList();
        this.initWizard(title);
    }

    public AbstractWizard(@NlsContexts.DialogTitle String title, @Nullable Project project) {
        super(project, true);
        this.mySteps = new ArrayList();
        this.initWizard(title);
    }

    private void initWizard(@NlsContexts.DialogTitle String title) {
        this.setTitle(title);
        this.myCurrentStep = 0;
        this.myPreviousButton = new JButton(IdeBundle.message("button.wizard.previous", new Object[0]));
        this.myNextButton = new JButton(IdeBundle.message("button.wizard.next", new Object[0]));
        this.myCancelButton = new JButton(CommonBundle.getCancelButtonText());
        this.myHelpButton = AbstractWizard.isNewWizard() ? this.createHelpButton((Insets)JBUI.emptyInsets()) : new JButton(CommonBundle.getHelpButtonText());
        this.myContentPanel = new JPanel(new JBCardLayout());
        this.myIcon = new TallImageComponent(null);
        JRootPane rootPane = this.getRootPane();
        if (rootPane != null) {
            rootPane.registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractWizard.this.helpAction();
                }
            }, KeyStroke.getKeyStroke(112, 0), 2);
            rootPane.registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractWizard.this.helpAction();
                }
            }, KeyStroke.getKeyStroke(156, 0), 2);
        }
    }

    @Override
    protected JComponent createSouthPanel() {
        if (this.useDialogWrapperSouthPanel()) {
            return super.createSouthPanel();
        }
        JPanel panel2 = new JPanel(new BorderLayout());
        int inset = AbstractWizard.isNewWizard() ? 15 : 0;
        panel2.setBorder(AbstractWizard.isNewWizard() ? BorderFactory.createEmptyBorder(4, inset, 4, inset) : BorderFactory.createEmptyBorder(8, inset, 0, inset));
        JPanel buttonPanel = new JPanel();
        if (SystemInfo.isMac) {
            panel2.add((Component)buttonPanel, "East");
            buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
            if (!StartupUiUtil.isUnderDarcula()) {
                this.myHelpButton.putClientProperty("JButton.buttonType", "help");
            }
            ArrayList<JButton> touchbarButtons = new ArrayList<JButton>();
            JPanel leftPanel = new JPanel();
            if (ApplicationInfo.contextHelpAvailable()) {
                leftPanel.add(this.myHelpButton);
                touchbarButtons.add(this.myHelpButton);
            }
            leftPanel.add(this.myCancelButton);
            touchbarButtons.add(this.myCancelButton);
            panel2.add((Component)leftPanel, "West");
            ArrayList<JButton> principalTouchbarButtons = new ArrayList<JButton>();
            if (this.mySteps.size() > 1) {
                buttonPanel.add(Box.createHorizontalStrut(5));
                buttonPanel.add(this.myPreviousButton);
                principalTouchbarButtons.add(this.myPreviousButton);
            }
            buttonPanel.add(Box.createHorizontalStrut(5));
            buttonPanel.add(this.myNextButton);
            principalTouchbarButtons.add(this.myNextButton);
            if (SystemInfo.isMac) {
                Touchbar.setButtonActions(panel2, touchbarButtons, principalTouchbarButtons, this.myNextButton);
            }
        } else {
            panel2.add((Component)buttonPanel, "Center");
            GroupLayout layout = new GroupLayout(buttonPanel);
            buttonPanel.setLayout(layout);
            layout.setAutoCreateGaps(true);
            GroupLayout.SequentialGroup hGroup = layout.createSequentialGroup();
            GroupLayout.ParallelGroup vGroup = layout.createParallelGroup();
            ArrayList buttons = new ArrayList(5);
            boolean helpAvailable = ApplicationInfo.contextHelpAvailable();
            AbstractWizard.add(hGroup, vGroup, null, Box.createHorizontalGlue());
            if (this.mySteps.size() > 1) {
                AbstractWizard.add(hGroup, vGroup, buttons, this.myPreviousButton);
            }
            AbstractWizard.add(hGroup, vGroup, buttons, this.myNextButton, this.myCancelButton);
            if (helpAvailable) {
                AbstractWizard.add(hGroup, vGroup, buttons, this.myHelpButton);
            }
            layout.setHorizontalGroup(hGroup);
            layout.setVerticalGroup(vGroup);
            layout.linkSize(buttons.toArray(new Component[0]));
        }
        this.myPreviousButton.setEnabled(false);
        this.myPreviousButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractWizard.this.doPreviousAction();
            }
        });
        this.myNextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractWizard.this.proceedToNextStep();
            }
        });
        this.myCancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractWizard.this.doCancelAction();
            }
        });
        if (!AbstractWizard.isNewWizard()) {
            this.myHelpButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractWizard.this.helpAction();
                }
            });
        }
        return panel2;
    }

    protected boolean useDialogWrapperSouthPanel() {
        return false;
    }

    public void proceedToNextStep() {
        if (this.isLastStep()) {
            Step currentStep = (Step)this.mySteps.get(this.myCurrentStep);
            LOG.assertTrue(currentStep != null);
            try {
                currentStep._commit(true);
                this.doOKAction();
            }
            catch (CommitStepException exc) {
                String message = exc.getMessage();
                if (message != null) {
                    Messages.showErrorDialog(this.myContentPanel, message);
                }
            }
        } else {
            this.doNextAction();
        }
    }

    public JPanel getContentComponent() {
        return this.myContentPanel;
    }

    private static void add(GroupLayout.Group hGroup, GroupLayout.Group vGroup, @Nullable Collection<? super Component> collection, Component ... components) {
        for (Component component : components) {
            hGroup.addComponent(component);
            vGroup.addComponent(component);
            if (collection == null) continue;
            collection.add(component);
        }
    }

    @Override
    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)this.myIcon, "West");
        panel2.add((Component)this.myContentPanel, "Center");
        return panel2;
    }

    public int getCurrentStep() {
        return this.myCurrentStep;
    }

    public int getStepCount() {
        return this.mySteps.size();
    }

    public T getCurrentStepObject() {
        return (T)((Step)this.mySteps.get(this.myCurrentStep));
    }

    public void addStep(@NotNull T step) {
        if (step == null) {
            AbstractWizard.$$$reportNull$$$0(0);
        }
        this.addStep(step, this.mySteps.size());
    }

    public void addStep(@NotNull T step, int index) {
        JComponent component;
        if (step == null) {
            AbstractWizard.$$$reportNull$$$0(1);
        }
        this.mySteps.add(index, step);
        if (step instanceof StepAdapter) {
            ((StepAdapter)step).registerStepListener(this.myStepListener);
        }
        if ((component = step.getComponent()) != null) {
            this.addStepComponent(component);
        }
    }

    @Override
    protected void init() {
        super.init();
        this.updateStep();
    }

    protected String addStepComponent(@NotNull Component component) {
        String id;
        if (component == null) {
            AbstractWizard.$$$reportNull$$$0(2);
        }
        if (component instanceof JPanel) {
            ((JPanel)component).putClientProperty(DIALOG_CONTENT_PANEL_PROPERTY, true);
        }
        if ((id = this.myComponentToIdMap.get(component)) == null) {
            id = Integer.toString(this.myComponentToIdMap.size());
            this.myComponentToIdMap.put(component, id);
            this.myContentPanel.add(component, id);
        }
        return id;
    }

    private void showStepComponent(Component component) {
        String id = this.myComponentToIdMap.get(component);
        if (id == null) {
            id = this.addStepComponent(component);
            this.myContentPanel.revalidate();
            this.myContentPanel.repaint();
        }
        ((JBCardLayout)this.myContentPanel.getLayout()).swipe(this.myContentPanel, id, this.myTransitionDirection);
    }

    protected void doPreviousAction() {
        Step currentStep = (Step)this.mySteps.get(this.myCurrentStep);
        LOG.assertTrue(currentStep != null);
        try {
            currentStep._commit(false);
        }
        catch (CommitStepException exc) {
            Messages.showErrorDialog(this.myContentPanel, exc.getMessage());
            return;
        }
        this.myCurrentStep = this.getPreviousStep(this.myCurrentStep);
        this.updateStep(JBCardLayout.SwipeDirection.BACKWARD);
    }

    protected final void updateStep(JBCardLayout.SwipeDirection direction) {
        try {
            this.myTransitionDirection = direction;
            this.updateStep();
        }
        finally {
            this.myTransitionDirection = JBCardLayout.SwipeDirection.AUTO;
        }
    }

    protected void doNextAction() {
        Step currentStep = (Step)this.mySteps.get(this.myCurrentStep);
        LOG.assertTrue(currentStep != null);
        LOG.assertTrue(!this.isLastStep(), (Object)("steps: " + this.mySteps + " current: " + currentStep));
        try {
            currentStep._commit(false);
        }
        catch (CommitStepException exc) {
            Messages.showErrorDialog(this.myContentPanel, exc.getMessage());
            return;
        }
        this.myCurrentStep = this.getNextStep(this.myCurrentStep);
        this.updateStep(JBCardLayout.SwipeDirection.FORWARD);
    }

    protected int getNextStep(int step) {
        int stepCount = this.mySteps.size();
        if (++step >= stepCount) {
            step = stepCount - 1;
        }
        return step;
    }

    protected final int getNextStep() {
        return this.getNextStep(this.getCurrentStep());
    }

    protected T getNextStepObject() {
        int step = this.getNextStep();
        return (T)((Step)this.mySteps.get(step));
    }

    protected int getPreviousStep(int step) {
        if (--step < 0) {
            step = 0;
        }
        return step;
    }

    protected final int getPreviousStep() {
        return this.getPreviousStep(this.getCurrentStep());
    }

    protected void updateStep() {
        if (this.mySteps.isEmpty()) {
            return;
        }
        Step step = (Step)this.mySteps.get(this.myCurrentStep);
        LOG.assertTrue(step != null);
        step._init();
        this.myCurrentStepComponent = step.getComponent();
        LOG.assertTrue(this.myCurrentStepComponent != null);
        this.showStepComponent(this.myCurrentStepComponent);
        Icon icon2 = step.getIcon();
        if (icon2 != null) {
            this.myIcon.setIcon(icon2);
            this.myIcon.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 8));
        }
        this.updateButtons();
        JComponent component = ((Step)this.mySteps.get(this.getCurrentStep())).getPreferredFocusedComponent();
        AbstractWizard.requestFocusTo(component != null ? component : this.myNextButton);
    }

    private static void requestFocusTo(JComponent component) {
        UiNotifyConnector.doWhenFirstShown(component, () -> {
            IdeFocusManager focusManager = IdeFocusManager.findInstanceByComponent(component);
            focusManager.requestFocus(component, false);
        });
    }

    @Override
    @Nullable
    public JComponent getPreferredFocusedComponent() {
        JComponent component = this.getCurrentStepObject().getPreferredFocusedComponent();
        return component == null ? super.getPreferredFocusedComponent() : component;
    }

    protected boolean canGoNext() {
        return true;
    }

    protected boolean canFinish() {
        return this.isLastStep() && this.canGoNext();
    }

    protected void updateButtons() {
        boolean lastStep;
        this.updateButtons(lastStep, (lastStep = this.isLastStep()) ? this.canFinish() : this.canGoNext(), this.isFirstStep());
    }

    public void updateWizardButtons() {
        if (!this.mySteps.isEmpty() && this.getRootPane() != null) {
            this.updateButtons();
        }
    }

    public void updateButtons(boolean lastStep, boolean canGoNext, boolean firstStep) {
        if (lastStep) {
            if (this.mySteps.size() > 1) {
                this.myNextButton.setText(UIUtil.removeMnemonic((String)IdeBundle.message(AbstractWizard.isNewWizard() ? "button.create" : "button.finish", new Object[0])));
                this.myNextButton.setMnemonic(AbstractWizard.isNewWizard() ? (char)'C' : 'F');
            } else {
                this.myNextButton.setText(IdeBundle.message("button.ok", new Object[0]));
            }
        } else {
            this.myNextButton.setText(UIUtil.removeMnemonic((String)IdeBundle.message("button.wizard.next", new Object[0])));
            this.myNextButton.setMnemonic('N');
        }
        this.myNextButton.setEnabled(canGoNext);
        if (this.myNextButton.isEnabled() && !ApplicationManager.getApplication().isUnitTestMode() && this.getRootPane() != null) {
            this.getRootPane().setDefaultButton(this.myNextButton);
        }
        this.myPreviousButton.setEnabled(!firstStep);
        if (AbstractWizard.isNewWizard()) {
            this.myPreviousButton.setVisible(!firstStep);
        }
    }

    public static boolean isNewWizard() {
        return Experiments.getInstance().isFeatureEnabled("new.project.wizard");
    }

    protected boolean isFirstStep() {
        return this.myCurrentStep == 0;
    }

    protected boolean isLastStep() {
        return this.myCurrentStep == this.mySteps.size() - 1 || this.getCurrentStep() == this.getNextStep(this.getCurrentStep());
    }

    protected JButton getNextButton() {
        return this.myNextButton;
    }

    protected JButton getPreviousButton() {
        return this.myPreviousButton;
    }

    protected JButton getHelpButton() {
        return this.myHelpButton;
    }

    public JButton getCancelButton() {
        return this.myCancelButton;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    protected JButton getFinishButton() {
        return new JButton();
    }

    public Component getCurrentStepComponent() {
        return this.myCurrentStepComponent;
    }

    protected void helpAction() {
        HelpManager.getInstance().invokeHelp(this.getHelpID());
    }

    @Override
    protected Action @NotNull [] createActions() {
        if (this.useDialogWrapperSouthPanel()) {
            throw new UnsupportedOperationException("Not implemented");
        }
        Action[] actionArray = super.createActions();
        if (actionArray == null) {
            AbstractWizard.$$$reportNull$$$0(3);
        }
        return actionArray;
    }

    @Override
    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp(this.getHelpID());
    }

    protected int getNumberOfSteps() {
        return this.mySteps.size();
    }

    @Nullable
    @NonNls
    protected abstract String getHelpID();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "step";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/wizard/AbstractWizard";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/wizard/AbstractWizard";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addStep";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addStepComponent";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class TallImageComponent
    extends OpaquePanel {
        private Icon myIcon;

        private TallImageComponent(Icon icon2) {
            this.myIcon = icon2;
        }

        @Override
        protected void paintChildren(Graphics g) {
            if (this.myIcon == null) {
                return;
            }
            this.paintIcon(g);
        }

        public void paintIcon(Graphics g) {
            if (this.myIcon == null) {
                return;
            }
            BufferedImage image = ImageUtil.createImage((Graphics)g, (int)this.myIcon.getIconWidth(), (int)this.myIcon.getIconHeight(), (int)2);
            Graphics2D gg = image.createGraphics();
            this.myIcon.paintIcon(this, gg, 0, 0);
            Rectangle bounds = g.getClipBounds();
            for (int y = this.myIcon.getIconHeight() - 1; y < bounds.y + bounds.height; ++y) {
                g.drawImage(image, bounds.x, y, bounds.x + bounds.width, y + 1, 0, this.myIcon.getIconHeight() - 1, bounds.width, this.myIcon.getIconHeight(), this);
            }
            g.drawImage(image, 0, 0, this);
        }

        public void setIcon(Icon icon2) {
            this.myIcon = icon2;
            this.revalidate();
            this.repaint();
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.myIcon != null ? this.myIcon.getIconWidth() : 0, 0);
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(this.myIcon != null ? this.myIcon.getIconWidth() : 0, 0);
        }
    }
}

