/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PresentableNodeDescriptor<E>
extends NodeDescriptor<E> {
    private PresentationData myTemplatePresentation;
    private PresentationData myUpdatedPresentation;

    protected PresentableNodeDescriptor(Project project, @Nullable NodeDescriptor parentDescriptor) {
        super(project, parentDescriptor);
    }

    @Override
    public final boolean update() {
        if (this.shouldUpdateData()) {
            PresentationData before = this.getPresentation().clone();
            PresentationData updated = this.getUpdatedPresentation();
            return this.shouldApply() && this.apply(updated, before);
        }
        return false;
    }

    protected final boolean apply(@NotNull PresentationData presentation) {
        if (presentation == null) {
            PresentableNodeDescriptor.$$$reportNull$$$0(0);
        }
        return this.apply(presentation, null);
    }

    @Override
    public void applyFrom(@NotNull NodeDescriptor desc) {
        if (desc == null) {
            PresentableNodeDescriptor.$$$reportNull$$$0(1);
        }
        if (desc instanceof PresentableNodeDescriptor) {
            this.apply(((PresentableNodeDescriptor)desc).getPresentation());
        } else {
            super.applyFrom(desc);
        }
    }

    protected final boolean apply(@NotNull PresentationData presentation, @Nullable PresentationData before) {
        boolean updated;
        if (presentation == null) {
            PresentableNodeDescriptor.$$$reportNull$$$0(2);
        }
        this.setIcon(presentation.getIcon(false));
        this.myName = presentation.getPresentableText();
        this.myColor = presentation.getForcedTextForeground();
        boolean bl = updated = !presentation.equals(before);
        if (this.myUpdatedPresentation == null) {
            this.myUpdatedPresentation = this.createPresentation();
        }
        this.myUpdatedPresentation.copyFrom(presentation);
        if (this.myTemplatePresentation != null) {
            this.myUpdatedPresentation.applyFrom(this.myTemplatePresentation);
        }
        this.myUpdatedPresentation.setChanged(false);
        return updated |= this.myUpdatedPresentation.isChanged();
    }

    @NotNull
    private PresentationData getUpdatedPresentation() {
        PresentationData presentation;
        this.myUpdatedPresentation = presentation = this.myUpdatedPresentation != null ? this.myUpdatedPresentation : this.createPresentation();
        presentation.clear();
        presentation.setBackground(this.computeBackgroundColor());
        this.update(presentation);
        if (this.shouldPostprocess()) {
            this.postprocess(presentation);
        }
        PresentationData presentationData = presentation;
        if (presentationData == null) {
            PresentableNodeDescriptor.$$$reportNull$$$0(3);
        }
        return presentationData;
    }

    @NotNull
    protected PresentationData createPresentation() {
        return new PresentationData();
    }

    protected void postprocess(@NotNull PresentationData date) {
        if (date == null) {
            PresentableNodeDescriptor.$$$reportNull$$$0(4);
        }
    }

    protected boolean shouldPostprocess() {
        return true;
    }

    protected boolean shouldApply() {
        return true;
    }

    protected boolean shouldUpdateData() {
        return true;
    }

    @RequiresReadLock(generateAssertion=false)
    @RequiresBackgroundThread(generateAssertion=false)
    @Nullable
    protected Color computeBackgroundColor() {
        return null;
    }

    protected abstract void update(@NotNull PresentationData var1);

    @NotNull
    public final PresentationData getPresentation() {
        PresentationData presentationData = this.myUpdatedPresentation == null ? this.getTemplatePresentation() : this.myUpdatedPresentation;
        if (presentationData == null) {
            PresentableNodeDescriptor.$$$reportNull$$$0(5);
        }
        return presentationData;
    }

    @NotNull
    protected final PresentationData getTemplatePresentation() {
        if (this.myTemplatePresentation == null) {
            this.myTemplatePresentation = this.createPresentation();
        }
        PresentationData presentationData = this.myTemplatePresentation;
        if (presentationData == null) {
            PresentableNodeDescriptor.$$$reportNull$$$0(6);
        }
        return presentationData;
    }

    public boolean isContentHighlighted() {
        return false;
    }

    public boolean isHighlightableContentNode(@NotNull PresentableNodeDescriptor kid) {
        if (kid == null) {
            PresentableNodeDescriptor.$$$reportNull$$$0(7);
        }
        return true;
    }

    public PresentableNodeDescriptor<?> getChildToHighlightAt(int index) {
        return null;
    }

    public boolean isParentOf(@NotNull NodeDescriptor eachNode) {
        if (eachNode == null) {
            PresentableNodeDescriptor.$$$reportNull$$$0(8);
        }
        for (NodeDescriptor<?> eachParent = eachNode.getParentDescriptor(); eachParent != null; eachParent = eachParent.getParentDescriptor()) {
            if (eachParent != this) continue;
            return true;
        }
        return false;
    }

    public boolean isAncestorOrSelf(NodeDescriptor selectedNode) {
        for (NodeDescriptor<?> node = selectedNode; node != null; node = node.getParentDescriptor()) {
            if (!this.equals(node)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Color getHighlightColor() {
        Color color = StartupUiUtil.isUnderDarcula() ? ColorUtil.shift((Color)UIUtil.getTreeBackground(), (double)1.1) : UIUtil.getTreeBackground().brighter();
        if (color == null) {
            PresentableNodeDescriptor.$$$reportNull$$$0(9);
        }
        return color;
    }

    @NlsSafe
    public String getName() {
        if (!this.getPresentation().getColoredText().isEmpty()) {
            StringBuilder result = new StringBuilder();
            for (ColoredFragment each : this.getPresentation().getColoredText()) {
                result.append(each.getText());
            }
            return result.toString();
        }
        return this.myName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "desc";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/treeView/PresentableNodeDescriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "date";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kid";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eachNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/treeView/PresentableNodeDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpdatedPresentation";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplatePresentation";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightColor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyFrom";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "postprocess";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isHighlightableContentNode";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isParentOf";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ColoredFragment {
        @NlsSafe
        private final String myText;
        @NlsSafe
        private final String myToolTip;
        private final SimpleTextAttributes myAttributes;

        public ColoredFragment(@NlsSafe String aText, SimpleTextAttributes aAttributes) {
            this(aText, null, aAttributes);
        }

        public ColoredFragment(@NlsSafe String aText, @NlsSafe String toolTip, SimpleTextAttributes aAttributes) {
            this.myText = aText == null ? "" : aText;
            this.myAttributes = aAttributes;
            this.myToolTip = toolTip;
        }

        @NlsSafe
        public String getToolTip() {
            return this.myToolTip;
        }

        @NlsSafe
        public String getText() {
            return this.myText;
        }

        public SimpleTextAttributes getAttributes() {
            return this.myAttributes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ColoredFragment that = (ColoredFragment)o;
            if (this.myAttributes != null ? !this.myAttributes.equals((Object)that.myAttributes) : that.myAttributes != null) {
                return false;
            }
            if (this.myText != null ? !this.myText.equals(that.myText) : that.myText != null) {
                return false;
            }
            return !(this.myToolTip != null ? !this.myToolTip.equals(that.myToolTip) : that.myToolTip != null);
        }

        public int hashCode() {
            int result = this.myText != null ? this.myText.hashCode() : 0;
            result = 31 * result + (this.myToolTip != null ? this.myToolTip.hashCode() : 0);
            result = 31 * result + (this.myAttributes != null ? this.myAttributes.hashCode() : 0);
            return result;
        }
    }
}

