/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Comparator;

public class FileNameComparator
implements Comparator<String> {
    public static final Comparator<String> INSTANCE = new FileNameComparator();

    @Override
    public int compare(String s1, String s2) {
        Pair<String, String> normalized = FileNameComparator.normalize(s1, s2);
        return StringUtil.naturalCompare((String)((String)normalized.first), (String)((String)normalized.second));
    }

    private static Pair<String, String> normalize(String s1, String s2) {
        int minLen = Math.min(s1.length(), s2.length());
        StringBuilder sb1 = null;
        StringBuilder sb2 = null;
        for (int i2 = 0; i2 < minLen; ++i2) {
            boolean needSwap2;
            char ch1 = s1.charAt(i2);
            char ch2 = s2.charAt(i2);
            boolean needSwap1 = ch1 == '-' && ch2 != '_';
            boolean bl = needSwap2 = ch2 == '-' && ch1 != '_';
            if (needSwap1) {
                if (sb1 == null) {
                    sb1 = new StringBuilder(s1);
                }
                sb1.setCharAt(i2, '_');
            }
            if (!needSwap2) continue;
            if (sb2 == null) {
                sb2 = new StringBuilder(s2);
            }
            sb2.setCharAt(i2, '_');
        }
        if (sb1 != null) {
            s1 = sb1.toString();
        }
        if (sb2 != null) {
            s2 = sb2.toString();
        }
        return Pair.create((Object)s1, (Object)s2);
    }
}

