/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.users;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.diagnostic.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\r\u001a\u00020\u0004R$\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ide/users/LocalUserSettings;", "", "()V", "value", "", "userName", "getUserName", "()Ljava/lang/String;", "setUserName", "(Ljava/lang/String;)V", "userNameDefault", "userNameKey", "userNameObsoleteKey", "getDefaultSystemUserName", "intellij.platform.remote.core"})
public final class LocalUserSettings {
    private static final String userNameKey = "local.user.name";
    private static final String userNameObsoleteKey = "code.with.me.user.name";
    private static final String userNameDefault = "User";
    @NotNull
    public static final LocalUserSettings INSTANCE;

    @NotNull
    public final String getUserName() {
        String value2 = PropertiesComponent.getInstance().getValue(userNameKey);
        if (value2 == null && (value2 = PropertiesComponent.getInstance().getValue(userNameObsoleteKey)) != null) {
            PropertiesComponent.getInstance().setValue(userNameKey, value2);
            PropertiesComponent.getInstance().setValue(userNameObsoleteKey, null);
        }
        if (value2 != null) {
            CharSequence charSequence = value2;
            boolean bl = false;
            if (!StringsKt.isBlank((CharSequence)charSequence)) {
                return value2;
            }
        }
        return this.getDefaultSystemUserName();
    }

    public final void setUserName(@NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        PropertiesComponent.getInstance().setValue(userNameKey, value2);
    }

    @NotNull
    public final String getDefaultSystemUserName() {
        try {
            String string = System.getProperty("user.name");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"System.getProperty(\"user.name\")");
            return string;
        }
        catch (Throwable ex) {
            Logger.getInstance(LocalUserSettings.class).error(ex);
            return userNameDefault;
        }
    }

    private LocalUserSettings() {
    }

    static {
        LocalUserSettings localUserSettings;
        INSTANCE = localUserSettings = new LocalUserSettings();
    }
}

