/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.lightEdit;

import com.intellij.ide.lightEdit.LightEditorInfo;
import com.intellij.ide.lightEdit.LightEditorManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import java.util.Collection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public interface LightEditService {
    public static final String WINDOW_NAME = "LightEdit";

    public boolean isLightEditEnabled();

    public boolean isForceOpenInLightEditMode();

    public static LightEditService getInstance() {
        return (LightEditService)ApplicationManager.getApplication().getService(LightEditService.class);
    }

    public LightEditorInfo createNewDocument(@Nullable Path var1);

    public void saveToAnotherFile(@NotNull VirtualFile var1);

    public void showEditorWindow();

    @Nullable
    public Project getProject();

    @NotNull
    public Project openFile(@NotNull VirtualFile var1);

    @Nullable
    public Project openFile(@NotNull Path var1, boolean var2);

    public boolean isAutosaveMode();

    public void setAutosaveMode(boolean var1);

    public boolean closeEditorWindow();

    @NotNull
    public LightEditorManager getEditorManager();

    @Nullable
    public VirtualFile getSelectedFile();

    @Nullable
    public FileEditor getSelectedFileEditor();

    public void updateFileStatus(@NotNull Collection<? extends VirtualFile> var1);

    public void saveNewDocuments();

    public boolean isTabNavigationAvailable(@NotNull AnAction var1);

    public void navigateToTab(@NotNull AnAction var1);

    public boolean isPreferProjectMode();
}

