/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.util;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.util.ListTableWithButtons;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.ui.ListTableModel;

final class PathMappingTable
extends ListTableWithButtons<PathMappingSettings.PathMapping> {
    PathMappingTable() {
        this.getTableView().getEmptyText().setText(ExecutionBundle.message("empty.text.no.mappings", new Object[0]));
    }

    @Override
    protected ListTableModel createListModel() {
        ListTableWithButtons.ElementsColumnInfoBase<PathMappingSettings.PathMapping> local = new ListTableWithButtons.ElementsColumnInfoBase<PathMappingSettings.PathMapping>(ExecutionBundle.message("path.mapping.column.path.local", new Object[0])){

            @Override
            @NlsSafe
            public String valueOf(PathMappingSettings.PathMapping pathMapping) {
                return pathMapping.getLocalRoot();
            }

            @Override
            public boolean isCellEditable(PathMappingSettings.PathMapping pathMapping) {
                return PathMappingTable.this.canDeleteElement(pathMapping);
            }

            @Override
            public void setValue(PathMappingSettings.PathMapping pathMapping, String s) {
                if (s.equals(this.valueOf(pathMapping))) {
                    return;
                }
                pathMapping.setLocalRoot(s);
                PathMappingTable.this.setModified();
            }

            @Override
            protected String getDescription(PathMappingSettings.PathMapping pathMapping) {
                return this.valueOf(pathMapping);
            }
        };
        ListTableWithButtons.ElementsColumnInfoBase<PathMappingSettings.PathMapping> remote = new ListTableWithButtons.ElementsColumnInfoBase<PathMappingSettings.PathMapping>(ExecutionBundle.message("path.mapping.column.path.remote", new Object[0])){

            @Override
            @NlsSafe
            public String valueOf(PathMappingSettings.PathMapping pathMapping) {
                return pathMapping.getRemoteRoot();
            }

            @Override
            public boolean isCellEditable(PathMappingSettings.PathMapping pathMapping) {
                return PathMappingTable.this.canDeleteElement(pathMapping);
            }

            @Override
            public void setValue(PathMappingSettings.PathMapping pathMapping, String s) {
                if (s.equals(this.valueOf(pathMapping))) {
                    return;
                }
                pathMapping.setRemoteRoot(s);
                PathMappingTable.this.setModified();
            }

            @Override
            protected String getDescription(PathMappingSettings.PathMapping pathMapping) {
                return this.valueOf(pathMapping);
            }
        };
        return new ListTableModel(local, remote);
    }

    public PathMappingSettings getPathMappingSettings() {
        return new PathMappingSettings(this.getElements());
    }

    @Override
    protected PathMappingSettings.PathMapping createElement() {
        return new PathMappingSettings.PathMapping();
    }

    @Override
    protected boolean isEmpty(PathMappingSettings.PathMapping element) {
        return StringUtil.isEmpty((String)element.getLocalRoot()) && StringUtil.isEmpty((String)element.getRemoteRoot());
    }

    @Override
    protected PathMappingSettings.PathMapping cloneElement(PathMappingSettings.PathMapping envVariable) {
        return envVariable.clone();
    }

    @Override
    protected boolean canDeleteElement(PathMappingSettings.PathMapping selection) {
        return true;
    }
}

