/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.InheritanceUtil;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrMapType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrTraitType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;
import org.jetbrains.plugins.groovy.lang.resolve.api.JustTypeArgument;
import org.jetbrains.plugins.groovy.lang.resolve.impl.GroovyMapPropertyImpl;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u00000\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a$\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a$\u0010\t\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a$\u0010\n\u001a\u00020\u0001*\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a$\u0010\f\u001a\u00020\u0001*\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\"\u0010\r\u001a\u00020\u0001*\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a$\u0010\u000f\u001a\u00020\u0001*\u0004\u0018\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u0010"}, d2={"doProcessReceiverType", "", "Lcom/intellij/psi/PsiType;", "processor", "Lcom/intellij/psi/scope/PsiScopeProcessor;", "state", "Lcom/intellij/psi/ResolveState;", "place", "Lcom/intellij/psi/PsiElement;", "doProcessReceiverType0", "processClassType", "Lcom/intellij/psi/PsiClassType;", "processMapType", "processReceiver", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Argument;", "processReceiverType", "intellij.groovy.psi"})
public final class ReceiverKt {
    public static final boolean processReceiver(@NotNull Argument $this$processReceiver, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place) {
        Intrinsics.checkNotNullParameter((Object)$this$processReceiver, (String)"$this$processReceiver");
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        PsiType psiType = $this$processReceiver.getTopLevelType();
        if (psiType == null) {
            PsiClassType psiClassType = TypesUtil.getJavaLangObject(place);
            Intrinsics.checkNotNullExpressionValue((Object)psiClassType, (String)"TypesUtil.getJavaLangObject(place)");
            psiType = (PsiType)psiClassType;
        }
        if (psiType == null) {
            return true;
        }
        PsiType receiverType = psiType;
        ResolveState resolveState = state.put(ClassHint.RECEIVER, (Object)$this$processReceiver);
        Intrinsics.checkNotNullExpressionValue((Object)resolveState, (String)"state.put(ClassHint.RECEIVER, this)");
        return ReceiverKt.doProcessReceiverType0(receiverType, processor, resolveState, place);
    }

    public static final boolean processReceiverType(@Nullable PsiType $this$processReceiverType, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place) {
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        if ($this$processReceiverType == null) {
            return true;
        }
        ResolveState resolveState = state.put(ClassHint.RECEIVER, (Object)new JustTypeArgument($this$processReceiverType));
        Intrinsics.checkNotNullExpressionValue((Object)resolveState, (String)"state.put(ClassHint.RECE\u2026, JustTypeArgument(this))");
        return ReceiverKt.doProcessReceiverType0($this$processReceiverType, processor, resolveState, place);
    }

    private static final boolean doProcessReceiverType0(PsiType $this$doProcessReceiverType0, PsiScopeProcessor processor, ResolveState state, PsiElement place) {
        if (!ReceiverKt.doProcessReceiverType($this$doProcessReceiverType0, processor, state, place)) {
            return false;
        }
        return !ResolveUtilKt.processNonCodeMembers(state) || ResolveUtil.processNonCodeMembers($this$doProcessReceiverType0, processor, place, state);
    }

    private static final boolean doProcessReceiverType(PsiType $this$doProcessReceiverType, PsiScopeProcessor processor, ResolveState state, PsiElement place) {
        boolean bl;
        block21: {
            PsiType psiType = $this$doProcessReceiverType;
            if (psiType instanceof PsiPrimitiveType) {
                PsiClassType psiClassType = ((PsiPrimitiveType)$this$doProcessReceiverType).getBoxedType(place);
                bl = psiClassType != null ? ReceiverKt.processReceiverType((PsiType)psiClassType, processor, state, place) : true;
            } else if (psiType instanceof PsiDisjunctionType) {
                bl = ReceiverKt.processReceiverType(((PsiDisjunctionType)$this$doProcessReceiverType).getLeastUpperBound(), processor, state, place);
            } else if (psiType instanceof PsiIntersectionType) {
                PsiType[] psiTypeArray = ((PsiIntersectionType)$this$doProcessReceiverType).getConjuncts();
                Intrinsics.checkNotNullExpressionValue((Object)psiTypeArray, (String)"conjuncts");
                PsiType[] $this$all$iv = psiTypeArray;
                boolean $i$f$all = false;
                PsiType[] psiTypeArray2 = $this$all$iv;
                int n = psiTypeArray2.length;
                for (int i = 0; i < n; ++i) {
                    PsiType element$iv;
                    PsiType it = element$iv = psiTypeArray2[i];
                    boolean bl2 = false;
                    if (ReceiverKt.processReceiverType(it, processor, state, place)) continue;
                    bl = false;
                    break block21;
                }
                bl = true;
            } else if (psiType instanceof PsiCapturedWildcardType) {
                bl = ReceiverKt.processReceiverType(((PsiCapturedWildcardType)$this$doProcessReceiverType).getUpperBound(), processor, state, place);
            } else if (psiType instanceof PsiWildcardType) {
                bl = !((PsiWildcardType)$this$doProcessReceiverType).isExtends() || ReceiverKt.processReceiverType(((PsiWildcardType)$this$doProcessReceiverType).getExtendsBound(), processor, state, place);
            } else if (psiType instanceof GrTraitType) {
                Object[] objectArray = ((GrTraitType)$this$doProcessReceiverType).getConjuncts();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"conjuncts");
                Iterable $this$all$iv = ArraysKt.reversed((Object[])objectArray);
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        PsiType it = (PsiType)element$iv;
                        boolean bl3 = false;
                        if (ReceiverKt.processReceiverType(it, processor, state, place)) continue;
                        bl = false;
                        break block21;
                    }
                    bl = true;
                }
            } else if (psiType instanceof PsiArrayType) {
                GrTypeDefinition grTypeDefinition = GroovyPsiManager.getInstance(place.getProject()).getArrayClass(((PsiArrayType)$this$doProcessReceiverType).getComponentType());
                if (grTypeDefinition == null) {
                    return true;
                }
                Intrinsics.checkNotNullExpressionValue((Object)grTypeDefinition, (String)"GroovyPsiManager.getInst\u2026onentType) ?: return true");
                GrTypeDefinition arrayClass = grTypeDefinition;
                bl = ResolveUtil.processClassDeclarations(arrayClass, processor, state, null, place);
            } else if (psiType instanceof PsiClassType) {
                bl = ReceiverKt.processClassType((PsiClassType)$this$doProcessReceiverType, processor, state, place);
            } else {
                return true;
            }
        }
        return bl;
    }

    private static final boolean processClassType(PsiClassType $this$processClassType, PsiScopeProcessor processor, ResolveState state, PsiElement place) {
        PsiClassType.ClassResolveResult classResolveResult = $this$processClassType.resolveGenerics();
        Intrinsics.checkNotNullExpressionValue((Object)classResolveResult, (String)"resolveGenerics()");
        PsiClassType.ClassResolveResult result2 = classResolveResult;
        PsiClass psiClass = result2.getElement();
        if (psiClass == null) {
            return true;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"result.element ?: return true");
        PsiClass clazz = psiClass;
        ResolveState resolveState = state.put(PsiSubstitutor.KEY, (Object)((PsiSubstitutor)state.get(PsiSubstitutor.KEY)).putAll(result2.getSubstitutor()));
        Intrinsics.checkNotNullExpressionValue((Object)resolveState, (String)"state.put(PsiSubstitutor\u2026tAll(result.substitutor))");
        ResolveState newState = resolveState;
        if (Intrinsics.areEqual((Object)((Boolean)state.get(ClassHint.STATIC_CONTEXT)), (Object)true) ^ true && Intrinsics.areEqual((Object)clazz.getQualifiedName(), (Object)"java.lang.Class")) {
            Object[] objectArray = $this$processClassType.getParameters();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"parameters");
            Object object = ArraysKt.singleOrNull((Object[])objectArray);
            if (!(object instanceof PsiClassType)) {
                object = null;
            }
            PsiClassType type2 = (PsiClassType)object;
            PsiType psiType = (PsiType)type2;
            ResolveState resolveState2 = newState.put(ClassHint.STATIC_CONTEXT, (Object)true);
            Intrinsics.checkNotNullExpressionValue((Object)resolveState2, (String)"newState.put(STATIC_CONTEXT, true)");
            if (!ReceiverKt.processReceiverType(psiType, processor, resolveState2, place)) {
                return false;
            }
        }
        if (!ReceiverKt.processMapType($this$processClassType, processor, newState, place)) {
            return false;
        }
        return ResolveUtil.processClassDeclarations(clazz, processor, newState, null, place);
    }

    private static final boolean processMapType(PsiClassType $this$processMapType, PsiScopeProcessor processor, ResolveState state, PsiElement place) {
        GroovyMapPropertyImpl property;
        if (Intrinsics.areEqual((Object)((Boolean)state.get(ClassHint.STATIC_CONTEXT)), (Object)true)) {
            return true;
        }
        if (!ResolveUtilKt.shouldProcessProperties(processor)) {
            return true;
        }
        if (!($this$processMapType instanceof GrMapType) && !InheritanceUtil.isInheritor((PsiType)((PsiType)$this$processMapType), (String)"java.util.Map")) {
            return true;
        }
        String name = ResolveUtilKt.getName(processor, state);
        if (name != null && !processor.execute((PsiElement)(property = new GroovyMapPropertyImpl($this$processMapType, name, place)), state)) {
            return false;
        }
        return ResolveUtilKt.shouldProcessMethods(processor);
    }
}

