/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef.members;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaDocumentedElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiSuperMethodImplUtil;
import com.intellij.psi.presentation.java.JavaPresentationUtil;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.ui.IconManager;
import com.intellij.ui.icons.RowIcon;
import com.intellij.util.IncorrectOperationException;
import icons.JetgroovyIcons;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.extensions.NamedArgumentDescriptor;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.impl.GrDocCommentUtil;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyEmptyStubElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyStubElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrThrowsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifier;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrNamedArgumentSearchVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrReflectedMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameterList;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrStubElementBase;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyFileImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrReflectedMethodImpl;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrMethodStub;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.MethodTypeInferencer;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtilKt;

public abstract class GrMethodBaseImpl
extends GrStubElementBase<GrMethodStub>
implements GrMethod,
StubBasedPsiElement<GrMethodStub> {
    private static final Logger LOG = Logger.getInstance(GrMethodBaseImpl.class);
    private static final Function<GrMethodBaseImpl, PsiType> ourTypesCalculator = method -> {
        PsiType inferred;
        PsiType nominal = method.getNominalType();
        if (!(nominal == null || nominal instanceof PsiClassType && GrMethodBaseImpl.hasTypeParametersToInfer((PsiClassType)nominal))) {
            return nominal;
        }
        GrOpenBlock block = method.getBlock();
        if (block != null && (inferred = GroovyPsiManager.inferType(method, new MethodTypeInferencer(block))) != null && (nominal == null || nominal.isAssignableFrom(inferred) && !inferred.equals(PsiType.NULL))) {
            return inferred;
        }
        if (nominal != null) {
            return nominal;
        }
        return TypesUtil.getJavaLangObject(method);
    };

    protected GrMethodBaseImpl(GrMethodStub stub, IStubElementType nodeType) {
        super(stub, nodeType);
    }

    public GrMethodBaseImpl(ASTNode node) {
        super(node);
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        if (visitor2 == null) {
            GrMethodBaseImpl.$$$reportNull$$$0(0);
        }
        visitor2.visitMethod(this);
    }

    public int getTextOffset() {
        return this.getNameIdentifierGroovy().getTextRange().getStartOffset();
    }

    @Override
    @NotNull
    public PsiElement getNameIdentifierGroovy() {
        PsiElement psiElement = this.findNotNullChildByType(TokenSets.PROPERTY_NAMES);
        if (psiElement == null) {
            GrMethodBaseImpl.$$$reportNull$$$0(1);
        }
        return psiElement;
    }

    @Override
    @Nullable
    public GrOpenBlock getBlock() {
        return (GrOpenBlock)this.findChildByClass(GrOpenBlock.class);
    }

    @Override
    public boolean hasBlock() {
        GrMethodStub stub = (GrMethodStub)this.getStub();
        return stub != null ? stub.hasBlock() : GrMethod.super.hasBlock();
    }

    @Override
    public void setBlock(GrCodeBlock newBlock) {
        ASTNode newNode = newBlock.getNode().copyElement();
        GrOpenBlock oldBlock = this.getBlock();
        if (oldBlock == null) {
            this.getNode().addChild(newNode);
            return;
        }
        this.getNode().replaceChild(oldBlock.getNode(), newNode);
    }

    @Override
    public GrParameter @NotNull [] getParameters() {
        GrParameter[] grParameterArray = this.getParameterList().getParameters();
        if (grParameterArray == null) {
            GrMethodBaseImpl.$$$reportNull$$$0(2);
        }
        return grParameterArray;
    }

    @Override
    @Nullable
    public GrTypeElement getReturnTypeElementGroovy() {
        GrMethodStub stub = (GrMethodStub)this.getStub();
        if (stub != null) {
            String typeText = stub.getTypeText();
            if (typeText != null) {
                return GroovyPsiElementFactory.getInstance(this.getProject()).createTypeElement(typeText, this);
            }
            return null;
        }
        return (GrTypeElement)this.findChildByType(TokenSets.TYPE_ELEMENTS);
    }

    @Override
    public PsiType getInferredReturnType() {
        if (this.isConstructor()) {
            return null;
        }
        return (PsiType)TypeInferenceHelper.inTopContext(() -> (PsiType)CachedValuesManager.getProjectPsiDependentCache((PsiElement)this, ourTypesCalculator));
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        GrTypeParameterList list;
        if (processor == null) {
            GrMethodBaseImpl.$$$reportNull$$$0(3);
        }
        if (state == null) {
            GrMethodBaseImpl.$$$reportNull$$$0(4);
        }
        if (place == null) {
            GrMethodBaseImpl.$$$reportNull$$$0(5);
        }
        if ((list = this.getTypeParameterList()) != null && !list.processDeclarations(processor, state, lastParent, place)) {
            return false;
        }
        if (ResolveUtilKt.shouldProcessLocals(processor)) {
            for (GrParameter parameter : this.getParameters()) {
                if (ResolveUtil.processElement(processor, (PsiNamedElement)parameter, state)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public GrMember[] getMembers() {
        return new GrMember[]{this};
    }

    private static boolean hasTypeParametersToInfer(PsiClassType classType) {
        PsiClassType.ClassResolveResult resolveResult2 = classType.resolveGenerics();
        PsiClass aClass = resolveResult2.getElement();
        if (aClass == null) {
            return false;
        }
        Iterable iterable = com.intellij.psi.util.PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)aClass);
        if (!iterable.iterator().hasNext()) {
            return false;
        }
        for (PsiTypeParameter parameter : iterable) {
            PsiType type2 = resolveResult2.getSubstitutor().substitute(parameter);
            if (type2 == null || type2 instanceof PsiWildcardType && ((PsiWildcardType)type2).getBound() == null) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nullable
    public PsiType getReturnType() {
        if (this.isConstructor()) {
            return null;
        }
        PsiType type2 = this.getNominalType();
        if (type2 != null) {
            return type2;
        }
        return TypesUtil.getJavaLangObject(this);
    }

    @Nullable
    private PsiType getNominalType() {
        if (PsiImplUtil.isMainMethod(this)) {
            return PsiType.VOID;
        }
        GrTypeElement element = this.getReturnTypeElementGroovy();
        if (element != null) {
            return element.getType();
        }
        return null;
    }

    @Override
    @Nullable
    public GrTypeElement setReturnType(@Nullable PsiType newReturnType) {
        GrTypeElement newTypeElement;
        GrTypeElement typeElement = this.getReturnTypeElementGroovy();
        if (newReturnType == null || newReturnType == PsiType.NULL) {
            if (typeElement != null) {
                typeElement.delete();
            }
            this.insertPlaceHolderToModifierList();
            return null;
        }
        GrTypeElement stub = GroovyPsiElementFactory.getInstance(this.getProject()).createTypeElement(newReturnType);
        if (typeElement == null) {
            GrTypeParameterList typeParameterList = this.getTypeParameterList();
            GroovyPsiElement anchor = typeParameterList != null ? typeParameterList : this.getModifierList();
            newTypeElement = (GrTypeElement)this.addAfter(stub, anchor);
        } else {
            newTypeElement = (GrTypeElement)typeElement.replace(stub);
        }
        return newTypeElement;
    }

    private void insertPlaceHolderToModifierList() {
        GrModifierList list = this.getModifierList();
        PsiImplUtil.insertPlaceHolderToModifierListAtEndIfNeeded(list);
    }

    protected boolean isVisibilitySupported() {
        return true;
    }

    @Nullable
    protected Icon getElementIcon(@Iconable.IconFlags int flags) {
        Icon methodIcon = this.hasModifierProperty("abstract") ? JetgroovyIcons.Groovy.AbstractMethod : JetgroovyIcons.Groovy.Method;
        RowIcon baseIcon = IconManager.getInstance().createLayeredIcon((Iconable)this, methodIcon, ElementPresentationUtil.getFlags((PsiModifierListOwner)this, (boolean)false));
        return ElementPresentationUtil.addVisibilityIcon((PsiModifierListOwner)this, (int)flags, (RowIcon)baseIcon);
    }

    public ItemPresentation getPresentation() {
        return JavaPresentationUtil.getMethodPresentation((PsiMethod)this);
    }

    @Nullable
    public PsiTypeElement getReturnTypeElement() {
        return PsiImplUtil.getOrCreateTypeElement(this.getReturnTypeElementGroovy());
    }

    @Override
    @NotNull
    public GrParameterList getParameterList() {
        GrParameterList parameterList = (GrParameterList)this.getStubOrPsiChild((IStubElementType)GroovyEmptyStubElementTypes.PARAMETER_LIST);
        LOG.assertTrue(parameterList != null);
        GrParameterList grParameterList = parameterList;
        if (grParameterList == null) {
            GrMethodBaseImpl.$$$reportNull$$$0(6);
        }
        return grParameterList;
    }

    @NotNull
    public PsiReferenceList getThrowsList() {
        PsiReferenceList psiReferenceList = Objects.requireNonNull((GrThrowsClause)this.getStubOrPsiChild(GroovyStubElementTypes.THROWS_CLAUSE));
        if (psiReferenceList == null) {
            GrMethodBaseImpl.$$$reportNull$$$0(7);
        }
        return psiReferenceList;
    }

    @Nullable
    public PsiCodeBlock getBody() {
        return PsiImplUtil.getOrCreatePsiCodeBlock(this.getBlock());
    }

    public boolean isConstructor() {
        return false;
    }

    @Override
    public boolean isVarArgs() {
        return PsiImplUtil.isVarArgs(this.getParameters());
    }

    @NotNull
    public MethodSignature getSignature(@NotNull PsiSubstitutor substitutor2) {
        if (substitutor2 == null) {
            GrMethodBaseImpl.$$$reportNull$$$0(8);
        }
        MethodSignatureBackedByPsiMethod methodSignatureBackedByPsiMethod = MethodSignatureBackedByPsiMethod.create((PsiMethod)this, (PsiSubstitutor)substitutor2);
        if (methodSignatureBackedByPsiMethod == null) {
            GrMethodBaseImpl.$$$reportNull$$$0(9);
        }
        return methodSignatureBackedByPsiMethod;
    }

    @Nullable
    public PsiIdentifier getNameIdentifier() {
        return PsiUtil.getJavaNameIdentifier(this);
    }

    public PsiMethod @NotNull [] findDeepestSuperMethods() {
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findDeepestSuperMethods((PsiMethod)this);
        if (psiMethodArray == null) {
            GrMethodBaseImpl.$$$reportNull$$$0(10);
        }
        return psiMethodArray;
    }

    public PsiMethod @NotNull [] findSuperMethods(boolean checkAccess) {
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethods((PsiMethod)this, (boolean)checkAccess);
        if (psiMethodArray == null) {
            GrMethodBaseImpl.$$$reportNull$$$0(11);
        }
        return psiMethodArray;
    }

    public PsiMethod @NotNull [] findSuperMethods(PsiClass parentClass) {
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethods((PsiMethod)this, (PsiClass)parentClass);
        if (psiMethodArray == null) {
            GrMethodBaseImpl.$$$reportNull$$$0(12);
        }
        return psiMethodArray;
    }

    @NotNull
    public List<MethodSignatureBackedByPsiMethod> findSuperMethodSignaturesIncludingStatic(boolean checkAccess) {
        List list = PsiSuperMethodImplUtil.findSuperMethodSignaturesIncludingStatic((PsiMethod)this, (boolean)checkAccess);
        if (list == null) {
            GrMethodBaseImpl.$$$reportNull$$$0(13);
        }
        return list;
    }

    public PsiMethod @NotNull [] findSuperMethods() {
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethods((PsiMethod)this);
        if (psiMethodArray == null) {
            GrMethodBaseImpl.$$$reportNull$$$0(14);
        }
        return psiMethodArray;
    }

    @Nullable
    public PsiMethod findDeepestSuperMethod() {
        PsiMethod[] methods = this.findDeepestSuperMethods();
        if (methods.length > 0) {
            return methods[0];
        }
        return null;
    }

    @Override
    @NotNull
    public GrModifierList getModifierList() {
        GrModifierList grModifierList = Objects.requireNonNull((GrModifierList)this.getStubOrPsiChild(GroovyStubElementTypes.MODIFIER_LIST));
        if (grModifierList == null) {
            GrMethodBaseImpl.$$$reportNull$$$0(15);
        }
        return grModifierList;
    }

    public boolean hasModifierProperty(@GrModifier.GrModifierConstant @NonNls @NotNull String name) {
        if (name == null) {
            GrMethodBaseImpl.$$$reportNull$$$0(16);
        }
        return this.getModifierList().hasModifierProperty(name);
    }

    @Override
    @NlsSafe
    @NotNull
    public String getName() {
        GrMethodStub stub = (GrMethodStub)this.getStub();
        if (stub != null) {
            String string = stub.getName();
            if (string == null) {
                GrMethodBaseImpl.$$$reportNull$$$0(17);
            }
            return string;
        }
        String string = PsiImplUtil.getName(this);
        if (string == null) {
            GrMethodBaseImpl.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    public HierarchicalMethodSignature getHierarchicalMethodSignature() {
        HierarchicalMethodSignature hierarchicalMethodSignature = PsiSuperMethodImplUtil.getHierarchicalMethodSignature((PsiMethod)this);
        if (hierarchicalMethodSignature == null) {
            GrMethodBaseImpl.$$$reportNull$$$0(19);
        }
        return hierarchicalMethodSignature;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        PsiElement newNameElement;
        if (name == null) {
            GrMethodBaseImpl.$$$reportNull$$$0(20);
        }
        PsiElement nameElement = this.getNameIdentifierGroovy();
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(nameElement.getProject());
        if (PsiNameHelper.getInstance((Project)this.getProject()).isIdentifier(name)) {
            try {
                GrMethod method = factory.createMethod(name, null);
                newNameElement = method.getNameIdentifierGroovy();
            }
            catch (IncorrectOperationException e) {
                newNameElement = factory.createLiteralFromValue(name).getFirstChild();
            }
        } else {
            newNameElement = factory.createLiteralFromValue(name).getFirstChild();
        }
        nameElement.replace(newNameElement);
        return this;
    }

    @Override
    public boolean hasTypeParameters() {
        return this.getTypeParameters().length > 0;
    }

    @Override
    @Nullable
    public GrTypeParameterList getTypeParameterList() {
        return (GrTypeParameterList)this.getStubOrPsiChild((IStubElementType)GroovyEmptyStubElementTypes.TYPE_PARAMETER_LIST);
    }

    public GrTypeParameter @NotNull [] getTypeParameters() {
        GrTypeParameterList list = this.getTypeParameterList();
        if (list != null) {
            GrTypeParameter[] grTypeParameterArray = list.getTypeParameters();
            if (grTypeParameterArray == null) {
                GrMethodBaseImpl.$$$reportNull$$$0(21);
            }
            return grTypeParameterArray;
        }
        if (GrTypeParameter.EMPTY_ARRAY == null) {
            GrMethodBaseImpl.$$$reportNull$$$0(22);
        }
        return GrTypeParameter.EMPTY_ARRAY;
    }

    public PsiClass getContainingClass() {
        PsiElement grandParent;
        PsiElement parent2 = this.getParent();
        if (parent2 instanceof GrTypeDefinitionBody && (grandParent = parent2.getParent()) instanceof PsiClass) {
            return (PsiClass)grandParent;
        }
        PsiFile file = this.getContainingFile();
        if (file instanceof GroovyFileBase) {
            return ((GroovyFileBase)file).getScriptClass();
        }
        return null;
    }

    @Override
    @Nullable
    public GrDocComment getDocComment() {
        GrMethodStub stub = (GrMethodStub)this.getStub();
        if (stub != null && !stub.hasComment()) {
            return null;
        }
        return GrDocCommentUtil.findDocComment(this);
    }

    @Override
    public boolean isDeprecated() {
        GrMethodStub stub = (GrMethodStub)this.getStub();
        if (stub != null) {
            return stub.isDeprecatedByDoc() || com.intellij.psi.impl.PsiImplUtil.isDeprecatedByAnnotation((PsiModifierListOwner)this);
        }
        return com.intellij.psi.impl.PsiImplUtil.isDeprecatedByDocTag((PsiJavaDocumentedElement)this) || com.intellij.psi.impl.PsiImplUtil.isDeprecatedByAnnotation((PsiModifierListOwner)this);
    }

    @NotNull
    public SearchScope getUseScope() {
        SearchScope searchScope = com.intellij.psi.impl.PsiImplUtil.getMemberUseScope((PsiMember)this);
        if (searchScope == null) {
            GrMethodBaseImpl.$$$reportNull$$$0(23);
        }
        return searchScope;
    }

    public PsiElement getOriginalElement() {
        PsiClass containingClass = this.getContainingClass();
        if (containingClass == null) {
            return this;
        }
        PsiClass originalClass = (PsiClass)containingClass.getOriginalElement();
        PsiMethod originalMethod = originalClass.findMethodBySignature((PsiMethod)this, false);
        return originalMethod != null ? originalMethod : this;
    }

    @Override
    public void delete() throws IncorrectOperationException {
        PsiElement parent2 = this.getParent();
        if (parent2 instanceof GroovyFileImpl || parent2 instanceof GrTypeDefinitionBody) {
            super.delete();
            return;
        }
        throw new IncorrectOperationException("Invalid enclosing type definition");
    }

    @Override
    @NotNull
    public Map<String, NamedArgumentDescriptor> getNamedParameters() {
        GrMethodStub stub = (GrMethodStub)this.getStub();
        if (stub != null) {
            String[] namedParameters = stub.getNamedParameters();
            if (namedParameters.length == 0) {
                Map<String, NamedArgumentDescriptor> map2 = Collections.emptyMap();
                if (map2 == null) {
                    GrMethodBaseImpl.$$$reportNull$$$0(24);
                }
                return map2;
            }
            HashMap<String, NamedArgumentDescriptor> result2 = new HashMap<String, NamedArgumentDescriptor>();
            for (String parameter : namedParameters) {
                result2.put(parameter, GrNamedArgumentSearchVisitor.CODE_NAMED_ARGUMENTS_DESCR);
            }
            HashMap<String, NamedArgumentDescriptor> hashMap = result2;
            if (hashMap == null) {
                GrMethodBaseImpl.$$$reportNull$$$0(25);
            }
            return hashMap;
        }
        GrOpenBlock body = this.getBlock();
        if (body == null) {
            Map<String, NamedArgumentDescriptor> map3 = Collections.emptyMap();
            if (map3 == null) {
                GrMethodBaseImpl.$$$reportNull$$$0(26);
            }
            return map3;
        }
        GrParameter[] parameters2 = this.getParameters();
        if (parameters2.length == 0) {
            Map<String, NamedArgumentDescriptor> map4 = Collections.emptyMap();
            if (map4 == null) {
                GrMethodBaseImpl.$$$reportNull$$$0(27);
            }
            return map4;
        }
        GrParameter firstParameter = parameters2[0];
        PsiType type2 = firstParameter.getTypeGroovy();
        GrTypeElement typeElement = firstParameter.getTypeElementGroovy();
        if (type2 != null && typeElement != null && !type2.getPresentableText().endsWith("Map")) {
            Map<String, NamedArgumentDescriptor> map5 = Collections.emptyMap();
            if (map5 == null) {
                GrMethodBaseImpl.$$$reportNull$$$0(28);
            }
            return map5;
        }
        GrNamedArgumentSearchVisitor visitor2 = new GrNamedArgumentSearchVisitor(firstParameter.getNameIdentifierGroovy().getText());
        body.accept(visitor2);
        Map<String, NamedArgumentDescriptor> map6 = visitor2.getResult();
        if (map6 == null) {
            GrMethodBaseImpl.$$$reportNull$$$0(29);
        }
        return map6;
    }

    public boolean isEquivalentTo(PsiElement another) {
        return PsiClassImplUtil.isMethodEquivalentTo((PsiMethod)this, (PsiElement)another);
    }

    @Override
    public GrReflectedMethod @NotNull [] getReflectedMethods() {
        GrReflectedMethod[] grReflectedMethodArray = GrReflectedMethodImpl.createReflectedMethods(this);
        if (grReflectedMethodArray == null) {
            GrMethodBaseImpl.$$$reportNull$$$0(30);
        }
        return grReflectedMethodArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/members/GrMethodBaseImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/members/GrMethodBaseImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameIdentifierGroovy";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterList";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getThrowsList";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignature";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findDeepestSuperMethods";
                break;
            }
            case 11: 
            case 12: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "findSuperMethods";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findSuperMethodSignaturesIncludingStatic";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifierList";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getHierarchicalMethodSignature";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParameters";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamedParameters";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getReflectedMethods";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSignature";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "hasModifierProperty";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

