/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.config;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.JarVersionDetectionUtil;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.jar.Attributes;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.util.LibrariesUtil;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0015\u0010\u0005\u001a\t\u0018\u00010\u0001\u00a2\u0006\u0002\b\u00062\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a8\u0006\b"}, d2={"doGetSdkVersion", "", "module", "Lcom/intellij/openapi/module/Module;", "fromJar", "getSdkVersion", "Lcom/intellij/openapi/util/NlsSafe;", "getSdkVersionFromHome", "intellij.groovy.psi"})
public final class GroovyConfigUtilsKt {
    @Nullable
    public static final String getSdkVersion(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return (String)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, new CachedValueProvider(module){
            final /* synthetic */ Module $module;

            @Nullable
            public final CachedValueProvider.Result<String> compute() {
                return CachedValueProvider.Result.create((Object)GroovyConfigUtilsKt.access$doGetSdkVersion(this.$module), (Object[])new Object[]{ProjectRootManager.getInstance((Project)this.$module.getProject())});
            }
            {
                this.$module = module;
            }
        });
    }

    private static final String doGetSdkVersion(Module module) {
        String string = GroovyConfigUtilsKt.fromJar(module);
        if (string == null) {
            string = GroovyConfigUtilsKt.getSdkVersionFromHome(module);
        }
        return string;
    }

    private static final String fromJar(Module module) {
        VirtualFile virtualFile = LibrariesUtil.findJarWithClass(module, "org.codehaus.groovy.control.CompilationUnit");
        if (virtualFile == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"findJarWithClass(module,\u2026OVY_CLASS) ?: return null");
        VirtualFile jar = virtualFile;
        VirtualFile virtualFile2 = JarFileSystem.getInstance().getJarRootForLocalFile(jar);
        if (virtualFile2 == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"JarFileSystem.getInstanc\u2026lFile(jar) ?: return null");
        VirtualFile jarRoot = virtualFile2;
        return JarVersionDetectionUtil.getMainAttribute((VirtualFile)jarRoot, (Attributes.Name)Attributes.Name.IMPLEMENTATION_VERSION);
    }

    private static final String getSdkVersionFromHome(Module module) {
        String string = LibrariesUtil.getGroovyHomePath(module);
        if (string == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"LibrariesUtil.getGroovyH\u2026th(module) ?: return null");
        String path = string;
        String string2 = GroovyConfigUtils.getInstance().getSDKVersion(path);
        boolean bl = false;
        boolean bl2 = false;
        String it = string2;
        boolean bl3 = false;
        return !Intrinsics.areEqual((Object)it, (Object)"undefined") ? string2 : null;
    }

    public static final /* synthetic */ String access$doGetSdkVersion(Module module) {
        return GroovyConfigUtilsKt.doGetSdkVersion(module);
    }
}

