/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.config;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.config.AbstractConfigUtils;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtilsKt;
import org.jetbrains.plugins.groovy.util.LibrariesUtil;

public final class GroovyConfigUtils
extends AbstractConfigUtils {
    @NonNls
    public static final Pattern GROOVY_ALL_JAR_PATTERN = Pattern.compile("groovy-all(-minimal)?(-(?<version>\\d+(\\.\\d+)*(-(?!indy)\\w+(-\\d+)?)?))?(-indy)?\\.jar");
    @NonNls
    public static final Pattern GROOVY_JAR_PATTERN = Pattern.compile("groovy(-(?<version>\\d+(\\.\\d+)*(-(?!indy)\\w+(-\\d+)?)?))?(-indy)?\\.jar");
    @NlsSafe
    public static final String NO_VERSION = "<no version>";
    @NlsSafe
    public static final String GROOVY1_7 = "1.7";
    @NlsSafe
    public static final String GROOVY1_8 = "1.8";
    @NlsSafe
    public static final String GROOVY2_0 = "2.0";
    @NlsSafe
    public static final String GROOVY2_1 = "2.1";
    @NlsSafe
    public static final String GROOVY2_2 = "2.2";
    @NlsSafe
    public static final String GROOVY2_2_2 = "2.2.2";
    @NlsSafe
    public static final String GROOVY2_5_2 = "2.5.2";
    @NlsSafe
    public static final String GROOVY2_3 = "2.3";
    @NlsSafe
    public static final String GROOVY2_4 = "2.4";
    @NlsSafe
    public static final String GROOVY2_5 = "2.5";
    @NlsSafe
    public static final String GROOVY3_0 = "3.0";
    @NlsSafe
    public static final String GROOVY4_0 = "4.0";
    @Deprecated(since="2022.1", forRemoval=true)
    @NlsSafe
    public static final String GROOVY4_0_BETA_2 = "4.0.0-beta-2";
    private static final GroovyConfigUtils ourGroovyConfigUtils = new GroovyConfigUtils();
    @NonNls
    private static final String LIB = "/lib";
    @NonNls
    private static final String EMBEDDABLE = "/embeddable";
    @NlsSafe
    private static final String ALPHA = "alpha";
    @NlsSafe
    private static final String BETA = "beta";
    @NlsSafe
    private static final String RC = "rc";
    @NlsSafe
    private static final String SNAPSHOT = "SNAPSHOT";

    private GroovyConfigUtils() {
    }

    public static GroovyConfigUtils getInstance() {
        return ourGroovyConfigUtils;
    }

    public static File @NotNull [] getGroovyAllJars(@NotNull String path) {
        if (path == null) {
            GroovyConfigUtils.$$$reportNull$$$0(0);
        }
        File[] fileArray = LibrariesUtil.getFilesInDirectoryByPattern(path, GROOVY_ALL_JAR_PATTERN);
        if (fileArray == null) {
            GroovyConfigUtils.$$$reportNull$$$0(1);
        }
        return fileArray;
    }

    public static boolean matchesGroovyAll(@NotNull String name) {
        if (name == null) {
            GroovyConfigUtils.$$$reportNull$$$0(2);
        }
        return GROOVY_ALL_JAR_PATTERN.matcher(name).matches() && !name.contains("src") && !name.contains("doc");
    }

    public static boolean isAtLeastGroovy25(@NotNull PsiElement element) {
        if (element == null) {
            GroovyConfigUtils.$$$reportNull$$$0(3);
        }
        return GroovyConfigUtils.getInstance().isVersionAtLeast(element, GROOVY2_5);
    }

    public static boolean isAtLeastGroovy40(@NotNull PsiElement element) {
        if (element == null) {
            GroovyConfigUtils.$$$reportNull$$$0(4);
        }
        return GroovyConfigUtils.getInstance().isVersionAtLeast(element, GROOVY4_0);
    }

    @Override
    @NlsSafe
    @Nullable
    public String getSDKVersionOrNull(@NlsSafe @NotNull String path) {
        String groovyJarVersion;
        if (path == null) {
            GroovyConfigUtils.$$$reportNull$$$0(5);
        }
        if ((groovyJarVersion = GroovyConfigUtils.getSDKJarVersion(path + LIB, GROOVY_JAR_PATTERN, "META-INF/MANIFEST.MF")) == null) {
            groovyJarVersion = GroovyConfigUtils.getSDKJarVersion(path + LIB, GROOVY_ALL_JAR_PATTERN, "META-INF/MANIFEST.MF");
        }
        if (groovyJarVersion == null) {
            groovyJarVersion = GroovyConfigUtils.getSDKJarVersion(path + EMBEDDABLE, GROOVY_ALL_JAR_PATTERN, "META-INF/MANIFEST.MF");
        }
        if (groovyJarVersion == null) {
            groovyJarVersion = GroovyConfigUtils.getSDKJarVersion(path, GROOVY_ALL_JAR_PATTERN, "META-INF/MANIFEST.MF");
        }
        if (groovyJarVersion == null) {
            groovyJarVersion = GroovyConfigUtils.getSDKJarVersion(path, GROOVY_JAR_PATTERN, "META-INF/MANIFEST.MF");
        }
        return groovyJarVersion;
    }

    @Override
    public boolean isSDKLibrary(Library library) {
        if (library == null) {
            return false;
        }
        return LibrariesUtil.getGroovyLibraryHome(library.getFiles(OrderRootType.CLASSES)) != null;
    }

    @Nullable
    @NlsSafe
    public String getSDKVersion(@NotNull Module module) {
        if (module == null) {
            GroovyConfigUtils.$$$reportNull$$$0(6);
        }
        return GroovyConfigUtilsKt.getSdkVersion(module);
    }

    public boolean isVersionAtLeast(PsiElement psiElement, String version) {
        return this.isVersionAtLeast(psiElement, version, true);
    }

    public boolean isVersionAtLeast(PsiElement psiElement, String version, boolean unknownResult) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
        if (module == null) {
            return unknownResult;
        }
        String sdkVersion = this.getSDKVersion(module);
        if (sdkVersion == null) {
            return unknownResult;
        }
        return GroovyConfigUtils.compareSdkVersions(sdkVersion, version) >= 0;
    }

    public static int compareSdkVersions(@NotNull String leftVersion, @NotNull String rightVersion) {
        if (leftVersion == null) {
            GroovyConfigUtils.$$$reportNull$$$0(7);
        }
        if (rightVersion == null) {
            GroovyConfigUtils.$$$reportNull$$$0(8);
        }
        String[] leftVersionParts = leftVersion.split("[.-]");
        String[] rightVersionParts = rightVersion.split("[.-]");
        int sizes = Math.max(leftVersionParts.length, rightVersionParts.length);
        for (int i = 0; i < sizes; ++i) {
            int rightNumber;
            int leftNumber = GroovyConfigUtils.getVersionPart(leftVersionParts, i);
            if (leftNumber < (rightNumber = GroovyConfigUtils.getVersionPart(rightVersionParts, i))) {
                return -1;
            }
            if (leftNumber <= rightNumber) continue;
            return 1;
        }
        return 0;
    }

    public static boolean isUnstable(@NotNull String version) {
        if (version == null) {
            GroovyConfigUtils.$$$reportNull$$$0(9);
        }
        return version.contains(ALPHA) || version.contains(BETA) || version.contains(RC);
    }

    private static int getVersionPart(String[] parts, int index) {
        String part;
        String string = part = index < parts.length ? parts[index] : "-4";
        if (part.equals(SNAPSHOT)) {
            return 999;
        }
        if (part.equals(ALPHA)) {
            return -3;
        }
        if (part.equals(BETA)) {
            return -2;
        }
        if (part.equals(RC)) {
            return -1;
        }
        try {
            return Integer.parseInt(part);
        }
        catch (NumberFormatException __) {
            return -4;
        }
    }

    @NotNull
    @NlsSafe
    public String getSDKVersion(PsiElement psiElement) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
        if (module == null) {
            return NO_VERSION;
        }
        String s = this.getSDKVersion(module);
        return s != null ? s : NO_VERSION;
    }

    @Override
    public boolean isSDKHome(VirtualFile file) {
        String path;
        return file != null && file.isDirectory() && (LibrariesUtil.getFilesInDirectoryByPattern((path = file.getPath()) + LIB, GROOVY_JAR_PATTERN).length > 0 || LibrariesUtil.getFilesInDirectoryByPattern(path + EMBEDDABLE, GROOVY_ALL_JAR_PATTERN).length > 0 || LibrariesUtil.getFilesInDirectoryByPattern(path, GROOVY_JAR_PATTERN).length > 0);
    }

    @NotNull
    public String getSDKLibVersion(Library library) {
        String string = this.getSDKVersion(LibrariesUtil.getGroovyLibraryHome(library));
        if (string == null) {
            GroovyConfigUtils.$$$reportNull$$$0(10);
        }
        return string;
    }

    public Collection<String> getSDKVersions(Library[] libraries) {
        return ContainerUtil.map2List((Object[])libraries, library -> this.getSDKLibVersion((Library)library));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/config/GroovyConfigUtils";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftVersion";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightVersion";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/config/GroovyConfigUtils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroovyAllJars";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSDKLibVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getGroovyAllJars";
                break;
            }
            case 1: 
            case 10: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "matchesGroovyAll";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAtLeastGroovy25";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAtLeastGroovy40";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSDKVersionOrNull";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSDKVersion";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "compareSdkVersions";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isUnstable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

