/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.unassignedVariable;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.GrInspectionUtil;
import org.jetbrains.plugins.groovy.codeInspection.GroovyLocalInspectionBase;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrTraditionalForClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ControlFlowBuilderUtil;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReadWriteVariableInstruction;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class UnassignedVariableAccessInspection
extends GroovyLocalInspectionBase {
    public boolean myIgnoreBooleanExpressions = true;

    @NotNull
    public String getShortName() {
        return "GroovyVariableNotAssigned";
    }

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(GroovyBundle.message("ignore.boolean.expressions", new Object[0]), "myIgnoreBooleanExpressions");
        return optionsPanel;
    }

    @Override
    protected void check(@NotNull GrControlFlowOwner owner, @NotNull ProblemsHolder problemsHolder) {
        ReadWriteVariableInstruction[] reads;
        if (owner == null) {
            UnassignedVariableAccessInspection.$$$reportNull$$$0(0);
        }
        if (problemsHolder == null) {
            UnassignedVariableAccessInspection.$$$reportNull$$$0(1);
        }
        Instruction[] flow = owner.getControlFlow();
        for (ReadWriteVariableInstruction read : reads = ControlFlowBuilderUtil.getReadsWithoutPriorWrites(flow, true)) {
            String name;
            GroovyPsiElement property;
            PsiElement element = read.getElement();
            if (!(element instanceof GroovyPsiElement) || element instanceof GrClosableBlock || (property = ResolveUtil.resolveProperty((GroovyPsiElement)element, name = read.getDescriptor().getName())) == null || property instanceof PsiParameter || property instanceof PsiField || !PsiTreeUtil.isAncestor((PsiElement)owner, (PsiElement)property, (boolean)false) || this.myIgnoreBooleanExpressions && UnassignedVariableAccessInspection.isBooleanCheck(element)) continue;
            problemsHolder.registerProblem(element, GroovyBundle.message("unassigned.access.tooltip", name), new LocalQuickFix[0]);
        }
    }

    private static boolean isBooleanCheck(PsiElement element) {
        PsiElement parent2 = element.getParent();
        return parent2 instanceof GrIfStatement && ((GrIfStatement)parent2).getCondition() == element || parent2 instanceof GrWhileStatement && ((GrWhileStatement)parent2).getCondition() == element || parent2 instanceof GrTraditionalForClause && ((GrTraditionalForClause)parent2).getCondition() == element || UnassignedVariableAccessInspection.isLogicalExpression(parent2) || parent2 instanceof GrUnaryExpression && ((GrUnaryExpression)parent2).getOperationTokenType() == GroovyTokenTypes.mBNOT || UnassignedVariableAccessInspection.isCheckForNull(parent2, element);
    }

    private static boolean isLogicalExpression(PsiElement parent2) {
        return parent2 instanceof GrBinaryExpression && (((GrBinaryExpression)parent2).getOperationTokenType() == GroovyTokenTypes.mLAND || ((GrBinaryExpression)parent2).getOperationTokenType() == GroovyTokenTypes.mLOR);
    }

    private static boolean isCheckForNull(PsiElement parent2, PsiElement element) {
        if (!(parent2 instanceof GrBinaryExpression)) {
            return false;
        }
        IElementType tokenType = ((GrBinaryExpression)parent2).getOperationTokenType();
        if (tokenType != GroovyTokenTypes.mEQUAL && tokenType != GroovyTokenTypes.mNOT_EQUAL) {
            return false;
        }
        if (element == ((GrBinaryExpression)parent2).getLeftOperand()) {
            GrExpression rightOperand = ((GrBinaryExpression)parent2).getRightOperand();
            return rightOperand != null && GrInspectionUtil.isNull(rightOperand);
        }
        return GrInspectionUtil.isNull(((GrBinaryExpression)parent2).getLeftOperand());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "owner";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "problemsHolder";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/groovy/codeInspection/unassignedVariable/UnassignedVariableAccessInspection";
        objectArray[2] = "check";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

