/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.type.highlighting;

import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.jvm.JvmClass;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.actions.CreateConstructorRequest;
import com.intellij.lang.jvm.actions.JvmElementActionFactories;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.type.highlighting.ConstructorCallHighlighter;
import org.jetbrains.plugins.groovy.codeInspection.untypedUnresolvedAccess.requests.CreateConstructorFromGroovyUsageRequest;
import org.jetbrains.plugins.groovy.highlighting.HighlightSink;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyCallReference;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0014R\u0014\u0010\t\u001a\u00020\n8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/groovy/codeInspection/type/highlighting/GrNewExpressionHighlighter;", "Lorg/jetbrains/plugins/groovy/codeInspection/type/highlighting/ConstructorCallHighlighter;", "newExpression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrNewExpression;", "reference", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/GroovyCallReference;", "sink", "Lorg/jetbrains/plugins/groovy/highlighting/HighlightSink;", "(Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrNewExpression;Lorg/jetbrains/plugins/groovy/lang/resolve/api/GroovyCallReference;Lorg/jetbrains/plugins/groovy/highlighting/HighlightSink;)V", "highlightElement", "Lcom/intellij/psi/PsiElement;", "getHighlightElement", "()Lcom/intellij/psi/PsiElement;", "buildFixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "intellij.groovy.psi"})
public final class GrNewExpressionHighlighter
extends ConstructorCallHighlighter {
    private final GrNewExpression newExpression;

    @Override
    @NotNull
    protected PsiElement getHighlightElement() {
        GrArgumentList grArgumentList = this.newExpression.getArgumentList();
        GroovyPsiElement groovyPsiElement = grArgumentList != null ? (GroovyPsiElement)grArgumentList : (GroovyPsiElement)this.newExpression.getReferenceElement();
        boolean bl = false;
        boolean bl2 = false;
        if (groovyPsiElement == null) {
            boolean bl3 = false;
            String string = "reference of new expression should exist if it is a constructor call";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return groovyPsiElement;
    }

    @Override
    @NotNull
    protected List<LocalQuickFix> buildFixes() {
        GroovyResolveResult groovyResolveResult = this.getReference().advancedResolve();
        Intrinsics.checkNotNullExpressionValue((Object)groovyResolveResult, (String)"reference.advancedResolve()");
        PsiElement constructor = groovyResolveResult.getElement();
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)constructor, PsiClass.class);
        if (psiClass == null) {
            return CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"PsiTreeUtil.getParentOfT\u2026va) ?: return emptyList()");
        PsiClass targetClass = psiClass;
        if (!targetClass.getManager().isInProject((PsiElement)targetClass)) {
            return CollectionsKt.emptyList();
        }
        CreateConstructorFromGroovyUsageRequest request = new CreateConstructorFromGroovyUsageRequest(this.newExpression, (Collection<? extends JvmModifier>)CollectionsKt.emptyList());
        List createConstructorActions = JvmElementActionFactories.createConstructorActions((JvmClass)((JvmClass)targetClass), (CreateConstructorRequest)request);
        List list = IntentionWrapper.wrapToQuickFixes((List)createConstructorActions, (PsiFile)this.newExpression.getContainingFile());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"wrapToQuickFixes(createC\u2026xpression.containingFile)");
        return list;
    }

    public GrNewExpressionHighlighter(@NotNull GrNewExpression newExpression, @NotNull GroovyCallReference reference, @NotNull HighlightSink sink) {
        Intrinsics.checkNotNullParameter((Object)newExpression, (String)"newExpression");
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        super(reference, sink);
        this.newExpression = newExpression;
    }
}

