/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.control;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.utils.EquivalenceChecker;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

public class GroovyConditionalWithIdenticalBranchesInspection
extends BaseInspection {
    @Override
    public String buildErrorString(Object ... args) {
        return GroovyBundle.message("inspection.message.conditional.expression.with.identical.branches", new Object[0]);
    }

    @Override
    public GroovyFix buildFix(@NotNull PsiElement location) {
        if (location == null) {
            GroovyConditionalWithIdenticalBranchesInspection.$$$reportNull$$$0(0);
        }
        return new CollapseConditionalFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/plugins/groovy/codeInspection/control/GroovyConditionalWithIdenticalBranchesInspection", "buildFix"));
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitConditionalExpression(@NotNull GrConditionalExpression expression) {
            if (expression == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitConditionalExpression(expression);
            GrExpression thenBranch = expression.getThenBranch();
            GrExpression elseBranch = expression.getElseBranch();
            if (thenBranch == null || elseBranch == null) {
                return;
            }
            if (EquivalenceChecker.expressionsAreEquivalent(thenBranch, elseBranch)) {
                this.registerStatementError(expression, new Object[0]);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/codeInspection/control/GroovyConditionalWithIdenticalBranchesInspection$Visitor", "visitConditionalExpression"));
        }
    }

    private static class CollapseConditionalFix
    extends GroovyFix {
        private CollapseConditionalFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = GroovyBundle.message("intention.family.name.collapse.conditional.expressions", new Object[0]);
            if (string == null) {
                CollapseConditionalFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element;
            if (project == null) {
                CollapseConditionalFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                CollapseConditionalFix.$$$reportNull$$$0(2);
            }
            if ((element = descriptor.getPsiElement()) == null) {
                return;
            }
            PsiElement parent2 = element.getParent();
            if (!(parent2 instanceof GrConditionalExpression)) {
                return;
            }
            GrConditionalExpression expression = (GrConditionalExpression)parent2;
            GrExpression thenBranch = expression.getThenBranch();
            CollapseConditionalFix.replaceExpression(expression, thenBranch.getText());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/control/GroovyConditionalWithIdenticalBranchesInspection$CollapseConditionalFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/control/GroovyConditionalWithIdenticalBranchesInspection$CollapseConditionalFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "doFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

