/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;

public class GrMoveClassToCorrectPlaceFix
extends Intention {
    private static final Logger LOG = Logger.getInstance(GrMoveClassToCorrectPlaceFix.class);
    private final GrTypeDefinition myClass;

    public GrMoveClassToCorrectPlaceFix(GrTypeDefinition clazz) {
        this.myClass = clazz;
        LOG.assertTrue(!this.myClass.isAnonymous());
    }

    @Override
    @NotNull
    public String getText() {
        String string = GroovyBundle.message("move.class.0.from.method", this.myClass.getName());
        if (string == null) {
            GrMoveClassToCorrectPlaceFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = GroovyBundle.message("move.class.from.method.family.name", new Object[0]);
        if (string == null) {
            GrMoveClassToCorrectPlaceFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            GrMoveClassToCorrectPlaceFix.$$$reportNull$$$0(2);
        }
        return this.myClass.isValid();
    }

    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
        GrTypeDefinition containingClass;
        if (element == null) {
            GrMoveClassToCorrectPlaceFix.$$$reportNull$$$0(3);
        }
        if (project == null) {
            GrMoveClassToCorrectPlaceFix.$$$reportNull$$$0(4);
        }
        if ((containingClass = (GrTypeDefinition)PsiTreeUtil.getParentOfType((PsiElement)this.myClass, GrTypeDefinition.class)) != null) {
            containingClass.add(this.myClass);
        } else {
            PsiFile containingFile = this.myClass.getContainingFile();
            PsiElement added = containingFile.add((PsiElement)this.myClass);
            PsiElement prevSibling = added.getPrevSibling();
            if (prevSibling != null && prevSibling.getNode().getElementType() != GroovyTokenTypes.mNLS) {
                containingFile.getNode().addLeaf(GroovyTokenTypes.mNLS, (CharSequence)"\n", added.getNode());
            }
        }
        this.myClass.delete();
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                return GrMoveClassToCorrectPlaceFix.this.myClass.isValid();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/annotator/intentions/GrMoveClassToCorrectPlaceFix$1", "satisfiedBy"));
            }
        };
    }

    @Override
    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/annotator/intentions/GrMoveClassToCorrectPlaceFix";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/annotator/intentions/GrMoveClassToCorrectPlaceFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

