/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.checkers;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameValuePair;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.checkers.CustomAnnotationChecker;
import org.jetbrains.plugins.groovy.lang.psi.api.GrFunctionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrAnnotationUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ast.GrGeneratedConstructorUtils;
import org.jetbrains.plugins.groovy.lang.resolve.ast.contributor.SyntheticKeywordConstructorContributor;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/groovy/annotator/checkers/GeneratedConstructorAnnotationChecker;", "Lorg/jetbrains/plugins/groovy/annotator/checkers/CustomAnnotationChecker;", "()V", "checkArgumentList", "", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "annotation", "Lorg/jetbrains/plugins/groovy/lang/psi/api/auxiliary/modifiers/annotation/GrAnnotation;", "Companion", "intellij.groovy.psi"})
public final class GeneratedConstructorAnnotationChecker
extends CustomAnnotationChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean checkArgumentList(@NotNull AnnotationHolder holder, @NotNull GrAnnotation annotation) {
        PsiNameValuePair callSuper;
        PsiAnnotationMemberValue post;
        PsiAnnotationMemberValue pre;
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        if (!CollectionsKt.contains((Iterable)GrGeneratedConstructorUtils.getConstructorGeneratingAnnotations(), (Object)annotation.getQualifiedName())) {
            return false;
        }
        List<String> excludes = GrGeneratedConstructorUtils.getIdentifierList(annotation, "excludes");
        PsiNameValuePair includes = AnnotationUtil.findDeclaredAttribute((PsiAnnotation)annotation, (String)"includes");
        if (includes != null && excludes != null) {
            Collection collection = excludes;
            boolean bl = false;
            if (!collection.isEmpty()) {
                PsiNameValuePair psiNameValuePair = AnnotationUtil.findDeclaredAttribute((PsiAnnotation)annotation, (String)"excludes");
                Intrinsics.checkNotNull((Object)psiNameValuePair);
                Intrinsics.checkNotNullExpressionValue((Object)psiNameValuePair, (String)"AnnotationUtil.findDecla\u2026e(annotation, EXCLUDES)!!");
                GeneratedConstructorAnnotationChecker.Companion.registerIdentifierListError(holder, (PsiElement)psiNameValuePair);
                GeneratedConstructorAnnotationChecker.Companion.registerIdentifierListError(holder, (PsiElement)includes);
            }
        }
        PsiNameValuePair psiNameValuePair = AnnotationUtil.findDeclaredAttribute((PsiAnnotation)annotation, (String)"pre");
        Object object = pre = psiNameValuePair != null ? psiNameValuePair.getValue() : null;
        if (pre != null && !(pre instanceof GrFunctionalExpression)) {
            GeneratedConstructorAnnotationChecker.Companion.registerClosureError(holder, (PsiElement)pre);
        }
        PsiNameValuePair psiNameValuePair2 = AnnotationUtil.findDeclaredAttribute((PsiAnnotation)annotation, (String)"post");
        Object object2 = post = psiNameValuePair2 != null ? psiNameValuePair2.getValue() : null;
        if (post != null && !(post instanceof GrFunctionalExpression)) {
            GeneratedConstructorAnnotationChecker.Companion.registerClosureError(holder, (PsiElement)post);
        }
        if ((callSuper = AnnotationUtil.findDeclaredAttribute((PsiAnnotation)annotation, (String)"callSuper")) != null && pre != null && Intrinsics.areEqual((Object)GrAnnotationUtil.inferBooleanAttribute(annotation, "callSuper"), (Object)true) && Companion.isSuperCalledInPre(annotation)) {
            GeneratedConstructorAnnotationChecker.Companion.registerDuplicateSuperError(holder, (PsiElement)callSuper);
        }
        return false;
    }

    @JvmStatic
    public static final boolean isSuperCalledInPre(@NotNull PsiAnnotation annotation) {
        return Companion.isSuperCalledInPre(annotation);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/groovy/annotator/checkers/GeneratedConstructorAnnotationChecker$Companion;", "", "()V", "isSuperCalledInPre", "", "annotation", "Lcom/intellij/psi/PsiAnnotation;", "registerClosureError", "", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "element", "Lcom/intellij/psi/PsiElement;", "registerDuplicateSuperError", "registerIdentifierListError", "intellij.groovy.psi"})
    public static final class Companion {
        @JvmStatic
        public final boolean isSuperCalledInPre(@NotNull PsiAnnotation annotation) {
            GrStatement grStatement;
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            Object[] objectArray = GrAnnotationUtil.inferClosureAttribute(annotation, "pre");
            if (!((objectArray != null && (objectArray = objectArray.getStatements()) != null ? (GrStatement)ArraysKt.firstOrNull((Object[])objectArray) : (grStatement = null)) instanceof GrMethodCall)) {
                grStatement = null;
            }
            GrMethodCall grMethodCall = (GrMethodCall)grStatement;
            boolean bl = false;
            boolean bl2 = false;
            GrMethodCall p1 = grMethodCall;
            boolean bl3 = false;
            return SyntheticKeywordConstructorContributor.Companion.isSyntheticConstructorCall(p1);
        }

        private final void registerIdentifierListError(AnnotationHolder holder, PsiElement element) {
            holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("explicit.includes.and.excludes", new Object[0])).range(element).create();
        }

        private final void registerClosureError(AnnotationHolder holder, PsiElement element) {
            holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("require.closure.as.attribute.value", new Object[0])).range(element).create();
        }

        private final void registerDuplicateSuperError(AnnotationHolder holder, PsiElement element) {
            holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("super.is.not.allowed.in.pre.with.call.super", new Object[0])).range(element).create();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

