/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.make;

import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.uiDesigner.editor.UIFormEditor;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class FormElementNavigatable
implements Navigatable {
    private final Project myProject;
    private final VirtualFile myVirtualFile;
    @Nullable
    private final String myComponentId;

    public FormElementNavigatable(Project project, VirtualFile virtualFile, @Nullable String componentId) {
        this.myProject = project;
        this.myVirtualFile = virtualFile;
        this.myComponentId = componentId;
    }

    public void navigate(boolean requestFocus) {
        if (!this.myVirtualFile.isValid()) {
            return;
        }
        OpenFileDescriptor descriptor = new OpenFileDescriptor(this.myProject, this.myVirtualFile);
        List fileEditors = FileEditorManager.getInstance((Project)this.myProject).openEditor(descriptor, requestFocus);
        if (this.myComponentId != null) {
            for (FileEditor editor : fileEditors) {
                if (!(editor instanceof UIFormEditor)) continue;
                ((UIFormEditor)editor).selectComponentById(this.myComponentId);
                break;
            }
        }
    }

    public boolean canNavigate() {
        return this.myVirtualFile.isValid();
    }

    public boolean canNavigateToSource() {
        return this.myVirtualFile.isValid();
    }
}

