/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.indices.IndicesBundle;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenPluginInfo;

public final class MavenArtifactUtil {
    public static final String[] DEFAULT_GROUPS = new String[]{"org.apache.maven.plugins", "org.codehaus.mojo"};
    public static final String MAVEN_PLUGIN_DESCRIPTOR = "META-INF/maven/plugin.xml";
    private static final Map<File, MavenPluginInfo> ourPluginInfoCache = Collections.synchronizedMap(new HashMap());

    @Nullable
    public static MavenPluginInfo readPluginInfo(File localRepository, MavenId mavenId) {
        File file = MavenArtifactUtil.getArtifactFile(localRepository, mavenId.getGroupId(), mavenId.getArtifactId(), mavenId.getVersion(), "jar");
        MavenPluginInfo result = ourPluginInfoCache.get(file);
        if (result == null) {
            result = MavenArtifactUtil.createPluginDocument(file);
            ourPluginInfoCache.put(file, result);
        }
        return result;
    }

    public static boolean hasArtifactFile(File localRepository, MavenId id) {
        return MavenArtifactUtil.hasArtifactFile(localRepository, id, "jar");
    }

    public static boolean hasArtifactFile(File localRepository, MavenId id, String type2) {
        return MavenArtifactUtil.getArtifactFile(localRepository, id, type2).exists();
    }

    @NotNull
    public static File getArtifactFile(File localRepository, MavenId id, String type2) {
        return MavenArtifactUtil.getArtifactFile(localRepository, id.getGroupId(), id.getArtifactId(), id.getVersion(), type2);
    }

    @NotNull
    public static File getArtifactFile(File localRepository, MavenId id) {
        return MavenArtifactUtil.getArtifactFile(localRepository, id.getGroupId(), id.getArtifactId(), id.getVersion(), "pom");
    }

    public static boolean isPluginIdEquals(@Nullable String groupId1, @Nullable String artifactId1, @Nullable String groupId2, @Nullable String artifactId2) {
        if (artifactId1 == null) {
            return false;
        }
        if (!artifactId1.equals(artifactId2)) {
            return false;
        }
        if (groupId1 != null) {
            for (String group : DEFAULT_GROUPS) {
                if (!groupId1.equals(group)) continue;
                groupId1 = null;
                break;
            }
        }
        if (groupId2 != null) {
            for (String group : DEFAULT_GROUPS) {
                if (!groupId2.equals(group)) continue;
                groupId2 = null;
                break;
            }
        }
        return Objects.equals(groupId1, groupId2);
    }

    @NotNull
    public static File getArtifactFile(File localRepository, String groupId, String artifactId, String version2, String type2) {
        File dir2 = null;
        if (StringUtil.isEmpty((String)groupId)) {
            String each;
            String[] stringArray = DEFAULT_GROUPS;
            int n = stringArray.length;
            for (int i = 0; i < n && !(dir2 = MavenArtifactUtil.getArtifactDirectory(localRepository, each = stringArray[i], artifactId)).exists(); ++i) {
            }
        } else {
            dir2 = MavenArtifactUtil.getArtifactDirectory(localRepository, groupId, artifactId);
        }
        if (StringUtil.isEmpty((String)version2)) {
            version2 = MavenArtifactUtil.resolveVersion(dir2);
        }
        return new File(dir2, version2 + File.separator + artifactId + "-" + version2 + "." + type2);
    }

    private static File getArtifactDirectory(File localRepository, String groupId, String artifactId) {
        String relativePath = StringUtil.replace((String)groupId, (String)".", (String)File.separator) + File.separator + artifactId;
        return new File(localRepository, relativePath);
    }

    private static String resolveVersion(File pluginDir) {
        File[] children;
        ArrayList<String> versions = new ArrayList<String>();
        try {
            children = pluginDir.listFiles();
            if (children == null) {
                return "";
            }
        }
        catch (Exception e) {
            MavenLog.LOG.warn((Throwable)e);
            return "";
        }
        for (File version2 : children) {
            if (!version2.isDirectory()) continue;
            versions.add(version2.getName());
        }
        if (versions.isEmpty()) {
            return "";
        }
        Collections.sort(versions);
        return (String)versions.get(versions.size() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static MavenPluginInfo createPluginDocument(File file) {
        try {
            if (!file.exists()) {
                return null;
            }
            try (ZipFile jar = new ZipFile(file);){
                MavenPluginInfo mavenPluginInfo;
                ZipEntry entry = jar.getEntry(MAVEN_PLUGIN_DESCRIPTOR);
                if (entry == null) {
                    MavenLog.LOG.info(IndicesBundle.message("repository.plugin.corrupt", file));
                    MavenPluginInfo mavenPluginInfo2 = null;
                    return mavenPluginInfo2;
                }
                InputStream is = jar.getInputStream(entry);
                try {
                    byte[] bytes = FileUtil.loadBytes((InputStream)is);
                    mavenPluginInfo = new MavenPluginInfo(bytes);
                }
                catch (Throwable throwable) {
                    is.close();
                    throw throwable;
                }
                is.close();
                return mavenPluginInfo;
            }
        }
        catch (IOException e) {
            MavenLog.LOG.info((Throwable)e);
            return null;
        }
    }
}

