/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.statistics;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventFactoryKt;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemUsagesCollector;
import com.intellij.openapi.project.ExternalStorageConfigurationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Version;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.execution.MavenExternalParameters;
import org.jetbrains.idea.maven.execution.MavenRunner;
import org.jetbrains.idea.maven.execution.MavenRunnerSettings;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.server.MavenDistributionsCache;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/idea/maven/statistics/MavenSettingsCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "()V", "getGroupId", "", "getMavenWrapper", "Ljava/io/File;", "manager", "Lorg/jetbrains/idea/maven/project/MavenProjectsManager;", "project", "Lcom/intellij/openapi/project/Project;", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "intellij.maven"})
public final class MavenSettingsCollector
extends ProjectUsagesCollector {
    @NotNull
    public String getGroupId() {
        return "build.maven.state";
    }

    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project2) {
        MavenRunnerSettings runnerSettings;
        MavenImportingSettings importingSettings;
        boolean bl;
        boolean bl2;
        Object mavenWrapperFile2;
        MavenGeneralSettings generalSettings;
        MavenProjectsManager manager;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        MavenProjectsManager mavenProjectsManager = manager = MavenProjectsManager.getInstance(project2);
        Intrinsics.checkNotNullExpressionValue((Object)mavenProjectsManager, (String)"manager");
        if (!mavenProjectsManager.isMavenizedProject()) {
            return SetsKt.emptySet();
        }
        boolean bl3 = false;
        Set usages = new LinkedHashSet();
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"hasMavenProject", (boolean)true));
        MavenGeneralSettings mavenGeneralSettings = generalSettings = manager.getGeneralSettings();
        Intrinsics.checkNotNullExpressionValue((Object)mavenGeneralSettings, (String)"generalSettings");
        usages.add(MetricEventFactoryKt.newMetric((String)"checksumPolicy", (Enum)mavenGeneralSettings.getChecksumPolicy()));
        usages.add(MetricEventFactoryKt.newMetric((String)"failureBehavior", (Enum)generalSettings.getFailureBehavior()));
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"alwaysUpdateSnapshots", (boolean)generalSettings.isAlwaysUpdateSnapshots()));
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"nonRecursive", (boolean)generalSettings.isNonRecursive()));
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"printErrorStackTraces", (boolean)generalSettings.isPrintErrorStackTraces()));
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"usePluginRegistry", (boolean)generalSettings.isUsePluginRegistry()));
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"workOffline", (boolean)generalSettings.isWorkOffline()));
        usages.add(MetricEventFactoryKt.newMetric((String)"outputLevel", (Enum)generalSettings.getOutputLevel()));
        usages.add(MetricEventFactoryKt.newMetric((String)"pluginUpdatePolicy", (Enum)generalSettings.getPluginUpdatePolicy()));
        usages.add(MetricEventFactoryKt.newMetric((String)"loggingLevel", (Enum)generalSettings.getLoggingLevel()));
        try {
            String string;
            String mavenVersion22;
            block7: {
                block6: {
                    mavenWrapperFile2 = this.getMavenWrapper(manager, project2);
                    mavenVersion22 = MavenUtil.getMavenVersion(MavenExternalParameters.resolveMavenHome(generalSettings, project2, null, (File)mavenWrapperFile2));
                    string = mavenVersion22;
                    if (string == null) break block6;
                    String string2 = string;
                    bl2 = false;
                    bl = false;
                    String it = string2;
                    boolean bl4 = false;
                    Version version2 = Version.parseVersion((String)it);
                    string = version2 != null ? version2.toCompactString() : null;
                    if (string != null) break block7;
                }
                string = "unknown";
            }
            mavenVersion22 = string;
            usages.add(MetricEventFactoryKt.newMetric((String)"mavenVersion", (String)mavenVersion22));
        }
        catch (Exception mavenWrapperFile2) {
            // empty catch block
        }
        String string = generalSettings.getLocalRepository();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"generalSettings.localRepository");
        mavenWrapperFile2 = string;
        boolean mavenVersion22 = false;
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"localRepository", (!StringsKt.isBlank((CharSequence)mavenWrapperFile2) ? 1 : 0) != 0));
        String string3 = generalSettings.getUserSettingsFile();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"generalSettings.userSettingsFile");
        mavenWrapperFile2 = string3;
        mavenVersion22 = false;
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"userSettingsFile", (!StringsKt.isBlank((CharSequence)mavenWrapperFile2) ? 1 : 0) != 0));
        MavenImportingSettings mavenImportingSettings = importingSettings = manager.getImportingSettings();
        Intrinsics.checkNotNullExpressionValue((Object)mavenImportingSettings, (String)"importingSettings");
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"lookForNested", (boolean)mavenImportingSettings.isLookForNested()));
        String string4 = importingSettings.getDedicatedModuleDir();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"importingSettings.dedicatedModuleDir");
        Object mavenVersion22 = string4;
        boolean bl5 = false;
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"dedicatedModuleDir", (!StringsKt.isBlank((CharSequence)mavenVersion22) ? 1 : 0) != 0));
        ExternalStorageConfigurationManager externalStorageConfigurationManager = ExternalStorageConfigurationManager.getInstance((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)externalStorageConfigurationManager, (String)"ExternalStorageConfigura\u2026ager.getInstance(project)");
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"storeProjectFilesExternally", (boolean)externalStorageConfigurationManager.isEnabled()));
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"autoDetectCompiler", (boolean)importingSettings.isAutoDetectCompiler()));
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"createModulesForAggregators", (boolean)importingSettings.isCreateModulesForAggregators()));
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"createModuleGroups", (boolean)importingSettings.isCreateModuleGroups()));
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"keepSourceFolders", (boolean)importingSettings.isKeepSourceFolders()));
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"excludeTargetFolder", (boolean)importingSettings.isExcludeTargetFolder()));
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"useMavenOutput", (boolean)importingSettings.isUseMavenOutput()));
        usages.add(MetricEventFactoryKt.newMetric((String)"generatedSourcesFolder", (Enum)importingSettings.getGeneratedSourcesFolder()));
        String string5 = importingSettings.getUpdateFoldersOnImportPhase();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"importingSettings.updateFoldersOnImportPhase");
        usages.add(MetricEventFactoryKt.newMetric((String)"updateFoldersOnImportPhase", (String)string5));
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"downloadDocsAutomatically", (boolean)importingSettings.isDownloadDocsAutomatically()));
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"downloadSourcesAutomatically", (boolean)importingSettings.isDownloadSourcesAutomatically()));
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"customDependencyTypes", (boolean)(Intrinsics.areEqual((Object)"jar, test-jar, maven-plugin, ejb, ejb-client, jboss-har, jboss-sar, war, ear, bundle", (Object)importingSettings.getDependencyTypes()) ^ true)));
        usages.add(ExternalSystemUsagesCollector.Companion.getJRETypeUsage("jdkTypeForImporter", importingSettings.getJdkForImporter()));
        usages.add(ExternalSystemUsagesCollector.Companion.getJREVersionUsage(project2, "jdkVersionForImporter", importingSettings.getJdkForImporter()));
        String string6 = importingSettings.getVmOptionsForImporter();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"importingSettings.vmOptionsForImporter");
        mavenVersion22 = string6;
        bl5 = false;
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"hasVmOptionsForImporter", (!StringsKt.isBlank((CharSequence)mavenVersion22) ? 1 : 0) != 0));
        List<String> list = manager.getIgnoredFilesPaths();
        Intrinsics.checkNotNullExpressionValue(list, (String)"manager.ignoredFilesPaths");
        mavenVersion22 = list;
        bl5 = false;
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"hasIgnoredFiles", (!mavenVersion22.isEmpty() ? 1 : 0) != 0));
        List<String> list2 = manager.getIgnoredFilesPatterns();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"manager.ignoredFilesPatterns");
        mavenVersion22 = list2;
        bl5 = false;
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"hasIgnoredPatterns", (!mavenVersion22.isEmpty() ? 1 : 0) != 0));
        MavenRunner mavenRunner = MavenRunner.getInstance(project2);
        Intrinsics.checkNotNullExpressionValue((Object)mavenRunner, (String)"MavenRunner.getInstance(project)");
        MavenRunnerSettings mavenRunnerSettings = runnerSettings = mavenRunner.getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)mavenRunnerSettings, (String)"runnerSettings");
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"delegateBuildRun", (boolean)mavenRunnerSettings.isDelegateBuildToMaven()));
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"runMavenInBackground", (boolean)runnerSettings.isRunMavenInBackground()));
        usages.add(ExternalSystemUsagesCollector.Companion.getJRETypeUsage("runnerJreType", runnerSettings.getJreName()));
        usages.add(ExternalSystemUsagesCollector.Companion.getJREVersionUsage(project2, "runnerJreVersion", runnerSettings.getJreName()));
        String string7 = runnerSettings.getVmOptions();
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"runnerSettings.vmOptions");
        Map<String, String> map = string7;
        bl2 = false;
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"hasRunnerVmOptions", (!StringsKt.isBlank((CharSequence)((Object)map)) ? 1 : 0) != 0));
        map = runnerSettings.getEnvironmentProperties();
        bl2 = false;
        bl = false;
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"hasRunnerEnvVariables", (!(map == null || map.isEmpty()) ? 1 : 0) != 0));
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"passParentEnv", (boolean)runnerSettings.isPassParentEnv()));
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"skipTests", (boolean)runnerSettings.isSkipTests()));
        map = runnerSettings.getMavenProperties();
        bl2 = false;
        bl = false;
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"hasRunnerMavenProperties", (!(map == null || map.isEmpty()) ? 1 : 0) != 0));
        return usages;
    }

    private final File getMavenWrapper(MavenProjectsManager manager, Project project2) {
        File file;
        if (manager.getRootProjects().size() == 1) {
            MavenDistributionsCache mavenDistributionsCache = MavenDistributionsCache.getInstance(project2);
            List<MavenProject> list = manager.getRootProjects();
            Intrinsics.checkNotNullExpressionValue(list, (String)"manager.rootProjects");
            Object object = CollectionsKt.first(list);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"manager.rootProjects.first()");
            Object object2 = mavenDistributionsCache.getWrapper(((MavenProject)object).getDirectory());
            file = object2 != null && (object2 = object2.getMavenHome()) != null ? object2.toFile() : null;
        } else {
            file = null;
        }
        return file;
    }
}

