/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.onlinecompletion;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.indices.MavenIndex;
import org.jetbrains.idea.maven.indices.MavenIndicesManager;
import org.jetbrains.idea.maven.indices.MavenRepositoryProvider;
import org.jetbrains.idea.maven.model.MavenRemoteRepository;
import org.jetbrains.idea.maven.onlinecompletion.IndexBasedCompletionProvider;
import org.jetbrains.idea.maven.onlinecompletion.ProjectModulesCompletionProvider;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.reposearch.DependencySearchProvider;
import org.jetbrains.idea.reposearch.DependencySearchProvidersFactory;

public class MavenCompletionProviderFactory
implements DependencySearchProvidersFactory {
    public boolean isApplicable(Project project2) {
        return MavenProjectsManager.getInstance(project2).isMavenizedProject();
    }

    @NotNull
    public List<DependencySearchProvider> getProviders(Project project2) {
        ArrayList<DependencySearchProvider> result = new ArrayList<DependencySearchProvider>();
        result.add(new ProjectModulesCompletionProvider(project2));
        MavenCompletionProviderFactory.addLocalIndex(project2, result);
        MavenCompletionProviderFactory.addRemoteIndices(project2, result);
        ArrayList<DependencySearchProvider> arrayList = result;
        if (arrayList == null) {
            MavenCompletionProviderFactory.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    private static void addRemoteIndices(Project project2, List<DependencySearchProvider> result) {
        List<MavenIndex> privateIndices = MavenIndicesManager.getInstance(project2).ensureIndicesExist(MavenCompletionProviderFactory.collectRemoteRepositoriesIdsAndUrls(project2));
        for (MavenIndex index : privateIndices) {
            result.add(new IndexBasedCompletionProvider(index));
        }
    }

    private static void addLocalIndex(Project project2, List<DependencySearchProvider> result) {
        File localRepository = (File)ReadAction.compute(() -> project2.isDisposed() ? null : MavenProjectsManager.getInstance(project2).getLocalRepository());
        MavenIndicesManager indicesManager = MavenIndicesManager.getInstance(project2);
        MavenIndex localIndex = indicesManager.createIndexForLocalRepo(project2, localRepository);
        if (localIndex != null) {
            result.add(new IndexBasedCompletionProvider(localIndex));
        }
    }

    private static Set<Pair<String, String>> collectRemoteRepositoriesIdsAndUrls(Project project2) {
        HashSet<Pair<String, String>> result = new HashSet<Pair<String, String>>();
        HashSet<MavenRemoteRepository> remoteRepositories = new HashSet<MavenRemoteRepository>(MavenProjectsManager.getInstance(project2).getRemoteRepositories());
        for (MavenRepositoryProvider repositoryProvider : (MavenRepositoryProvider[])MavenRepositoryProvider.EP_NAME.getExtensions()) {
            remoteRepositories.addAll(repositoryProvider.getRemoteRepositories(project2));
        }
        for (MavenRemoteRepository each : remoteRepositories) {
            String id = each.getId();
            String url = each.getUrl();
            if ("central".equals(id) || url.contains("repo.maven.apache.org/maven2")) continue;
            result.add((Pair<String, String>)Pair.create((Object)id, (Object)url));
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/onlinecompletion/MavenCompletionProviderFactory", "getProviders"));
    }
}

