/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.indices;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.indices.MavenIndex;
import org.jetbrains.idea.maven.indices.MavenIndicesManager;
import org.jetbrains.idea.maven.indices.MavenRepositoryProvider;
import org.jetbrains.idea.maven.indices.MavenSearchIndex;
import org.jetbrains.idea.maven.model.MavenRemoteRepository;
import org.jetbrains.idea.maven.onlinecompletion.model.MavenDependencyCompletionItem;
import org.jetbrains.idea.maven.onlinecompletion.model.MavenRepositoryArtifactInfo;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.server.NativeMavenProjectHolder;
import org.jetbrains.idea.maven.utils.MavenMergingUpdateQueue;
import org.jetbrains.idea.maven.utils.MavenSimpleProjectComponent;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.reposearch.DependencySearchService;
import org.jetbrains.idea.reposearch.SearchParameters;

public final class MavenProjectIndicesManager
extends MavenSimpleProjectComponent
implements Disposable {
    private volatile List<MavenIndex> myProjectIndices = new ArrayList<MavenIndex>();
    @NotNull
    private volatile List<MavenIndex> myLocalIndexes = Collections.emptyList();
    private final DependencySearchService myDependencySearchService;
    private final MergingUpdateQueue myUpdateQueue = new MavenMergingUpdateQueue(this.getClass().getSimpleName(), 1000, true, this);

    public static MavenProjectIndicesManager getInstance(Project p) {
        return (MavenProjectIndicesManager)p.getService(MavenProjectIndicesManager.class);
    }

    public void dispose() {
    }

    public MavenProjectIndicesManager(Project project2) {
        super(project2);
        this.myDependencySearchService = DependencySearchService.getInstance((Project)project2);
        if (!this.isNormalProject()) {
            return;
        }
        this.doInit();
    }

    public void doInit() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.scheduleUpdateIndicesList();
        }
        MavenRepositoryProvider.EP_NAME.addChangeListener(this::scheduleUpdateIndicesList, (Disposable)this);
        this.getMavenProjectManager().addManagerListener(new MavenProjectsManager.Listener(){

            @Override
            public void activated() {
                MavenProjectIndicesManager.this.scheduleUpdateIndicesList();
            }
        });
        this.getMavenProjectManager().addProjectsTreeListener(new MavenProjectsTree.Listener(){

            @Override
            public void projectsUpdated(@NotNull List<Pair<MavenProject, MavenProjectChanges>> updated, @NotNull List<MavenProject> deleted) {
                if (updated == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (deleted == null) {
                    2.$$$reportNull$$$0(1);
                }
                MavenProjectIndicesManager.this.scheduleUpdateIndicesList();
            }

            @Override
            public void projectResolved(@NotNull Pair<MavenProject, MavenProjectChanges> projectWithChanges, NativeMavenProjectHolder nativeMavenProject) {
                if (projectWithChanges == null) {
                    2.$$$reportNull$$$0(2);
                }
                MavenProjectIndicesManager.this.scheduleUpdateIndicesList();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "updated";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "deleted";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "projectWithChanges";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/idea/maven/indices/MavenProjectIndicesManager$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "projectsUpdated";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "projectResolved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, this);
    }

    private void scheduleUpdateIndicesList() {
        this.scheduleUpdateIndicesList(null);
    }

    public void scheduleUpdateIndicesList(final @Nullable Consumer<? super List<MavenIndex>> consumer) {
        Update update = new Update(this){

            public void run() {
                Set remoteRepositoriesIdsAndUrls = (Set)ReadAction.compute(() -> MavenProjectIndicesManager.this.myProject.isDisposed() ? null : MavenProjectIndicesManager.this.collectRemoteRepositoriesIdsAndUrls());
                File localRepository = (File)ReadAction.compute(() -> MavenProjectIndicesManager.this.myProject.isDisposed() ? null : MavenProjectIndicesManager.this.getLocalRepository());
                if (remoteRepositoriesIdsAndUrls == null || localRepository == null || MavenProjectIndicesManager.this.myProject.isDisposed()) {
                    return;
                }
                MavenIndicesManager mavenIndicesManager = MavenIndicesManager.getInstance(MavenProjectIndicesManager.this.myProject);
                List<Object> newProjectIndices = remoteRepositoriesIdsAndUrls.isEmpty() ? new ArrayList() : mavenIndicesManager.ensureIndicesExist(remoteRepositoriesIdsAndUrls);
                ContainerUtil.addIfNotNull(newProjectIndices, (Object)mavenIndicesManager.createIndexForLocalRepo(MavenProjectIndicesManager.this.myProject, localRepository));
                MavenProjectIndicesManager.this.myDependencySearchService.updateProviders();
                MavenProjectIndicesManager.this.myProjectIndices = newProjectIndices;
                MavenProjectIndicesManager.this.myLocalIndexes = ContainerUtil.filter(MavenProjectIndicesManager.this.myProjectIndices, mi -> mi.getKind() == MavenSearchIndex.Kind.LOCAL);
                if (consumer != null) {
                    consumer.consume(MavenProjectIndicesManager.this.myProjectIndices);
                }
            }
        };
        if (MavenUtil.isMavenUnitTestModeEnabled()) {
            update.run();
        } else {
            this.myUpdateQueue.queue(update);
        }
    }

    private File getLocalRepository() {
        return MavenProjectsManager.getInstance(this.myProject).getLocalRepository();
    }

    private Set<Pair<String, String>> collectRemoteRepositoriesIdsAndUrls() {
        HashSet<Pair<String, String>> result = new HashSet<Pair<String, String>>();
        HashSet<MavenRemoteRepository> remoteRepositories = new HashSet<MavenRemoteRepository>(this.getMavenProjectManager().getRemoteRepositories());
        for (MavenRepositoryProvider repositoryProvider : (MavenRepositoryProvider[])MavenRepositoryProvider.EP_NAME.getExtensions()) {
            remoteRepositories.addAll(repositoryProvider.getRemoteRepositories(this.myProject));
        }
        for (MavenRemoteRepository each : remoteRepositories) {
            String id = each.getId();
            String url = each.getUrl();
            result.add((Pair<String, String>)Pair.create((Object)id, (Object)url));
        }
        return result;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public List<MavenIndex> getIndices() {
        return new ArrayList<MavenIndex>(this.myProjectIndices);
    }

    public void scheduleUpdateAll() {
        MavenIndicesManager.getInstance(this.myProject).scheduleUpdate(this.myProject, this.myProjectIndices);
    }

    public void scheduleUpdate(List<MavenIndex> indices) {
        MavenIndicesManager.getInstance(this.myProject).scheduleUpdate(this.myProject, indices);
    }

    public MavenIndicesManager.IndexUpdatingState getUpdatingState(MavenSearchIndex index) {
        return MavenIndicesManager.getInstance(this.myProject).getUpdatingState(index);
    }

    private MavenProjectsManager getMavenProjectManager() {
        return MavenProjectsManager.getInstance(this.myProject);
    }

    public synchronized DependencySearchService getDependencySearchService() {
        return this.myDependencySearchService;
    }

    @ApiStatus.Experimental
    public boolean hasRemotesExceptCentral() {
        return this.myProjectIndices.stream().filter(i -> i.getKind() == MavenSearchIndex.Kind.REMOTE).anyMatch(i -> !"central".equals(i.getRepositoryId()));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public Set<String> getGroupIds() {
        return this.getGroupIds("");
    }

    @Deprecated
    public Set<String> getGroupIds(String pattern) {
        pattern = pattern == null ? "" : pattern;
        HashSet<String> result = new HashSet<String>();
        this.myDependencySearchService.fulltextSearch(pattern, new SearchParameters(true, true), it -> {
            if (it instanceof MavenRepositoryArtifactInfo) {
                result.add(((MavenRepositoryArtifactInfo)it).getGroupId());
            }
        });
        return result;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public Set<String> getArtifactIds(String groupId) {
        ProgressIndicatorProvider.checkCanceled();
        HashSet<String> result = new HashSet<String>();
        this.myDependencySearchService.fulltextSearch(groupId + ":", new SearchParameters(true, true), it -> {
            if (it instanceof MavenRepositoryArtifactInfo && StringUtil.equals((CharSequence)groupId, (CharSequence)((MavenRepositoryArtifactInfo)it).getGroupId())) {
                result.add(((MavenRepositoryArtifactInfo)it).getArtifactId());
            }
        });
        return result;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public Set<String> getVersions(String groupId, String artifactId) {
        ProgressIndicatorProvider.checkCanceled();
        HashSet<String> result = new HashSet<String>();
        this.myDependencySearchService.fulltextSearch(groupId + ":" + artifactId, new SearchParameters(true, true), it -> {
            if (it instanceof MavenRepositoryArtifactInfo && StringUtil.equals((CharSequence)groupId, (CharSequence)((MavenRepositoryArtifactInfo)it).getGroupId()) && StringUtil.equals((CharSequence)groupId, (CharSequence)((MavenRepositoryArtifactInfo)it).getArtifactId())) {
                for (MavenDependencyCompletionItem item : ((MavenRepositoryArtifactInfo)it).getItems()) {
                    result.add(item.getVersion());
                }
            }
        });
        return result;
    }

    public boolean hasLocalGroupId(String groupId) {
        for (MavenIndex index : this.myLocalIndexes) {
            if (!index.hasGroupId(groupId)) continue;
            return true;
        }
        return false;
    }

    public boolean hasLocalArtifactId(String groupId, String artifactId) {
        for (MavenIndex index : this.myLocalIndexes) {
            if (!index.hasArtifactId(groupId, artifactId)) continue;
            return true;
        }
        return false;
    }

    public boolean hasLocalVersion(String groupId, String artifactId, String version2) {
        for (MavenIndex index : this.myLocalIndexes) {
            if (!index.hasVersion(groupId, artifactId, version2)) continue;
            return true;
        }
        return false;
    }
}

