/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.converters;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.references.MavenPathReferenceConverter;

public class MavenDependencySystemPathConverter
extends ResolvingConverter<PsiFile>
implements CustomReferenceConverter {
    public PsiFile fromString(@Nullable @NonNls String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        VirtualFile f = LocalFileSystem.getInstance().findFileByPath(s);
        if (f == null) {
            return null;
        }
        return context.getPsiManager().findFile(f);
    }

    public String toString(@Nullable PsiFile file, ConvertContext context) {
        if (file == null) {
            return null;
        }
        return file.getVirtualFile().getPath();
    }

    @NotNull
    public Collection<PsiFile> getVariants(ConvertContext context) {
        List<PsiFile> list = Collections.emptyList();
        if (list == null) {
            MavenDependencySystemPathConverter.$$$reportNull$$$0(0);
        }
        return list;
    }

    public PsiReference @NotNull [] createReferences(GenericDomValue genericDomValue, PsiElement element, ConvertContext context) {
        PsiReference[] psiReferenceArray = MavenPathReferenceConverter.createReferences((DomElement)genericDomValue, element, (Condition<PsiFileSystemItem>)((Condition)item -> item instanceof PsiDirectory || item.getName().endsWith(".jar")), true);
        if (psiReferenceArray == null) {
            MavenDependencySystemPathConverter.$$$reportNull$$$0(1);
        }
        return psiReferenceArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/idea/maven/dom/converters/MavenDependencySystemPathConverter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferences";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

