/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.missingApi.resolve;

import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.jarRepository.RemoteRepositoryDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.inspections.missingApi.resolve.IntelliJSdkExternalAnnotations;
import org.jetbrains.idea.devkit.inspections.missingApi.resolve.IntelliJSdkExternalAnnotationsKt;
import org.jetbrains.idea.devkit.inspections.missingApi.resolve.IntelliJSdkExternalAnnotationsRepository;
import org.jetbrains.idea.maven.aether.ArtifactKind;
import org.jetbrains.jps.model.library.JpsMavenRepositoryLibraryDescriptor;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0016\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nH\u0002J0\u0010\f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J0\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/idea/devkit/inspections/missingApi/resolve/PublicIntelliJSdkExternalAnnotationsRepository;", "Lorg/jetbrains/idea/devkit/inspections/missingApi/resolve/IntelliJSdkExternalAnnotationsRepository;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "downloadExternalAnnotations", "Lorg/jetbrains/idea/devkit/inspections/missingApi/resolve/IntelliJSdkExternalAnnotations;", "ideBuildNumber", "Lcom/intellij/openapi/util/BuildNumber;", "getAnnotationsCoordinates", "Lkotlin/Pair;", "", "tryDownload", "groupId", "artifactId", "version", "repos", "", "Lcom/intellij/jarRepository/RemoteRepositoryDescription;", "tryDownloadAnnotationsArtifact", "Lcom/intellij/openapi/vfs/VirtualFile;", "Companion", "intellij.devkit"})
public final class PublicIntelliJSdkExternalAnnotationsRepository
implements IntelliJSdkExternalAnnotationsRepository {
    private final Project project;
    @NotNull
    public static final String RELEASES_REPO_URL = "https://www.jetbrains.com/intellij-repository/releases/";
    @NotNull
    public static final String SNAPSHOTS_REPO_URL = "https://www.jetbrains.com/intellij-repository/snapshots/";
    @NotNull
    private static final RemoteRepositoryDescription RELEASES_REPO_DESCRIPTION;
    @NotNull
    private static final RemoteRepositoryDescription SNAPSHOTS_REPO_DESCRIPTION;
    @NotNull
    public static final Companion Companion;

    private final Pair<String, String> getAnnotationsCoordinates() {
        return TuplesKt.to((Object)"com.jetbrains.intellij.idea", (Object)"ideaIU");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public IntelliJSdkExternalAnnotations downloadExternalAnnotations(@NotNull BuildNumber ideBuildNumber) {
        Object v1;
        void groupId;
        Intrinsics.checkNotNullParameter((Object)ideBuildNumber, (String)"ideBuildNumber");
        Pair<String, String> pair = this.getAnnotationsCoordinates();
        if (pair == null) {
            return null;
        }
        Pair<String, String> pair2 = pair;
        String string = (String)pair2.component1();
        String artifactId = (String)pair2.component2();
        String lastReleaseVersion = ideBuildNumber.getBaselineVersion() + ".999999";
        IntelliJSdkExternalAnnotations lastReleaseAnnotations = this.tryDownload((String)groupId, artifactId, lastReleaseVersion, CollectionsKt.listOf((Object)RELEASES_REPO_DESCRIPTION));
        if (lastReleaseAnnotations != null && lastReleaseAnnotations.getAnnotationsBuild().compareTo(ideBuildNumber) >= 0) {
            return lastReleaseAnnotations;
        }
        String snapshotVersion = ideBuildNumber.getBaselineVersion() + "-SNAPSHOT";
        IntelliJSdkExternalAnnotations snapshotAnnotations = this.tryDownload((String)groupId, artifactId, snapshotVersion, CollectionsKt.listOf((Object)SNAPSHOTS_REPO_DESCRIPTION));
        if (snapshotAnnotations != null && snapshotAnnotations.getAnnotationsBuild().compareTo(ideBuildNumber) >= 0) {
            return snapshotAnnotations;
        }
        String latestTrunkSnapshot = "LATEST-TRUNK-SNAPSHOT";
        IntelliJSdkExternalAnnotations latestTrunkSnapshotAnnotations = this.tryDownload((String)groupId, artifactId, latestTrunkSnapshot, CollectionsKt.listOf((Object)SNAPSHOTS_REPO_DESCRIPTION));
        if (latestTrunkSnapshotAnnotations != null && latestTrunkSnapshotAnnotations.getAnnotationsBuild().compareTo(ideBuildNumber) >= 0) {
            return latestTrunkSnapshotAnnotations;
        }
        Sequence $this$maxByOrNull$iv = SequencesKt.filterNotNull((Sequence)SequencesKt.sequenceOf((Object[])new IntelliJSdkExternalAnnotations[]{lastReleaseAnnotations, snapshotAnnotations, latestTrunkSnapshotAnnotations}));
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v1 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v1 = maxElem$iv;
            } else {
                IntelliJSdkExternalAnnotations it = (IntelliJSdkExternalAnnotations)maxElem$iv;
                boolean bl = false;
                Comparable maxValue$iv = (Comparable)it.getAnnotationsBuild();
                do {
                    Object e$iv = iterator$iv.next();
                    IntelliJSdkExternalAnnotations it2 = (IntelliJSdkExternalAnnotations)e$iv;
                    $i$a$-maxByOrNull-PublicIntelliJSdkExternalAnnotationsRepository$downloadExternalAnnotations$1 = false;
                    Comparable v$iv = (Comparable)it2.getAnnotationsBuild();
                    if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v1 = maxElem$iv;
            }
        }
        return v1;
    }

    private final IntelliJSdkExternalAnnotations tryDownload(String groupId, String artifactId, String version, List<RemoteRepositoryDescription> repos) {
        BuildNumber buildNumber;
        VirtualFile annotations = this.tryDownloadAnnotationsArtifact(groupId, artifactId, version, repos);
        if (annotations != null && (buildNumber = IntelliJSdkExternalAnnotationsKt.getAnnotationsBuildNumber(annotations)) != null) {
            return new IntelliJSdkExternalAnnotations(buildNumber, annotations);
        }
        return null;
    }

    private final VirtualFile tryDownloadAnnotationsArtifact(String groupId, String artifactId, String version, List<RemoteRepositoryDescription> repos) {
        List list = JarRepositoryManager.loadDependenciesSync((Project)this.project, (JpsMavenRepositoryLibraryDescriptor)new JpsMavenRepositoryLibraryDescriptor(groupId, artifactId, version), (Set)SetsKt.setOf((Object)ArtifactKind.ANNOTATIONS), repos, null);
        return list != null && (list = (OrderRoot)CollectionsKt.firstOrNull((List)list)) != null ? list.getFile() : null;
    }

    public PublicIntelliJSdkExternalAnnotationsRepository(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    static {
        Companion = new Companion(null);
        RELEASES_REPO_DESCRIPTION = new RemoteRepositoryDescription("IntelliJ Artifacts Repository (Releases)", "IntelliJ Artifacts Repository (Releases)", RELEASES_REPO_URL);
        SNAPSHOTS_REPO_DESCRIPTION = new RemoteRepositoryDescription("IntelliJ Artifacts Repository (Snapshots)", "IntelliJ Artifacts Repository (Snapshots)", SNAPSHOTS_REPO_URL);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u000e\u0010\u000b\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/idea/devkit/inspections/missingApi/resolve/PublicIntelliJSdkExternalAnnotationsRepository$Companion;", "", "()V", "RELEASES_REPO_DESCRIPTION", "Lcom/intellij/jarRepository/RemoteRepositoryDescription;", "getRELEASES_REPO_DESCRIPTION", "()Lcom/intellij/jarRepository/RemoteRepositoryDescription;", "RELEASES_REPO_URL", "", "SNAPSHOTS_REPO_DESCRIPTION", "getSNAPSHOTS_REPO_DESCRIPTION", "SNAPSHOTS_REPO_URL", "intellij.devkit"})
    public static final class Companion {
        @NotNull
        public final RemoteRepositoryDescription getRELEASES_REPO_DESCRIPTION() {
            return RELEASES_REPO_DESCRIPTION;
        }

        @NotNull
        public final RemoteRepositoryDescription getSNAPSHOTS_REPO_DESCRIPTION() {
            return SNAPSHOTS_REPO_DESCRIPTION;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

