/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.internal;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.ui.table.JBTable;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.QueryExecutor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public class UndesirableClassUsageInspection
extends DevKitUastInspectionBase {
    @NonNls
    private static final Map<String, String> CLASSES = ContainerUtil.immutableMapBuilder().put((Object)JList.class.getName(), (Object)JBList.class.getName()).put((Object)JTable.class.getName(), (Object)JBTable.class.getName()).put((Object)JTree.class.getName(), (Object)Tree.class.getName()).put((Object)JScrollPane.class.getName(), (Object)JBScrollPane.class.getName()).put((Object)JTabbedPane.class.getName(), (Object)JBTabbedPane.class.getName()).put((Object)JComboBox.class.getName(), (Object)ComboBox.class.getName()).put((Object)QueryExecutor.class.getName(), (Object)QueryExecutorBase.class.getName()).put((Object)BufferedImage.class.getName(), (Object)"UIUtil.createImage()").build();

    public UndesirableClassUsageInspection() {
        super(UField.class, UMethod.class);
    }

    public ProblemDescriptor @Nullable [] checkMethod(@NotNull UMethod method, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (method == null) {
            UndesirableClassUsageInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            UndesirableClassUsageInspection.$$$reportNull$$$0(1);
        }
        return UndesirableClassUsageInspection.checkBody((UElement)method, manager, isOnTheFly);
    }

    public ProblemDescriptor @Nullable [] checkField(@NotNull UField field, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (field == null) {
            UndesirableClassUsageInspection.$$$reportNull$$$0(2);
        }
        if (manager == null) {
            UndesirableClassUsageInspection.$$$reportNull$$$0(3);
        }
        return UndesirableClassUsageInspection.checkBody((UElement)field, manager, isOnTheFly);
    }

    private static ProblemDescriptor @Nullable [] checkBody(@NotNull UElement uElement, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (uElement == null) {
            UndesirableClassUsageInspection.$$$reportNull$$$0(4);
        }
        if (manager == null) {
            UndesirableClassUsageInspection.$$$reportNull$$$0(5);
        }
        SmartList descriptors = new SmartList();
        uElement.accept((UastVisitor)new AbstractUastVisitor((List)descriptors, manager, isOnTheFly){
            final /* synthetic */ List val$descriptors;
            final /* synthetic */ InspectionManager val$manager;
            final /* synthetic */ boolean val$isOnTheFly;
            {
                this.val$descriptors = list;
                this.val$manager = inspectionManager;
                this.val$isOnTheFly = bl;
            }

            public boolean visitCallExpression(@NotNull UCallExpression expression) {
                String name;
                String replacement;
                PsiClass psiClass;
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (expression.getKind() == UastCallKind.CONSTRUCTOR_CALL && (psiClass = PsiTypesUtil.getPsiClass((PsiType)expression.getReturnType())) != null && (replacement = CLASSES.get(name = psiClass.getQualifiedName())) != null) {
                    this.val$descriptors.add(this.val$manager.createProblemDescriptor(Objects.requireNonNull(expression.getPsi()), DevKitBundle.message("inspections.undesirable.class.use.instead", replacement), true, ProblemHighlightType.LIKE_DEPRECATED, this.val$isOnTheFly, new LocalQuickFix[0]));
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/idea/devkit/inspections/internal/UndesirableClassUsageInspection$1", "visitCallExpression"));
            }
        });
        return descriptors.isEmpty() ? null : descriptors.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uElement";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/devkit/inspections/internal/UndesirableClassUsageInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkMethod";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkField";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkBody";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

