/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.generator;

import java.io.File;
import org.jetbrains.idea.devkit.dom.generator.DTDModelLoader;
import org.jetbrains.idea.devkit.dom.generator.ModelGen;
import org.jetbrains.idea.devkit.dom.generator.ModelLoader;
import org.jetbrains.idea.devkit.dom.generator.XSDModelLoader;

public final class Main {
    public static void main(String[] argv) throws Exception {
        ModelLoader loader;
        String mode;
        if (argv.length != 4) {
            System.out.println("Usage: Main <XSD or DTD> <input folder> <output folder> <config xml>");
        }
        if ((mode = argv[0]).equalsIgnoreCase("xsd")) {
            loader = new XSDModelLoader();
        } else if (mode.equalsIgnoreCase("dtd")) {
            loader = new DTDModelLoader();
        } else {
            System.out.println("'" + mode + "' format not supported");
            System.exit(-1);
            return;
        }
        File modelRoot = new File(argv[1]);
        File outputRoot = new File(argv[2]);
        File configXml = new File(argv[3]);
        outputRoot.mkdirs();
        ModelGen modelGen = new ModelGen(loader);
        modelGen.loadConfig(configXml);
        modelGen.perform(outputRoot, modelRoot);
    }
}

