/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.settings;

import com.intellij.completion.ml.ranker.ExperimentModelProvider;
import com.intellij.internal.ml.completion.RankingModelProvider;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00052\u00020\u0001:\u0003\u0005\u0006\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/completion/ml/settings/MLCompletionSettingsCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "Companion", "DecorationOpinion", "MLRankingSettingsValidationRule", "intellij.completionMlRanking"})
public final class MLCompletionSettingsCollector
extends CounterUsagesCollector {
    private static final EventLogGroup COUNTER_GROUP;
    private static final StringEventField rankerIdField;
    private static final BooleanEventField enabledField;
    private static final BooleanEventField enabledByDefaultField;
    private static final BooleanEventField languageCheckboxUsedField;
    private static final VarargEventId LANGUAGE_SETTINGS_CHANGED;
    private static final EventId1<Boolean> DECORATION_SETTINGS_CHANGED;
    private static final EventId1<DecorationOpinion> DECORATION_OPINION_PROVIDED;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public EventLogGroup getGroup() {
        return COUNTER_GROUP;
    }

    static {
        Companion = new Companion(null);
        COUNTER_GROUP = new EventLogGroup("ml.completion", 4);
        rankerIdField = EventFields.StringValidatedByCustomRule((String)"ranker_id", (String)"ml_completion_ranker_id");
        enabledField = EventFields.Boolean((String)"enabled");
        enabledByDefaultField = EventFields.Boolean((String)"enabled_by_default");
        languageCheckboxUsedField = EventFields.Boolean((String)"using_language_checkbox");
        LANGUAGE_SETTINGS_CHANGED = COUNTER_GROUP.registerVarargEvent("ranking.settings.changed", new EventField[]{(EventField)rankerIdField, (EventField)enabledField, (EventField)enabledByDefaultField, (EventField)languageCheckboxUsedField});
        DECORATION_SETTINGS_CHANGED = COUNTER_GROUP.registerEvent("decorating.settings.changed", (EventField)EventFields.Boolean((String)"enabled"));
        DECORATION_OPINION_PROVIDED = COUNTER_GROUP.registerEvent("decorating.opinion.provided", (EventField)EventFields.Enum$default((String)"opinion", DecorationOpinion.class, null, (int)4, null));
    }

    @JvmStatic
    public static final void rankingSettingsChanged(@NotNull String rankerId, boolean enabled, boolean enabledByDefault, boolean usingLanguageCheckbox) {
        Companion.rankingSettingsChanged(rankerId, enabled, enabledByDefault, usingLanguageCheckbox);
    }

    @JvmStatic
    public static final void decorationSettingChanged(boolean enabled) {
        Companion.decorationSettingChanged(enabled);
    }

    @JvmStatic
    public static final void decorationOpinionProvided(@Nullable Project project, @NotNull DecorationOpinion opinion) {
        Companion.decorationOpinionProvided(project, opinion);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\f"}, d2={"Lcom/intellij/completion/ml/settings/MLCompletionSettingsCollector$MLRankingSettingsValidationRule;", "Lcom/intellij/internal/statistic/eventLog/validator/rules/impl/CustomValidationRule;", "()V", "acceptRuleId", "", "ruleId", "", "doValidate", "Lcom/intellij/internal/statistic/eventLog/validator/ValidationResultType;", "data", "context", "Lcom/intellij/internal/statistic/eventLog/validator/rules/EventContext;", "intellij.completionMlRanking"})
    public static final class MLRankingSettingsValidationRule
    extends CustomValidationRule {
        public boolean acceptRuleId(@Nullable String ruleId) {
            return Intrinsics.areEqual((Object)ruleId, (Object)"ml_completion_ranker_id");
        }

        @NotNull
        protected ValidationResultType doValidate(@NotNull String data, @NotNull EventContext context) {
            boolean bl;
            block4: {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Iterable $this$any$iv = ExperimentModelProvider.Companion.availableProviders();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        RankingModelProvider it = (RankingModelProvider)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getId(), (Object)data)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return ValidationResultType.ACCEPTED;
            }
            return ValidationResultType.REJECTED;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/completion/ml/settings/MLCompletionSettingsCollector$DecorationOpinion;", "", "(Ljava/lang/String;I)V", "LIKE", "DISLIKE", "NEUTRAL", "intellij.completionMlRanking"})
    public static final class DecorationOpinion
    extends Enum<DecorationOpinion> {
        public static final /* enum */ DecorationOpinion LIKE;
        public static final /* enum */ DecorationOpinion DISLIKE;
        public static final /* enum */ DecorationOpinion NEUTRAL;
        private static final /* synthetic */ DecorationOpinion[] $VALUES;

        static {
            DecorationOpinion[] decorationOpinionArray = new DecorationOpinion[3];
            DecorationOpinion[] decorationOpinionArray2 = decorationOpinionArray;
            decorationOpinionArray[0] = LIKE = new DecorationOpinion();
            decorationOpinionArray[1] = DISLIKE = new DecorationOpinion();
            decorationOpinionArray[2] = NEUTRAL = new DecorationOpinion();
            $VALUES = decorationOpinionArray;
        }

        public static DecorationOpinion[] values() {
            return (DecorationOpinion[])$VALUES.clone();
        }

        public static DecorationOpinion valueOf(String string) {
            return Enum.valueOf(DecorationOpinion.class, string);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0007H\u0007J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\tH\u0007J(\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\tH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/completion/ml/settings/MLCompletionSettingsCollector$Companion;", "", "()V", "COUNTER_GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "DECORATION_OPINION_PROVIDED", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "Lcom/intellij/completion/ml/settings/MLCompletionSettingsCollector$DecorationOpinion;", "DECORATION_SETTINGS_CHANGED", "", "LANGUAGE_SETTINGS_CHANGED", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "enabledByDefaultField", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "enabledField", "languageCheckboxUsedField", "rankerIdField", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "decorationOpinionProvided", "", "project", "Lcom/intellij/openapi/project/Project;", "opinion", "decorationSettingChanged", "enabled", "rankingSettingsChanged", "rankerId", "", "enabledByDefault", "usingLanguageCheckbox", "intellij.completionMlRanking"})
    public static final class Companion {
        @JvmStatic
        public final void rankingSettingsChanged(@NotNull String rankerId, boolean enabled, boolean enabledByDefault, boolean usingLanguageCheckbox) {
            Intrinsics.checkNotNullParameter((Object)rankerId, (String)"rankerId");
            LANGUAGE_SETTINGS_CHANGED.log(new EventPair[]{rankerIdField.with((Object)rankerId), enabledField.with((Object)enabled), enabledByDefaultField.with((Object)enabledByDefault), languageCheckboxUsedField.with((Object)usingLanguageCheckbox)});
        }

        @JvmStatic
        public final void decorationSettingChanged(boolean enabled) {
            DECORATION_SETTINGS_CHANGED.log((Object)enabled);
        }

        @JvmStatic
        public final void decorationOpinionProvided(@Nullable Project project, @NotNull DecorationOpinion opinion) {
            Intrinsics.checkNotNullParameter((Object)((Object)opinion), (String)"opinion");
            DECORATION_OPINION_PROVIDED.log(project, (Object)opinion);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

