/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.marker;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.fasterxml.jackson.databind.ser.ResolvableSerializer;
import com.fasterxml.jackson.databind.util.NameTransformer;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.logstash.logback.argument.StructuredArgument;
import net.logstash.logback.argument.StructuredArguments;
import net.logstash.logback.marker.LogstashMarker;

public class ObjectFieldsAppendingMarker
extends LogstashMarker
implements StructuredArgument {
    public static final String MARKER_NAME = "LS_OBJECT_FIELDS";
    private final Object object;
    private static final ConcurrentHashMap<Class<?>, JsonSerializer<Object>> beanSerializers = new ConcurrentHashMap();
    private static final ConcurrentHashMap<ObjectMapper, SerializerProvider> serializerProviders = new ConcurrentHashMap();

    public ObjectFieldsAppendingMarker(Object object) {
        super(MARKER_NAME);
        this.object = object;
    }

    @Override
    public void writeTo(JsonGenerator generator) throws IOException {
        ObjectMapper mapper;
        JsonSerializer<Object> serializer2;
        if (this.object != null && (serializer2 = this.getBeanSerializer(mapper = (ObjectMapper)generator.getCodec())).isUnwrappingSerializer()) {
            serializer2.serialize(this.object, generator, this.getSerializerProvider(mapper));
        }
    }

    @Override
    public String toStringSelf() {
        return StructuredArguments.toString(this.object);
    }

    private JsonSerializer<Object> getBeanSerializer(ObjectMapper mapper) throws JsonMappingException {
        JsonSerializer<Object> jsonSerializer = beanSerializers.get(this.object.getClass());
        if (jsonSerializer == null) {
            JsonSerializer<Object> existingSerializer;
            SerializerProvider serializerProvider = this.getSerializerProvider(mapper);
            JsonSerializer<Object> newSerializer = mapper.getSerializerFactory().createSerializer(serializerProvider, mapper.getSerializationConfig().constructType(this.object.getClass())).unwrappingSerializer(NameTransformer.NOP);
            if (newSerializer instanceof ResolvableSerializer) {
                ((ResolvableSerializer)newSerializer).resolve(serializerProvider);
            }
            jsonSerializer = (existingSerializer = beanSerializers.putIfAbsent(this.object.getClass(), newSerializer)) == null ? newSerializer : existingSerializer;
        }
        return jsonSerializer;
    }

    private SerializerProvider getSerializerProvider(ObjectMapper mapper) {
        SerializerProvider provider = serializerProviders.get(mapper);
        if (provider == null) {
            DefaultSerializerProvider newProvider = ((DefaultSerializerProvider)mapper.getSerializerProvider()).createInstance(mapper.getSerializationConfig(), mapper.getSerializerFactory());
            SerializerProvider existingProvider = serializerProviders.putIfAbsent(mapper, (SerializerProvider)newProvider);
            provider = existingProvider == null ? newProvider : existingProvider;
        }
        return provider;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ObjectFieldsAppendingMarker)) {
            return false;
        }
        ObjectFieldsAppendingMarker other = (ObjectFieldsAppendingMarker)obj;
        return Objects.equals(this.object, other.object);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + super.hashCode();
        result2 = 31 * result2 + (this.object == null ? 0 : this.object.hashCode());
        return result2;
    }
}

