/*
 * Decompiled with CFR 0.152.
 */
package fleet.diff;

import andel.text.TextRange;
import fleet.diff.LineEnding;
import fleet.diff.LineTokenizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\t\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001e\u001fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0013\u001a\u00020\u00062\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u000e\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0016\u001a\u00020\u0017J\u0016\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0017J\b\u0010\u001b\u001a\u00020\u0017H\u0016J\u000e\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u0017R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0007R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006 "}, d2={"Lfleet/diff/FileText;", "", "text", "", "(Ljava/lang/CharSequence;)V", "isEmpty", "", "()Z", "lineEnding", "Lfleet/diff/LineEnding;", "getLineEnding", "()Lfleet/diff/LineEnding;", "lines", "", "Lfleet/diff/FileText$Line;", "getLines", "()Ljava/util/List;", "getText", "()Ljava/lang/CharSequence;", "equals", "other", "getLine", "i", "", "getLineSafe", "fromLine", "toLine", "hashCode", "offsetToLine", "offset", "Companion", "Line", "fleet.andel.common"})
public final class FileText {
    @NotNull
    private final List<Line> lines;
    @Nullable
    private final LineEnding lineEnding;
    private final boolean isEmpty;
    @NotNull
    private final CharSequence text;
    @NotNull
    private static final FileText Empty;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final List<Line> getLines() {
        return this.lines;
    }

    @Nullable
    public final LineEnding getLineEnding() {
        return this.lineEnding;
    }

    public final boolean isEmpty() {
        return this.isEmpty;
    }

    @NotNull
    public final CharSequence getText(int fromLine, int toLine) {
        boolean bl = fromLine >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        bl = toLine <= this.lines.size();
        bl2 = false;
        bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl5 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        bl = fromLine < toLine;
        bl2 = false;
        bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl6 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return this.text.subSequence(this.lines.get(fromLine).getStart(), this.lines.get(toLine - 1).getEnd());
    }

    @NotNull
    public final Line getLine(int i) {
        if (i >= this.lines.size()) {
            return new Line(this, i, this.text.length(), this.text.length());
        }
        return this.lines.get(i);
    }

    @Nullable
    public final Line getLineSafe(int i) {
        if (i < 0 || i >= this.lines.size()) {
            return null;
        }
        return this.lines.get(i);
    }

    public final int offsetToLine(int offset) {
        if (this.lines.isEmpty()) {
            return 0;
        }
        int low = 0;
        int high = this.lines.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            Line line = this.lines.get(mid);
            if (line.getEnd() < offset) {
                low = mid + 1;
                continue;
            }
            if (offset < line.getStart()) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return this.lines.size() - 1;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FileText)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.text, (Object)((FileText)other).text);
    }

    public int hashCode() {
        return this.text.hashCode();
    }

    @NotNull
    public final CharSequence getText() {
        return this.text;
    }

    public FileText(@NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.text = text;
        ArrayList<Line> lines2 = new ArrayList<Line>(this.text.length() / 36);
        LineTokenizer lineTokenizer = new LineTokenizer(this.text);
        LineEnding lastLineSeparator = null;
        HashSet<LineEnding> lineSeparators = new HashSet<LineEnding>();
        while (!lineTokenizer.getAtEnd()) {
            int start2 = lineTokenizer.getOffset();
            int end = start2 + lineTokenizer.getLength();
            lines2.add(new Line(this, lines2.size(), start2, end));
            lastLineSeparator = lineTokenizer.getLineSeparator();
            if (lastLineSeparator != null) {
                lineSeparators.add(lastLineSeparator);
            }
            lineTokenizer.advance();
        }
        if (lines2.size() > 0 && lastLineSeparator != null) {
            lines2.add(new Line(this, lines2.size(), this.text.length(), this.text.length()));
        }
        this.lines = lines2;
        this.lineEnding = (LineEnding)((Object)CollectionsKt.singleOrNull((Iterable)lineSeparators));
        CharSequence charSequence = this.text;
        boolean bl = false;
        this.isEmpty = charSequence.length() == 0;
    }

    static {
        Companion = new Companion(null);
        Empty = new FileText("");
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0010J\u0013\u0010\u001c\u001a\u00020\u00102\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010 \u001a\u00020\u0005H\u0016J\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0018J\u000e\u0010$\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0018J\b\u0010%\u001a\u00020\"H\u0016R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\nR\u0011\u0010\u0015\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000eR\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\n\u00a8\u0006&"}, d2={"Lfleet/diff/FileText$Line;", "", "file", "Lfleet/diff/FileText;", "lineNumber", "", "start", "end", "(Lfleet/diff/FileText;III)V", "getEnd", "()I", "fileText", "", "getFileText", "()Ljava/lang/CharSequence;", "isEmptyOrBlank", "", "()Z", "length", "getLength", "getLineNumber", "lineText", "getLineText", "range", "Landel/text/TextRange;", "getRange", "()Landel/text/TextRange;", "getStart", "equals", "line", "ignoreWhiteSpaces", "other", "hashCode", "localSubStr", "", "textRange", "subStr", "toString", "fleet.andel.common"})
    public static final class Line {
        private final FileText file;
        private final int lineNumber;
        private final int start;
        private final int end;

        private final CharSequence getFileText() {
            return this.file.getText();
        }

        @NotNull
        public final CharSequence getLineText() {
            return this.getFileText().subSequence(this.start, this.end);
        }

        public final boolean isEmptyOrBlank() {
            boolean bl;
            block3: {
                Iterable $this$all$iv = (Iterable)RangesKt.until((int)this.start, (int)this.end);
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    Iterator iterator = $this$all$iv.iterator();
                    while (iterator.hasNext()) {
                        int element$iv;
                        int it = element$iv = ((IntIterator)iterator).nextInt();
                        boolean bl2 = false;
                        if (Character.isWhitespace(this.getFileText().charAt(it))) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
            }
            return bl;
        }

        @NotNull
        public final TextRange getRange() {
            return new TextRange(this.start, this.end);
        }

        public final int getLength() {
            return this.end - this.start;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Line)) {
                return false;
            }
            return this.equals((Line)other, false);
        }

        public final boolean equals(@NotNull Line line, boolean ignoreWhiteSpaces) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            CharSequence fti = this.getFileText();
            CharSequence ftj = line.getFileText();
            if (ignoreWhiteSpaces) {
                int i = this.start;
                for (int j = line.start; i < this.end || j < line.end; ++i, ++j) {
                    while (i < this.end && Character.isWhitespace(fti.charAt(i))) {
                        ++i;
                    }
                    while (j < line.end && Character.isWhitespace(ftj.charAt(j))) {
                        ++j;
                    }
                    if (i < this.end && j < line.end && fti.charAt(i) != ftj.charAt(j)) {
                        return false;
                    }
                    if ((i != this.end || j >= line.end) && (i >= this.end || j != line.end)) continue;
                    return false;
                }
            } else {
                if (this.end - this.start != line.end - line.start) {
                    return false;
                }
                int i = this.start;
                for (int j = line.start; i < this.end && j < line.end; ++i, ++j) {
                    if (fti.charAt(i) == ftj.charAt(j)) continue;
                    return false;
                }
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        public int hashCode() {
            int hashCode = 0;
            int n = this.start;
            int n2 = this.end;
            while (n < n2) {
                void i;
                hashCode = hashCode * 19 + this.getFileText().charAt((int)i) * 17;
                ++i;
            }
            return hashCode;
        }

        @NotNull
        public final String subStr(@NotNull TextRange textRange) {
            Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
            boolean bl = textRange.getStart() >= 0L && textRange.getEnd() <= (long)this.getLength();
            boolean bl2 = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            return ((Object)this.getFileText().subSequence((int)textRange.getStart(), (int)textRange.getEnd())).toString();
        }

        @NotNull
        public final String localSubStr(@NotNull TextRange textRange) {
            Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
            return ((Object)this.getFileText().subSequence((int)((long)this.start + textRange.getStart()), (int)((long)this.start + textRange.getEnd()))).toString();
        }

        @NotNull
        public String toString() {
            return ((Object)this.getLineText()).toString();
        }

        public final int getLineNumber() {
            return this.lineNumber;
        }

        public final int getStart() {
            return this.start;
        }

        public final int getEnd() {
            return this.end;
        }

        public Line(@NotNull FileText file, int lineNumber, int start2, int end) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this.file = file;
            this.lineNumber = lineNumber;
            this.start = start2;
            this.end = end;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lfleet/diff/FileText$Companion;", "", "()V", "Empty", "Lfleet/diff/FileText;", "getEmpty", "()Lfleet/diff/FileText;", "fleet.andel.common"})
    public static final class Companion {
        @NotNull
        public final FileText getEmpty() {
            return Empty;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

