/*
 * Decompiled with CFR 0.152.
 */
package fleet.api;

import fleet.api.Os;
import fleet.api.PlatformKt;
import fleet.api.ProtocolPath$;
import fleet.api.Root;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 -2\u00020\u0001:\u0002,-B3\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bB\u001b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\fJ\u001f\u0010\u0014\u001a\u00020\u00002\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0016\"\u00020\b\u00a2\u0006\u0002\u0010\u0017J\u0014\u0010\u0014\u001a\u00020\u00002\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J#\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001J\u001f\u0010\u001b\u001a\u00020\u001c2\u0012\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0016\"\u00020\b\u00a2\u0006\u0002\u0010\u001eJ\u0014\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u0013\u0010\u001f\u001a\u00020\u001c2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010!\u001a\u00020\u0003H\u00d6\u0001J\u0006\u0010\"\u001a\u00020\bJ\b\u0010#\u001a\u0004\u0018\u00010\u0000J\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010 \u001a\u00020\u0000J\u000e\u0010%\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\bJ\u0006\u0010'\u001a\u00020\u0000J\u000e\u0010(\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u0000J\u0006\u0010)\u001a\u00020*J\t\u0010+\u001a\u00020\bH\u00d6\u0001R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006."}, d2={"Lfleet/api/ProtocolPath;", "", "seen1", "", "root", "Lfleet/api/Root;", "components", "", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILfleet/api/Root;Ljava/util/List;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "(Lfleet/api/Root;Ljava/util/List;)V", "getComponents", "()Ljava/util/List;", "name", "getName", "()Ljava/lang/String;", "getRoot", "()Lfleet/api/Root;", "child", "elements", "", "([Ljava/lang/String;)Lfleet/api/ProtocolPath;", "component1", "component2", "copy", "endsWith", "", "names", "([Ljava/lang/String;)Z", "equals", "other", "hashCode", "joinToString", "parent", "relativeSegmentsTo", "resolveChild", "relativePath", "sanitized", "startsWith", "toNio", "Ljava/nio/file/Path;", "toString", "$serializer", "Companion", "fleet.protocol"})
public final class ProtocolPath {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Root root;
    @NotNull
    private final List<String> components;

    public ProtocolPath(@NotNull Root root, @NotNull List<String> components) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(components, (String)"components");
        this.root = root;
        this.components = components;
    }

    @NotNull
    public final Root getRoot() {
        return this.root;
    }

    @NotNull
    public final List<String> getComponents() {
        return this.components;
    }

    @Nullable
    public final ProtocolPath parent() {
        Collection collection = this.components;
        boolean bl = false;
        return !collection.isEmpty() ? ProtocolPath.copy$default(this, null, CollectionsKt.dropLast(this.components, (int)1), 1, null) : (ProtocolPath)null;
    }

    @NotNull
    public final ProtocolPath sanitized() {
        return new ProtocolPath(this.root, Companion.sanitizeComponents(this.components));
    }

    @NotNull
    public final ProtocolPath child(String ... elements) {
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        return ProtocolPath.copy$default(this, null, Companion.sanitizeComponents(CollectionsKt.plus((Collection)this.components, (Object[])elements)), 1, null);
    }

    @NotNull
    public final ProtocolPath child(@NotNull List<String> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return ProtocolPath.copy$default(this, null, Companion.sanitizeComponents(CollectionsKt.plus((Collection)this.components, (Iterable)elements)), 1, null);
    }

    @NotNull
    public final ProtocolPath resolveChild(@NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        return this.child(Companion.toComponents(relativePath));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean startsWith(@NotNull ProtocolPath other) {
        String b;
        Pair $dstr$a$b;
        String a;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!Intrinsics.areEqual((Object)this.root, (Object)other.root)) return false;
        if (this.components.size() < other.components.size()) return false;
        Iterable $this$all$iv = CollectionsKt.zip((Iterable)this.components, (Iterable)other.components);
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            $dstr$a$b = (Pair)element$iv;
            boolean bl = false;
        } while (Intrinsics.areEqual((Object)(a = (String)$dstr$a$b.component1()), (Object)(b = (String)$dstr$a$b.component2())));
        return false;
    }

    public final boolean endsWith(String ... names) {
        Intrinsics.checkNotNullParameter((Object)names, (String)"names");
        return this.endsWith(ArraysKt.toList((Object[])names));
    }

    public final boolean endsWith(@NotNull List<String> names) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(names, (String)"names");
            Iterable $this$all$iv = CollectionsKt.zip((Iterable)CollectionsKt.reversed((Iterable)this.components), (Iterable)CollectionsKt.reversed((Iterable)names));
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    String b;
                    Pair $dstr$a$b = (Pair)element$iv;
                    boolean bl2 = false;
                    String a = (String)$dstr$a$b.component1();
                    if (Intrinsics.areEqual((Object)a, (Object)(b = (String)$dstr$a$b.component2()))) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @NotNull
    public final List<String> relativeSegmentsTo(@NotNull ProtocolPath other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!this.startsWith(other)) {
            return CollectionsKt.emptyList();
        }
        return CollectionsKt.drop((Iterable)this.components, (int)other.components.size());
    }

    @NotNull
    public final String joinToString() {
        return Companion.joinToString(this.root, this.components);
    }

    @NotNull
    public final Path toNio() {
        Collection $this$toTypedArray$iv = this.components;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] stringArray2 = stringArray;
        Path path = Path.of(this.root.toString(), Arrays.copyOf(stringArray2, stringArray2.length));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(root.toString(), *components.toTypedArray())");
        return path;
    }

    @NotNull
    public final String getName() {
        String string = (String)CollectionsKt.lastOrNull(this.components);
        return string == null ? this.root.toString() : string;
    }

    @NotNull
    public final Root component1() {
        return this.root;
    }

    @NotNull
    public final List<String> component2() {
        return this.components;
    }

    @NotNull
    public final ProtocolPath copy(@NotNull Root root, @NotNull List<String> components) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(components, (String)"components");
        return new ProtocolPath(root, components);
    }

    public static /* synthetic */ ProtocolPath copy$default(ProtocolPath protocolPath, Root root, List list, int n, Object object) {
        if ((n & 1) != 0) {
            root = protocolPath.root;
        }
        if ((n & 2) != 0) {
            list = protocolPath.components;
        }
        return protocolPath.copy(root, list);
    }

    @NotNull
    public String toString() {
        return "ProtocolPath(root=" + this.root + ", components=" + this.components + ')';
    }

    public int hashCode() {
        int result2 = this.root.hashCode();
        result2 = result2 * 31 + ((Object)this.components).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ProtocolPath)) {
            return false;
        }
        ProtocolPath protocolPath = (ProtocolPath)other;
        if (!Intrinsics.areEqual((Object)this.root, (Object)protocolPath.root)) {
            return false;
        }
        return Intrinsics.areEqual(this.components, protocolPath.components);
    }

    @Deprecated(message="This synthesized declaration should not be used directly", replaceWith=@ReplaceWith(expression="", imports={}), level=DeprecationLevel.HIDDEN)
    public /* synthetic */ ProtocolPath(int seen1, Root root, List components, SerializationConstructorMarker serializationConstructorMarker) {
        if (3 != (3 & seen1)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen1, (int)3, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.root = root;
        this.components = components;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\tH\u0002J\u001e\u0010\n\u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000eJ\u0016\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012J\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000eJ\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0015H\u00c6\u0001J\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\u0006\u0010\u0017\u001a\u00020\tJ\u000e\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\tJ\u0010\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\tH\u0002\u00a8\u0006\u001a"}, d2={"Lfleet/api/ProtocolPath$Companion;", "", "()V", "fromNioPath", "Lfleet/api/ProtocolPath;", "path", "Ljava/nio/file/Path;", "isAbsoluteDosPath", "", "", "joinToString", "root", "Lfleet/api/Root;", "components", "", "of", "str", "os", "Lfleet/api/Os;", "sanitizeComponents", "serializer", "Lkotlinx/serialization/KSerializer;", "toComponents", "pathString", "unixPath", "windowsPath", "fleet.protocol"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Unable to fully structure code
         */
        @NotNull
        public final String joinToString(@Nullable Root root, @NotNull List<String> components) {
            Intrinsics.checkNotNullParameter(components, (String)"components");
            if (!(root instanceof Root.Windows)) ** GOTO lbl-1000
            var4_3 = components;
            var5_4 = false;
            if (var4_3.isEmpty() == false) {
                v0 = Intrinsics.stringPlus((String)((Root.Windows)root).getDrive(), (Object)"/");
            } else lbl-1000:
            // 2 sources

            {
                var4_3 = (var4_3 = root) == null ? null : var4_3.toString();
                var5_4 = false;
                v0 = var4_3;
                if (v0 == null) {
                    v0 = "";
                }
            }
            rootString = v0;
            return Intrinsics.stringPlus((String)rootString, (Object)CollectionsKt.joinToString$default((Iterable)components, (CharSequence)"/", null, null, (int)0, null, null, (int)62, null));
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated(message="Use with caution, it's much better to know yours target OS, see ProtocolPath#of", replaceWith=@ReplaceWith(expression="ProtocolPath.of(path, os)", imports={}))
        @NotNull
        public final ProtocolPath fromNioPath(@NotNull Path path) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            boolean bl = path.isAbsolute();
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-ProtocolPath$Companion$fromNioPath$322 = false;
                String $i$a$-assert-ProtocolPath$Companion$fromNioPath$322 = path + " is not absolute";
                throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-ProtocolPath$Companion$fromNioPath$322));
            }
            Path path2 = path.getRoot();
            boolean $i$a$-assert-ProtocolPath$Companion$fromNioPath$322 = false;
            boolean bl3 = false;
            if (path2 == null) {
                boolean bl4 = false;
                String string = Intrinsics.stringPlus((String)"nio.Path.root should be not null in ", (Object)path);
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            Path pathRoot = path2;
            Object $i$a$-assert-ProtocolPath$Companion$fromNioPath$322 = new char[]{'\\'};
            $i$a$-assert-ProtocolPath$Companion$fromNioPath$322 = StringsKt.trimEnd((String)((Object)pathRoot).toString(), (char[])$i$a$-assert-ProtocolPath$Companion$fromNioPath$322);
            Object object = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"US");
            boolean bl4 = false;
            char[] cArray = $i$a$-assert-ProtocolPath$Companion$fromNioPath$322;
            if (cArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string = cArray.toUpperCase((Locale)object);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).toUpperCase(locale)");
            String rootString = string;
            Root root = Intrinsics.areEqual((Object)rootString, (Object)"/") ? (Root)Root.Unix.INSTANCE : (Root)new Root.Windows(rootString);
            object = path;
            Root root2 = root;
            boolean $i$f$map = false;
            void var7_16 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Path path3 = (Path)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl5 = false;
                String string2 = it.toString();
                collection.add(string2);
            }
            collection = (List)destination$iv$iv;
            List list = collection;
            Root root3 = root2;
            return new ProtocolPath(root3, list);
        }

        @NotNull
        public final ProtocolPath unixPath(@NotNull String str) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            boolean bl = StringsKt.startsWith$default((String)str, (String)"/", (boolean)false, (int)2, null);
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "Path should start with /: \"" + str + '\"';
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            return new ProtocolPath(Root.Unix.INSTANCE, this.sanitizeComponents(this.toComponents(StringsKt.drop((String)str, (int)1))));
        }

        @NotNull
        public final List<String> toComponents(@NotNull String pathString) {
            List list;
            Intrinsics.checkNotNullParameter((Object)pathString, (String)"pathString");
            if (StringsKt.contains$default((CharSequence)pathString, (char)'\\', (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)pathString, (char)'/', (boolean)false, (int)2, null)) {
                char[] cArray = new char[]{'\\'};
                list = StringsKt.split$default((CharSequence)pathString, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            } else if (StringsKt.contains$default((CharSequence)pathString, (CharSequence)"/", (boolean)false, (int)2, null)) {
                char[] cArray = new char[]{'/'};
                list = StringsKt.split$default((CharSequence)pathString, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            } else {
                CharSequence charSequence = pathString;
                boolean bl = false;
                list = charSequence.length() == 0 || Intrinsics.areEqual((Object)pathString, (Object)".") ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)pathString);
            }
            return list;
        }

        @NotNull
        public final List<String> sanitizeComponents(@NotNull List<String> components) {
            Intrinsics.checkNotNullParameter(components, (String)"components");
            LinkedList<String> list = new LinkedList<String>();
            for (String component : components) {
                if (Intrinsics.areEqual((Object)component, (Object)"..")) {
                    if (list.isEmpty()) {
                        return CollectionsKt.emptyList();
                    }
                    list.removeLast();
                    continue;
                }
                CharSequence charSequence = component;
                boolean bl = false;
                if (!(charSequence.length() > 0) || Intrinsics.areEqual((Object)component, (Object)".")) continue;
                list.add(component);
            }
            return list;
        }

        private final ProtocolPath windowsPath(String str) {
            boolean bl = this.isAbsoluteDosPath(str);
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = "We're supporting only DOS-style paths on Windows";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            String string = StringsKt.take((String)str, (int)2);
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            boolean bl4 = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toUpperCase(locale)");
            return new ProtocolPath(new Root.Windows(string3), this.sanitizeComponents(this.toComponents(StringsKt.drop((String)str, (int)3))));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isAbsoluteDosPath(String path) {
            boolean bl;
            char c;
            if (path.length() <= 2) return false;
            if (path.charAt(1) != ':') return false;
            if (path.charAt(2) != '/') {
                if (path.charAt(2) != '\\') return false;
            }
            if ('a' <= (c = path.charAt(0))) {
                if (c <= 'z') {
                    return true;
                }
                bl = false;
            } else {
                bl = false;
            }
            if (bl) return true;
            c = path.charAt(0);
            if ('A' > c) return false;
            if (c > 'Z') return false;
            return true;
        }

        @NotNull
        public final ProtocolPath of(@NotNull String str, @NotNull Os os) {
            ProtocolPath protocolPath;
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            Intrinsics.checkNotNullParameter((Object)((Object)os), (String)"os");
            if (PlatformKt.isWindows(os)) {
                protocolPath = this.windowsPath(str);
            } else if (PlatformKt.isUnix(os)) {
                protocolPath = this.unixPath(str);
            } else {
                String string = "Can't create a path: " + str + " for unsupported " + (Object)((Object)os) + '.';
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            return protocolPath;
        }

        @NotNull
        public final KSerializer<ProtocolPath> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

