/*
 * Decompiled with CFR 0.152.
 */
package runtime.reactive;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import libraries.basics.AssertKt;
import libraries.basics.DebugCommonKt;
import libraries.klogging.GroupsKt;
import libraries.klogging.KLogger;
import org.jetbrains.annotations.NotNull;
import runtime.async.EmptyAnnotation;
import runtime.reactive.CellTracker;
import runtime.reactive.Reaction;
import runtime.reactive.ReactionsKt;
import runtime.reactive.ReactionsNotEmptyAtStartOfAction;
import runtime.reactive.TransactionalReactionsScheduler;
import runtime.reactive.XTrackable;

@EmptyAnnotation
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0002J\u000e\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0007J\u001f\u0010\f\u001a\u0002H\r\"\u0004\b\u0000\u0010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u000f\u00a2\u0006\u0002\u0010\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lruntime/reactive/TransactionalReactionsScheduler;", "", "()V", "isAction", "", "scheduledReactions", "", "Lruntime/reactive/Reaction;", "invokeTriggeredReactions", "", "schedule", "reaction", "transaction", "T", "actionHandler", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "platform-runtime"})
public final class TransactionalReactionsScheduler {
    @NotNull
    public static final TransactionalReactionsScheduler INSTANCE = new TransactionalReactionsScheduler();
    @NotNull
    private static List<Reaction> scheduledReactions;
    private static boolean isAction;

    private TransactionalReactionsScheduler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void schedule(@NotNull Reaction reaction2) {
        void dbgName$iv;
        Intrinsics.checkNotNullParameter((Object)reaction2, (String)"reaction");
        if (!isAction) {
            String string2;
            String string3 = DebugCommonKt.getDbgName(reaction2);
            if (string3 == null) {
                string2 = null;
            } else {
                String string4 = string3;
                boolean bl = false;
                boolean bl2 = false;
                String it = string4;
                boolean bl3 = false;
                string2 = "reaction(" + it + ") invoked immediately";
            }
            String label$iv = string2;
            boolean collapsed$iv = true;
            boolean $i$f$logGroup = false;
            if (label$iv != null) {
                GroupsKt.logGroupStart(label$iv, collapsed$iv);
            }
            try {
                void dbgName$iv2;
                boolean bl = false;
                KLogger bl3 = ReactionsKt.access$getLog$p();
                String string5 = DebugCommonKt.getDbgName(reaction2);
                Function1 msg$iv = schedule.2.1.INSTANCE;
                boolean $i$f$debug = false;
                if (dbgName$iv2 != null) {
                    void $this$debug$iv;
                    void this_$iv$iv = $this$debug$iv;
                    boolean $i$f$debug2 = false;
                    if (this_$iv$iv.isDebugEnabled()) {
                        void var13_27 = this_$iv$iv;
                        boolean bl4 = false;
                        Object object = msg$iv.invoke((Object)dbgName$iv2);
                        var13_27.debug(object);
                    }
                }
                reaction2.invalidate();
                Unit unit = Unit.INSTANCE;
                if (label$iv == null) return;
            }
            catch (Throwable bl) {
                if (label$iv == null) throw bl;
                GroupsKt.logGroupEnd(label$iv);
                throw bl;
            }
            GroupsKt.logGroupEnd(label$iv);
            return;
        }
        KLogger label$iv = ReactionsKt.access$getLog$p();
        String collapsed$iv = DebugCommonKt.getDbgName(reaction2);
        Function1 msg$iv = schedule.3.INSTANCE;
        boolean $i$f$debug = false;
        if (dbgName$iv != null) {
            void $this$debug$iv;
            void this_$iv$iv = $this$debug$iv;
            boolean $i$f$debug3 = false;
            if (this_$iv$iv.isDebugEnabled()) {
                void var8_20 = this_$iv$iv;
                boolean bl = false;
                Object object = msg$iv.invoke((Object)dbgName$iv);
                var8_20.debug(object);
            }
        }
        AssertKt.assert(!scheduledReactions.contains(reaction2), "reaction is already scheduled");
        scheduledReactions.add(reaction2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T transaction(@NotNull Function0<? extends T> actionHandler) {
        Object object;
        Intrinsics.checkNotNullParameter(actionHandler, (String)"actionHandler");
        if (!isAction) {
            Collection collection = scheduledReactions;
            boolean bl = false;
            if (!collection.isEmpty()) {
                throw new ReactionsNotEmptyAtStartOfAction();
            }
            isAction = true;
            Object result2 = null;
            try {
                result2 = CellTracker.INSTANCE.untrack((Function1)new Function1<XTrackable, T>(actionHandler){
                    final /* synthetic */ Function0<T> $actionHandler;
                    {
                        this.$actionHandler = $actionHandler;
                        super(1);
                    }

                    public final T invoke(@NotNull XTrackable $this$untrack) {
                        Intrinsics.checkNotNullParameter((Object)$this$untrack, (String)"$this$untrack");
                        return (T)this.$actionHandler.invoke();
                    }
                });
            }
            finally {
                isAction = false;
                this.invokeTriggeredReactions();
            }
            object = collection;
        } else {
            object = actionHandler.invoke();
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void invokeTriggeredReactions() {
        List<Reaction> invokingReactions = scheduledReactions;
        boolean bl = false;
        scheduledReactions = new ArrayList();
        Iterable $this$forEach$iv = invokingReactions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Reaction it = (Reaction)element$iv;
            boolean bl2 = false;
            if (it.isReacted()) continue;
            try {
                void label$iv;
                String string2;
                String string3 = DebugCommonKt.getDbgName(it);
                if (string3 == null) {
                    string2 = null;
                } else {
                    String string4 = string3;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    String it2 = string4;
                    boolean bl5 = false;
                    string2 = "reaction(" + it2 + ") invoked by scheduler";
                }
                string3 = string2;
                boolean collapsed$iv = true;
                boolean $i$f$logGroup = false;
                if (label$iv != null) {
                    GroupsKt.logGroupStart((String)label$iv, collapsed$iv);
                }
                try {
                    void dbgName$iv;
                    boolean bl6 = false;
                    KLogger bl5 = ReactionsKt.access$getLog$p();
                    String string5 = DebugCommonKt.getDbgName(it);
                    Function1 msg$iv = invokeTriggeredReactions.1.2.1.INSTANCE;
                    boolean $i$f$debug = false;
                    if (dbgName$iv != null) {
                        void $this$debug$iv;
                        void this_$iv$iv = $this$debug$iv;
                        boolean $i$f$debug2 = false;
                        if (this_$iv$iv.isDebugEnabled()) {
                            void var19_28 = this_$iv$iv;
                            boolean bl7 = false;
                            Object object = msg$iv.invoke((Object)dbgName$iv);
                            var19_28.debug(object);
                        }
                    }
                    it.invalidate();
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    if (label$iv == null) continue;
                    GroupsKt.logGroupEnd((String)label$iv);
                }
            }
            catch (Throwable e) {
                KLogger this_$iv = ReactionsKt.access$getLog$p();
                boolean $i$f$error = false;
                if (!this_$iv.isErrorEnabled()) continue;
                Throwable throwable = e;
                KLogger kLogger = this_$iv;
                boolean bl8 = false;
                String string6 = "Failed to trigger reaction";
                kLogger.error(throwable, string6);
            }
        }
    }

    static {
        boolean bl = false;
        scheduledReactions = new ArrayList();
    }
}

