/*
 * Decompiled with CFR 0.152.
 */
package runtime.reactive;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import libraries.basics.DebugCommonKt;
import libraries.coroutines.extra.Lifetime;
import libraries.coroutines.extra.LifetimeSource;
import libraries.coroutines.extra.LifetimeUtilsKt;
import libraries.klogging.GroupsKt;
import libraries.klogging.KLogger;
import org.jetbrains.annotations.NotNull;
import runtime.reactive.DependenciesState;
import runtime.reactive.Reaction;
import runtime.reactive.ReactionsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u0017\u001a\u00020\u0006R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0018"}, d2={"Lruntime/reactive/Reaction;", "", "parentLifetime", "Llibraries/coroutines/extra/Lifetime;", "reaction", "Lkotlin/Function0;", "", "(Llibraries/coroutines/extra/Lifetime;Lkotlin/jvm/functions/Function0;)V", "dependenciesState", "Lruntime/reactive/DependenciesState$Tracked;", "getDependenciesState", "()Lruntime/reactive/DependenciesState$Tracked;", "setDependenciesState", "(Lruntime/reactive/DependenciesState$Tracked;)V", "isReacted", "", "()Z", "setReacted", "(Z)V", "trackingLifetime", "Llibraries/coroutines/extra/LifetimeSource;", "getTrackingLifetime", "()Llibraries/coroutines/extra/LifetimeSource;", "invalidate", "platform-runtime"})
public final class Reaction {
    @NotNull
    private final Function0<Unit> reaction;
    @NotNull
    private final LifetimeSource trackingLifetime;
    @NotNull
    private DependenciesState.Tracked dependenciesState;
    private boolean isReacted;

    public Reaction(@NotNull Lifetime parentLifetime, @NotNull Function0<Unit> reaction2) {
        Intrinsics.checkNotNullParameter((Object)parentLifetime, (String)"parentLifetime");
        Intrinsics.checkNotNullParameter(reaction2, (String)"reaction");
        this.reaction = reaction2;
        DebugCommonKt.assignDbgName(this, this.reaction, "reaction");
        this.trackingLifetime = LifetimeUtilsKt.nested(parentLifetime);
        this.dependenciesState = DependenciesState.Tracked.UpToDate.INSTANCE;
    }

    @NotNull
    public final LifetimeSource getTrackingLifetime() {
        return this.trackingLifetime;
    }

    @NotNull
    public final DependenciesState.Tracked getDependenciesState() {
        return this.dependenciesState;
    }

    public final void setDependenciesState(@NotNull DependenciesState.Tracked tracked) {
        Intrinsics.checkNotNullParameter((Object)tracked, (String)"<set-?>");
        this.dependenciesState = tracked;
    }

    public final boolean isReacted() {
        return this.isReacted;
    }

    public final void setReacted(boolean bl) {
        this.isReacted = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void invalidate() {
        String string2;
        String string3 = DebugCommonKt.getDbgName(this.reaction);
        if (string3 == null) {
            string2 = null;
        } else {
            String string4 = string3;
            boolean bl = false;
            boolean bl2 = false;
            String it = string4;
            boolean bl3 = false;
            string2 = Intrinsics.stringPlus((String)it, (Object)": invocation invalidation");
        }
        String label$iv = string2;
        boolean collapsed$iv = true;
        boolean $i$f$logGroup = false;
        if (label$iv != null) {
            GroupsKt.logGroupStart(label$iv, collapsed$iv);
        }
        try {
            KLogger $this$debug$iv;
            boolean bl = false;
            Object currentDependenciesState = this.getDependenciesState();
            boolean isInvocationNeeded2 = Intrinsics.areEqual((Object)currentDependenciesState, (Object)DependenciesState.Tracked.Stale.INSTANCE) ? true : (currentDependenciesState instanceof DependenciesState.Tracked.PossiblyStale ? ((DependenciesState.Tracked.PossiblyStale)currentDependenciesState).getDependenciesMightHaveChanged().any(invalidate.2.isInvocationNeeded.1.INSTANCE) : false);
            this.setDependenciesState(DependenciesState.Tracked.UpToDate.INSTANCE);
            if (isInvocationNeeded2) {
                void dbgName$iv;
                this.getTrackingLifetime().terminate();
                currentDependenciesState = ReactionsKt.access$getLog$p();
                String string5 = DebugCommonKt.getDbgName(this.reaction);
                Function1 msg$iv = invalidate.2.1.INSTANCE;
                boolean $i$f$debug = false;
                if (dbgName$iv != null) {
                    KLogger this_$iv$iv = $this$debug$iv;
                    boolean $i$f$debug2 = false;
                    if (this_$iv$iv.isDebugEnabled()) {
                        KLogger kLogger = this_$iv$iv;
                        boolean bl4 = false;
                        Object object = msg$iv.invoke((Object)dbgName$iv);
                        kLogger.debug(object);
                    }
                }
                this.reaction.invoke();
                this.setReacted(true);
            } else {
                $this$debug$iv = ReactionsKt.access$getLog$p();
                String dbgName$iv = DebugCommonKt.getDbgName(this.reaction);
                Function1 msg$iv = invalidate.2.2.INSTANCE;
                boolean $i$f$debug = false;
                if (dbgName$iv != null) {
                    KLogger this_$iv$iv = $this$debug$iv;
                    boolean $i$f$debug3 = false;
                    if (this_$iv$iv.isDebugEnabled()) {
                        KLogger kLogger = this_$iv$iv;
                        boolean bl5 = false;
                        Object object = msg$iv.invoke((Object)dbgName$iv);
                        kLogger.debug(object);
                    }
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            if (label$iv != null) {
                GroupsKt.logGroupEnd(label$iv);
            }
        }
    }
}

