/*
 * Decompiled with CFR 0.152.
 */
package runtime.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BaseJsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.json.JsonArray;
import runtime.json.JsonArrayBuilderContext;
import runtime.json.JsonBuilderContext;
import runtime.json.JsonBuilderContextImpl;
import runtime.json.JsonDslKt;
import runtime.json.JsonElement;
import runtime.json.JsonObject;
import runtime.json.JsonValue;
import runtime.json.JsonValueBuilderContext;
import runtime.json.JsonValueBuilderContextImpl;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0096\u0004J\u0011\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0013H\u0096\u0004J\u0011\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0014H\u0096\u0004J\"\u0010\u000f\u001a\u00020\u00102\u0017\u0010\u0015\u001a\u0013\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00100\u0016\u00a2\u0006\u0002\b\u0018H\u0096\u0004J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0019H\u0096\u0004J\"\u0010\u001a\u001a\u00020\u00102\u0017\u0010\u0015\u001a\u0013\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00100\u0016\u00a2\u0006\u0002\b\u0018H\u0096\u0004J\"\u0010\u001b\u001a\u00020\u00102\u0017\u0010\u0015\u001a\u0013\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00100\u0016\u00a2\u0006\u0002\b\u0018H\u0096\u0004R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lruntime/json/JsonArrayBuilderContextImpl;", "Lruntime/json/JsonArrayBuilderContext;", "node", "Lcom/fasterxml/jackson/databind/node/ArrayNode;", "factory", "Lcom/fasterxml/jackson/databind/node/JsonNodeFactory;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Lcom/fasterxml/jackson/databind/node/ArrayNode;Lcom/fasterxml/jackson/databind/node/JsonNodeFactory;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "getFactory", "()Lcom/fasterxml/jackson/databind/node/JsonNodeFactory;", "getMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "getNode", "()Lcom/fasterxml/jackson/databind/node/ArrayNode;", "push", "", "value", "", "", "", "worker", "Lkotlin/Function1;", "Lruntime/json/JsonBuilderContext;", "Lkotlin/ExtensionFunctionType;", "Lruntime/json/JsonElement;", "pushArray", "pushValue", "Lruntime/json/JsonValueBuilderContext;", "platform-runtime"})
public final class JsonArrayBuilderContextImpl
implements JsonArrayBuilderContext {
    @NotNull
    private final ArrayNode node;
    @NotNull
    private final JsonNodeFactory factory;
    @NotNull
    private final ObjectMapper mapper;

    public JsonArrayBuilderContextImpl(@NotNull ArrayNode node, @NotNull JsonNodeFactory factory, @NotNull ObjectMapper mapper) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        this.node = node;
        this.factory = factory;
        this.mapper = mapper;
    }

    @NotNull
    public final ArrayNode getNode() {
        return this.node;
    }

    @NotNull
    public final JsonNodeFactory getFactory() {
        return this.factory;
    }

    @NotNull
    public final ObjectMapper getMapper() {
        return this.mapper;
    }

    @Override
    public void push(@NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.node.add(value2);
    }

    @Override
    public void push(int value2) {
        this.node.add(value2);
    }

    @Override
    public void push(@Nullable Object value2) {
        this.node.add(this.mapper.valueToTree(value2));
    }

    @Override
    public void push(@Nullable JsonElement value2) {
        BaseJsonNode baseJsonNode;
        JsonElement jsonElement = value2;
        if (jsonElement instanceof JsonValue) {
            baseJsonNode = (BaseJsonNode)JsonDslKt.node((JsonValue)value2);
        } else if (jsonElement instanceof JsonArray) {
            baseJsonNode = (BaseJsonNode)JsonDslKt.node((JsonArray)value2);
        } else if (jsonElement instanceof JsonObject) {
            baseJsonNode = (BaseJsonNode)JsonDslKt.node((JsonObject)value2);
        } else if (jsonElement == null) {
            baseJsonNode = null;
        } else {
            String string2 = Intrinsics.stringPlus((String)"Unsupported element type ", (Object)Reflection.getOrCreateKotlinClass(value2.getClass()).getSimpleName());
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        this.node.add((JsonNode)baseJsonNode);
    }

    @Override
    public void pushArray(@NotNull Function1<? super JsonArrayBuilderContext, Unit> worker) {
        Intrinsics.checkNotNullParameter(worker, (String)"worker");
        ArrayNode objNode = this.factory.arrayNode();
        Intrinsics.checkNotNullExpressionValue((Object)objNode, (String)"objNode");
        worker.invoke((Object)new JsonArrayBuilderContextImpl(objNode, this.factory, JsonDslKt.getJackson()));
        this.node.add((JsonNode)objNode);
    }

    @Override
    public void push(@NotNull Function1<? super JsonBuilderContext, Unit> worker) {
        Intrinsics.checkNotNullParameter(worker, (String)"worker");
        ObjectNode objNode = this.factory.objectNode();
        Intrinsics.checkNotNullExpressionValue((Object)objNode, (String)"objNode");
        worker.invoke((Object)new JsonBuilderContextImpl(objNode, this.factory, JsonDslKt.getJackson()));
        this.node.add((JsonNode)objNode);
    }

    @Override
    public void pushValue(@NotNull Function1<? super JsonValueBuilderContext, Unit> worker) {
        Intrinsics.checkNotNullParameter(worker, (String)"worker");
        worker.invoke((Object)new JsonValueBuilderContextImpl((Function1<? super JsonNode, Unit>)((Function1)new Function1<JsonNode, Unit>(this){
            final /* synthetic */ JsonArrayBuilderContextImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull JsonNode it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.this$0.getNode().add(it);
            }
        }), this.factory, JsonDslKt.getJackson()));
    }
}

