/*
 * Decompiled with CFR 0.152.
 */
package runtime.container;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.container.InvalidDependencyArityException;
import runtime.container.JvmTypeBasedComponentDescriptor;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007J\u0014\u0010\r\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000fJ\u000e\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007J\u0014\u0010\u0011\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000fJ\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0013\u001a\u00020\u0014J\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u0016R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0017"}, d2={"Lruntime/container/ComponentRegisterEntry;", "", "()V", "value", "(Lruntime/container/ComponentRegisterEntry;)V", "descriptors", "", "Lruntime/container/JvmTypeBasedComponentDescriptor;", "getDescriptors", "()Ljava/util/List;", "add", "", "item", "addAll", "items", "", "remove", "removeAll", "singleOrNull", "request", "Ljava/lang/reflect/Type;", "toList", "", "platform-runtime"})
public final class ComponentRegisterEntry {
    @NotNull
    private final List<JvmTypeBasedComponentDescriptor> descriptors;

    @NotNull
    public final List<JvmTypeBasedComponentDescriptor> getDescriptors() {
        return this.descriptors;
    }

    public ComponentRegisterEntry() {
        this.descriptors = new ArrayList();
    }

    public ComponentRegisterEntry(@NotNull ComponentRegisterEntry value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.descriptors = new ArrayList();
        this.descriptors.addAll((Collection<JvmTypeBasedComponentDescriptor>)value2.descriptors);
    }

    @NotNull
    public final List<JvmTypeBasedComponentDescriptor> toList() {
        return CollectionsKt.toList((Iterable)this.descriptors);
    }

    @Nullable
    public final JvmTypeBasedComponentDescriptor singleOrNull(@NotNull Type request) {
        JvmTypeBasedComponentDescriptor jvmTypeBasedComponentDescriptor;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        int n = this.descriptors.size();
        switch (n) {
            case 0: {
                jvmTypeBasedComponentDescriptor = null;
                break;
            }
            case 1: {
                jvmTypeBasedComponentDescriptor = this.descriptors.get(0);
                break;
            }
            default: {
                String string2 = request.getTypeName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"request.typeName");
                throw new InvalidDependencyArityException(string2, this.descriptors);
            }
        }
        return jvmTypeBasedComponentDescriptor;
    }

    public final void add(@NotNull JvmTypeBasedComponentDescriptor item2) {
        Intrinsics.checkNotNullParameter((Object)item2, (String)"item");
        this.descriptors.add(item2);
    }

    public final void addAll(@NotNull Collection<? extends JvmTypeBasedComponentDescriptor> items2) {
        Intrinsics.checkNotNullParameter(items2, (String)"items");
        this.descriptors.addAll(items2);
    }

    public final void remove(@NotNull JvmTypeBasedComponentDescriptor item2) {
        Intrinsics.checkNotNullParameter((Object)item2, (String)"item");
        this.descriptors.remove(item2);
    }

    public final void removeAll(@NotNull Collection<? extends JvmTypeBasedComponentDescriptor> items2) {
        Intrinsics.checkNotNullParameter(items2, (String)"items");
        this.descriptors.removeAll(items2);
    }
}

