/*
 * Decompiled with CFR 0.152.
 */
package libraries.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import libraries.collections.IntRangeUnionKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\n\u001a\u00020\u000bJ\u0011\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0086\u0002J\u0011\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0086\u0002J\u0013\u0010\u0010\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u000e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0005J\b\u0010\u0013\u001a\u00020\u000fH\u0016J\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\u0006\u0010\u0012\u001a\u00020\u0005J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000fH\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u000e\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0005R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001b"}, d2={"Llibraries/collections/IntRangeUnion;", "", "()V", "myRanges", "", "Lkotlin/ranges/IntRange;", "ranges", "", "getRanges", "()Ljava/util/List;", "clear", "", "contains", "", "other", "", "equals", "exclude", "range", "hashCode", "intersection", "toInsertPosition", "x", "toString", "", "union", "Companion", "libraries-collections"})
public final class IntRangeUnion {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<IntRange> myRanges;
    @NotNull
    private final List<IntRange> ranges;

    public IntRangeUnion() {
        boolean bl = false;
        this.myRanges = new ArrayList();
        this.ranges = this.myRanges;
    }

    @NotNull
    public final List<IntRange> getRanges() {
        return this.ranges;
    }

    public final void clear() {
        this.myRanges.clear();
    }

    public final boolean contains(@NotNull IntRange other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (other.isEmpty()) {
            return true;
        }
        int startPos = CollectionsKt.binarySearch$default(this.myRanges, (Object)new IntRange(other.getFirst(), other.getFirst()), (Comparator)IntRangeUnionKt.access$getINTERSECTS_CMP$p(), (int)0, (int)0, (int)12, null);
        int endPos = CollectionsKt.binarySearch$default(this.myRanges, (Object)new IntRange(other.getLast(), other.getLast()), (Comparator)IntRangeUnionKt.access$getINTERSECTS_CMP$p(), (int)0, (int)0, (int)12, null);
        return startPos >= 0 && startPos == endPos;
    }

    public final boolean contains(int other) {
        return this.contains(new IntRange(other, other));
    }

    public final void exclude(@NotNull IntRange range3) {
        Intrinsics.checkNotNullParameter((Object)range3, (String)"range");
        if (range3.isEmpty()) {
            return;
        }
        int startPos = CollectionsKt.binarySearch$default(this.myRanges, (Object)new IntRange(range3.getFirst(), range3.getFirst()), (Comparator)IntRangeUnionKt.access$getINTERSECTS_CMP$p(), (int)0, (int)0, (int)12, null);
        int endPos = CollectionsKt.binarySearch$default(this.myRanges, (Object)new IntRange(range3.getLast(), range3.getLast()), (Comparator)IntRangeUnionKt.access$getINTERSECTS_CMP$p(), (int)0, (int)0, (int)12, null);
        int lastTouched = endPos < 0 ? this.toInsertPosition(endPos) - 1 : endPos;
        List<IntRange> toEdit = this.myRanges.subList(this.toInsertPosition(startPos), lastTouched + 1);
        Collection collection = toEdit;
        boolean bl = false;
        if (!collection.isEmpty()) {
            int oldStart = toEdit.get(0).getFirst();
            int oldEnd = ((IntRange)CollectionsKt.last(toEdit)).getLast();
            toEdit.clear();
            if (oldStart < range3.getFirst()) {
                toEdit.add(new IntRange(oldStart, range3.getFirst() - 1));
            }
            if (oldEnd > range3.getLast()) {
                toEdit.add(new IntRange(range3.getLast() + 1, oldEnd));
            }
        }
    }

    @NotNull
    public final List<IntRange> intersection(@NotNull IntRange range3) {
        Intrinsics.checkNotNullParameter((Object)range3, (String)"range");
        boolean bl = false;
        List ret = new ArrayList();
        for (IntRange x : this.myRanges) {
            IntRange intersection = IntRangeUnionKt.intersectWith(x, range3);
            if (intersection.isEmpty()) continue;
            ret.add(intersection);
        }
        return ret;
    }

    public final void union(@NotNull IntRange range3) {
        Intrinsics.checkNotNullParameter((Object)range3, (String)"range");
        if (range3.isEmpty()) {
            return;
        }
        int startPos = CollectionsKt.binarySearch$default(this.myRanges, (Object)RangesKt.until((int)(range3.getFirst() - 1), (int)range3.getFirst()), (Comparator)IntRangeUnionKt.access$getINTERSECTS_CMP$p(), (int)0, (int)0, (int)12, null);
        int endPos = CollectionsKt.binarySearch$default(this.myRanges, (Object)new IntRange(range3.getLast() + 1, range3.getLast() + 1), (Comparator)IntRangeUnionKt.access$getINTERSECTS_CMP$p(), (int)0, (int)0, (int)12, null);
        int lastTouched = endPos < 0 ? this.toInsertPosition(endPos) - 1 : endPos;
        List<IntRange> toEdit = this.myRanges.subList(this.toInsertPosition(startPos), lastTouched + 1);
        Collection collection = toEdit;
        boolean bl = false;
        if (!collection.isEmpty()) {
            int oldStart = toEdit.get(0).getFirst();
            int oldEnd = ((IntRange)CollectionsKt.last(toEdit)).getLast();
            toEdit.clear();
            int n = range3.getFirst();
            boolean bl2 = false;
            int n2 = Math.min(oldStart, n);
            n = range3.getLast();
            bl2 = false;
            toEdit.add(new IntRange(n2, Math.max(oldEnd, n)));
        } else {
            toEdit.add(range3);
        }
    }

    @NotNull
    public String toString() {
        return Intrinsics.stringPlus((String)"ClosedIntRanges", (Object)CollectionsKt.joinToString$default((Iterable)this.myRanges, (CharSequence)",", (CharSequence)"(", (CharSequence)")", (int)0, null, null, (int)56, null));
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof IntRangeUnion && Intrinsics.areEqual(((IntRangeUnion)other).myRanges, this.myRanges);
    }

    public int hashCode() {
        return ((Object)this.myRanges).hashCode();
    }

    private final int toInsertPosition(int x) {
        return x < 0 ? -x - 1 : x;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a8\u0006\b"}, d2={"Llibraries/collections/IntRangeUnion$Companion;", "", "()V", "from", "Llibraries/collections/IntRangeUnion;", "ints", "", "", "libraries-collections"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IntRangeUnion from(@NotNull Set<Integer> ints) {
            Intrinsics.checkNotNullParameter(ints, (String)"ints");
            if (ints.isEmpty()) {
                return new IntRangeUnion();
            }
            IntRangeUnion resultingRanges = new IntRangeUnion();
            Integer leftBorder = null;
            Integer rightBorder = null;
            Iterator iterator2 = CollectionsKt.sorted((Iterable)ints).iterator();
            while (iterator2.hasNext()) {
                int n = ((Number)iterator2.next()).intValue();
                if (leftBorder == null) {
                    leftBorder = n;
                    rightBorder = n;
                    continue;
                }
                Integer n2 = rightBorder;
                Intrinsics.checkNotNull((Object)n2);
                if (n == n2 + 1) {
                    rightBorder = n;
                    continue;
                }
                resultingRanges.union(new IntRange(leftBorder.intValue(), rightBorder.intValue()));
                leftBorder = n;
                rightBorder = n;
            }
            if (leftBorder != null && rightBorder != null) {
                resultingRanges.union(new IntRange(leftBorder.intValue(), rightBorder.intValue()));
            }
            return resultingRanges;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

