/*
 * Decompiled with CFR 0.152.
 */
package circlet.pipelines.messages;

import circlet.pipelines.messages.ServiceMessage;
import circlet.pipelines.messages.ServiceMessages$special$;
import circlet.pipelines.messages.ServiceMessagesKt;
import circlet.pipelines.messages.TextServiceMessage;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import libraries.basics.ClassLoaderUtilsKt;
import libraries.klogging.KLogger;
import libraries.klogging.KLoggers;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004J\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcirclet/pipelines/messages/ServiceMessages;", "", "()V", "SERVICE_MESSAGE_START", "", "logger", "Llibraries/klogging/KLogger;", "parse", "Lcirclet/pipelines/messages/ServiceMessage;", "message", "parseWithPluginClassloader", "", "messages", "libraries-service-messages"})
public final class ServiceMessages {
    @NotNull
    public static final ServiceMessages INSTANCE = new ServiceMessages();
    @NotNull
    public static final String SERVICE_MESSAGE_START = "##circlet";
    @NotNull
    private static final KLogger logger;

    private ServiceMessages() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ServiceMessage parse(@NotNull String message2) {
        ServiceMessage serviceMessage;
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        if (StringsKt.startsWith$default((String)message2, (String)SERVICE_MESSAGE_START, (boolean)false, (int)2, null)) {
            String stripped = StringsKt.removePrefix((String)message2, (CharSequence)SERVICE_MESSAGE_START);
            try {
                void $this$readValue$iv;
                ObjectMapper objectMapper = ServiceMessagesKt.getMapper();
                Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"mapper");
                boolean $i$f$readValue = false;
                String string2 = stripped;
                void var6_9 = $this$readValue$iv;
                boolean $i$f$jacksonTypeRef = false;
                TypeReference typeReference = (TypeReference)new TypeReference<ServiceMessage>(){};
                return (ServiceMessage)var6_9.readValue(string2, typeReference);
            }
            catch (JsonProcessingException ex) {
                if (logger.isDebugEnabled()) {
                    KLogger this_$iv = logger;
                    boolean $i$f$debug = false;
                    if (this_$iv.isDebugEnabled()) {
                        Throwable throwable = ex;
                        KLogger kLogger = this_$iv;
                        boolean bl = false;
                        String string3 = Intrinsics.stringPlus((String)"Failed to deserialize a service message: ", (Object)message2);
                        kLogger.debug(throwable, string3);
                    }
                } else {
                    logger.info("Failed to deserialize a service message: " + message2 + ". Reason: " + ex.getMessage());
                }
                TextServiceMessage textServiceMessage = new TextServiceMessage(message2, null, null, 6, null);
                serviceMessage = textServiceMessage;
            }
        } else {
            serviceMessage = new TextServiceMessage(message2, null, null, 6, null);
        }
        return serviceMessage;
    }

    @NotNull
    public final List<ServiceMessage> parseWithPluginClassloader(@NotNull List<String> messages2) {
        Intrinsics.checkNotNullParameter(messages2, (String)"messages");
        ClassLoader classLoader = this.getClass().getClassLoader();
        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"javaClass.classLoader");
        return (List)ClassLoaderUtilsKt.withContextClassLoader(classLoader, (Function0)new Function0<List<? extends ServiceMessage>>(messages2){
            final /* synthetic */ List<String> $messages;
            {
                this.$messages = $messages;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<ServiceMessage> invoke() {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = this.$messages;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string2 = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    ServiceMessage serviceMessage = ServiceMessages.INSTANCE.parse((String)it);
                    collection.add(serviceMessage);
                }
                return (List)destination$iv$iv;
            }
        });
    }

    static {
        KLoggers $this$logger$iv = KLoggers.INSTANCE;
        boolean $i$f$logger = false;
        logger = $this$logger$iv.logger((Function0<String>)((Function0)special$$inlined$logger$1.INSTANCE));
    }
}

