/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.highlight;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.ui.scale.ScaleType;
import com.intellij.util.SVGLoader;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBImageIcon;
import java.awt.Component;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/qodana/highlight/SvgLoader;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "loadSvg", "Lcom/intellij/util/ui/JBImageIcon;", "path", "", "comp", "Ljavax/swing/JComponent;", "intellij.qodana"})
final class SvgLoader {
    private static final Logger LOG;
    @NotNull
    public static final SvgLoader INSTANCE;

    @Nullable
    public final JBImageIcon loadSvg(@NotNull String path, @NotNull JComponent comp) {
        JBImageIcon jBImageIcon;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)comp, (String)"comp");
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(path);
            byte[] bytes = (byte[])(inputStream != null ? inputStream.readAllBytes() : null);
            ScaleContext scaleContext = ScaleContext.create((Component)comp);
            Intrinsics.checkNotNullExpressionValue((Object)scaleContext, (String)"ScaleContext.create(comp)");
            ScaleContext ctx = scaleContext;
            BufferedImage bufferedImage = SVGLoader.loadWithoutCache((byte[])bytes, (float)((float)ctx.getScale(ScaleType.SYS_SCALE)));
            Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"SVGLoader.loadWithoutCac\u2026ype.SYS_SCALE).toFloat())");
            BufferedImage image = bufferedImage;
            Image hiDpi = ImageUtil.ensureHiDPI((Image)image, (ScaleContext)ctx);
            jBImageIcon = new JBImageIcon(hiDpi);
        }
        catch (Exception e) {
            LOG.error((Object)new Function0<String>(path){
                final /* synthetic */ String $path;

                @NotNull
                public final String invoke() {
                    return "Svg " + this.$path + " is not loaded";
                }
                {
                    this.$path = string;
                    super(0);
                }
            });
            jBImageIcon = null;
        }
        return jBImageIcon;
    }

    private SvgLoader() {
    }

    static {
        SvgLoader svgLoader;
        INSTANCE = svgLoader = new SvgLoader();
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SvgLoader.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }
}

