/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.highlight;

import com.google.gson.JsonParseException;
import com.intellij.analysis.problemsView.Problem;
import com.intellij.analysis.problemsView.ProblemsCollector;
import com.intellij.analysis.problemsView.toolWindow.ProblemsView;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.content.Content;
import com.intellij.util.io.PathKt;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import com.jetbrains.qodana.sarif.SarifUtil;
import com.jetbrains.qodana.sarif.model.Result;
import com.jetbrains.qodana.sarif.model.Run;
import com.jetbrains.qodana.sarif.model.SarifReport;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.QodanaBundle;
import org.jetbrains.qodana.highlight.ProblemsKt;
import org.jetbrains.qodana.highlight.SarifProblem;
import org.jetbrains.qodana.highlight.SarifProblemsProvider;

@com.intellij.openapi.components.State(name="QodanaReportsService", storages={@Storage(value="$WORKSPACE_FILE$", roamingType=RoamingType.DISABLED)})
@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u000f\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003:;<B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\b\u0010\u0019\u001a\u00020\u0011H\u0002J\u000e\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018J\u001c\u0010\u001b\u001a\u00020\u00112\u0012\u0010\u001c\u001a\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u001dj\u0002`\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u0011H\u0002J\u001c\u0010 \u001a\u00020\u00112\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\u00110\"H\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010\u00182\u0006\u0010%\u001a\u00020\fH\u0002J\b\u0010&\u001a\u0004\u0018\u00010\u0018J\b\u0010'\u001a\u0004\u0018\u00010\fJ\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000f0)J\b\u0010*\u001a\u00020\u0002H\u0016J\u0012\u0010+\u001a\u00020\u00112\b\u0010,\u001a\u0004\u0018\u00010\fH\u0002J\b\u0010-\u001a\u00020.H\u0002J\u0010\u0010/\u001a\u00020\u00112\u0006\u00100\u001a\u00020\u0002H\u0016J\u0012\u00101\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001a\u00101\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u00102\u001a\u00020\fH\u0002J\b\u00103\u001a\u00020\u0011H\u0002J\u000e\u00104\u001a\u00020\u00112\u0006\u00105\u001a\u00020\fJ\u0010\u00106\u001a\u00020\u00112\b\u00107\u001a\u0004\u0018\u00010\fJ\b\u00108\u001a\u00020\u0011H\u0002J\b\u00109\u001a\u00020\u0011H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lorg/jetbrains/qodana/highlight/QodanaReportsService;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jetbrains/qodana/highlight/QodanaReportsService$State;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "lock", "Ljava/lang/Object;", "problemsProvider", "Lorg/jetbrains/qodana/highlight/SarifProblemsProvider;", "reportGuidToHighlight", "Ljava/util/concurrent/atomic/AtomicReference;", "", "reports", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jetbrains/qodana/highlight/QodanaReportsService$ReportDescription;", "activatePanel", "", "addLocalReport", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "path", "Ljava/nio/file/Path;", "report", "Lcom/jetbrains/qodana/sarif/model/SarifReport;", "addProblemsToView", "addReport", "changeHighlightedReportProvider", "newReportProvider", "Lkotlin/Function0;", "Lorg/jetbrains/qodana/highlight/ReportProvider;", "filterOutInvalidReports", "forEachProblem", "block", "Lkotlin/Function1;", "Lorg/jetbrains/qodana/highlight/SarifProblem;", "getReportByGuid", "guid", "getReportForHighlight", "getReportGuidToHighlight", "getReports", "", "getState", "highlightNewReport", "newHighlightedReportGuid", "isReportForHighlightAvailable", "", "loadState", "state", "parseReport", "reportId", "removeProblemsFromView", "removeReport", "reportGuid", "setReportToHighlight", "newReportToHighlightGuid", "unhighlightCurrentReport", "validateReportForHighlight", "ReportDescription", "ReportDescriptionState", "State", "intellij.qodana"})
public final class QodanaReportsService
implements PersistentStateComponent<State> {
    private final ConcurrentHashMap<String, ReportDescription> reports;
    private final SarifProblemsProvider problemsProvider;
    private final Object lock;
    private final AtomicReference<String> reportGuidToHighlight;
    private final Project project;

    @NotNull
    public final ReportDescription addLocalReport(@NotNull Path path, @NotNull SarifReport report) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)report, (String)"report");
        Object object = (Run)report.getRuns().get(0);
        if (object == null || (object = object.getAutomationDetails()) == null || (object = object.getGuid()) == null) {
            String string = UUID.randomUUID().toString();
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UUID.randomUUID().toString()");
        }
        Object guid = object;
        Object object2 = (Run)report.getRuns().get(0);
        if (object2 == null || (object2 = object2.getAutomationDetails()) == null || (object2 = object2.getId()) == null) {
            object2 = guid;
        }
        Run reportId = object2;
        ReportDescription reportDescription2 = new ReportDescription((String)guid, (String)reportId, path, (Function0<? extends SarifReport>)((Function0)new Function0<SarifReport>(this, path, (String)reportId){
            final /* synthetic */ QodanaReportsService this$0;
            final /* synthetic */ Path $path;
            final /* synthetic */ String $reportId;

            @Nullable
            public final SarifReport invoke() {
                return QodanaReportsService.access$parseReport(this.this$0, this.$path, this.$reportId);
            }
            {
                this.this$0 = qodanaReportsService;
                this.$path = path;
                this.$reportId = string;
                super(0);
            }
        }));
        ((Map)this.reports).put(guid, reportDescription2);
        return reportDescription2;
    }

    @Nullable
    public final ReportDescription addLocalReport(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Path path = file.toNioPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"file.toNioPath()");
        Path path2 = path;
        try {
            SarifReport sarifReport = this.parseReport(path2);
            if (sarifReport == null) {
                return null;
            }
            SarifReport report = sarifReport;
            Path path3 = path2.toAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"path.toAbsolutePath()");
            return this.addLocalReport(path3, report);
        }
        catch (JsonParseException e) {
            NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Qodana");
            String string = QodanaBundle.message("notification.title.cant.parse.report", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"QodanaBundle.message(\"no\u2026title.cant.parse.report\")");
            String string2 = QodanaBundle.message("notification.content.cant.parse.report.from.file.wo.report.id", path2.toAbsolutePath());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"QodanaBundle.message(\"no\u2026\", path.toAbsolutePath())");
            notificationGroup.createNotification(string, string2, NotificationType.WARNING).notify(this.project);
            return null;
        }
    }

    @NotNull
    public final ReportDescription addReport(@NotNull SarifReport report) {
        Intrinsics.checkNotNullParameter((Object)report, (String)"report");
        Object object = (Run)report.getRuns().get(0);
        if (object == null || (object = object.getAutomationDetails()) == null || (object = object.getGuid()) == null) {
            String string = UUID.randomUUID().toString();
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UUID.randomUUID().toString()");
        }
        Object guid = object;
        Object object2 = (Run)report.getRuns().get(0);
        if (object2 == null || (object2 = object2.getAutomationDetails()) == null || (object2 = object2.getId()) == null) {
            object2 = guid;
        }
        Run reportId = object2;
        ReportDescription reportDescription2 = new ReportDescription((String)guid, (String)reportId, null, (Function0<? extends SarifReport>)((Function0)new Function0<SarifReport>(report){
            final /* synthetic */ SarifReport $report;

            @Nullable
            public final SarifReport invoke() {
                return this.$report;
            }
            {
                this.$report = sarifReport;
                super(0);
            }
        }));
        ((Map)this.reports).put(guid, reportDescription2);
        return reportDescription2;
    }

    @NotNull
    public final Collection<ReportDescription> getReports() {
        this.filterOutInvalidReports();
        Collection<ReportDescription> collection = this.reports.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"reports.values");
        return collection;
    }

    @Nullable
    public final String getReportGuidToHighlight() {
        this.validateReportForHighlight();
        return this.reportGuidToHighlight.get();
    }

    @Nullable
    public final SarifReport getReportForHighlight() {
        SarifReport sarifReport;
        String string = this.getReportGuidToHighlight();
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            sarifReport = this.getReportByGuid(it);
        } else {
            sarifReport = null;
        }
        return sarifReport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setReportToHighlight(@Nullable String newReportToHighlightGuid) {
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            if (Intrinsics.areEqual((Object)this.reportGuidToHighlight.get(), (Object)newReportToHighlightGuid) ^ true) {
                this.removeProblemsFromView();
                this.unhighlightCurrentReport();
                this.highlightNewReport(newReportToHighlightGuid);
            }
            if (this.reportGuidToHighlight.get() != null) {
                this.addProblemsToView();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public final void removeReport(@NotNull String reportGuid) {
        Intrinsics.checkNotNullParameter((Object)reportGuid, (String)"reportGuid");
        if (Intrinsics.areEqual((Object)reportGuid, (Object)this.reportGuidToHighlight.get())) {
            this.setReportToHighlight(null);
        }
        this.reports.remove(reportGuid);
    }

    private final void unhighlightCurrentReport() {
        String guid = this.reportGuidToHighlight.get();
        if (guid != null && this.reports.containsKey(guid)) {
            ReportDescription reportDescription2 = this.reports.get(guid);
            Intrinsics.checkNotNull((Object)reportDescription2);
            Intrinsics.checkNotNullExpressionValue((Object)reportDescription2, (String)"reports[guid]!!");
            ReportDescription reportDescription3 = reportDescription2;
            Path path = reportDescription3.getPath();
            if (path != null) {
                this.changeHighlightedReportProvider((Function0<? extends SarifReport>)((Function0)new Function0<SarifReport>(this, path, reportDescription3){
                    final /* synthetic */ QodanaReportsService this$0;
                    final /* synthetic */ Path $path;
                    final /* synthetic */ ReportDescription $reportDescription;

                    @Nullable
                    public final SarifReport invoke() {
                        return QodanaReportsService.access$parseReport(this.this$0, this.$path, this.$reportDescription.getReportId());
                    }
                    {
                        this.this$0 = qodanaReportsService;
                        this.$path = path;
                        this.$reportDescription = reportDescription2;
                        super(0);
                    }
                }));
            }
        }
        this.reportGuidToHighlight.set(null);
    }

    private final void highlightNewReport(String newHighlightedReportGuid) {
        this.reportGuidToHighlight.set(newHighlightedReportGuid);
        if (newHighlightedReportGuid != null) {
            SarifReport newHighlightedReport = this.getReportByGuid(newHighlightedReportGuid);
            if (newHighlightedReport == null) {
                this.reportGuidToHighlight.set(null);
                this.reports.remove(newHighlightedReportGuid);
            } else {
                this.changeHighlightedReportProvider((Function0<? extends SarifReport>)((Function0)new Function0<SarifReport>(newHighlightedReport){
                    final /* synthetic */ SarifReport $newHighlightedReport;

                    @Nullable
                    public final SarifReport invoke() {
                        return this.$newHighlightedReport;
                    }
                    {
                        this.$newHighlightedReport = sarifReport;
                        super(0);
                    }
                }));
            }
        }
    }

    private final void validateReportForHighlight() {
        String string = this.reportGuidToHighlight.get();
        if (string == null) {
            return;
        }
        String guid = string;
        if (!this.isReportForHighlightAvailable()) {
            ReportDescription reportDescription2 = this.reports.get(guid);
            Path path = reportDescription2 != null ? reportDescription2.getPath() : null;
            this.setReportToHighlight(null);
            this.reports.remove(guid);
            NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Qodana");
            String string2 = QodanaBundle.message("notification.title.cant.parse.report", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"QodanaBundle.message(\"no\u2026title.cant.parse.report\")");
            String string3 = QodanaBundle.message("notification.content.report.file.does.not.exist", String.valueOf(path));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"QodanaBundle.message(\"no\u2026.exist\", path.toString())");
            notificationGroup.createNotification(string2, string3, NotificationType.WARNING).notify(this.project);
        }
    }

    private final boolean isReportForHighlightAvailable() {
        String string = this.reportGuidToHighlight.get();
        if (string == null) {
            return false;
        }
        ReportDescription reportDescription2 = this.reports.get(string);
        if (reportDescription2 == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)reportDescription2, (String)"reports[reportGuidToHigh\u2026rn false] ?: return false");
        ReportDescription reportDescription3 = reportDescription2;
        Path path = reportDescription3.getPath();
        return path != null ? PathKt.exists((Path)path) : true;
    }

    private final void changeHighlightedReportProvider(Function0<? extends SarifReport> newReportProvider) {
        String string = this.reportGuidToHighlight.get();
        if (string == null) {
            return;
        }
        String highlightedReportGuid = string;
        ReportDescription reportDescription2 = this.reports.get(highlightedReportGuid);
        if (reportDescription2 == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)reportDescription2, (String)"reports[highlightedReportGuid] ?: return");
        ReportDescription reportDescription3 = reportDescription2;
        ((Map)this.reports).put(highlightedReportGuid, new ReportDescription(reportDescription3.getReportGuid(), reportDescription3.getReportId(), reportDescription3.getPath(), newReportProvider));
    }

    /*
     * WARNING - void declaration
     */
    private final void forEachProblem(Function1<? super SarifProblem, Unit> block) {
        void $this$forEach$iv;
        void $this$flatMapTo$iv$iv;
        Object it;
        String string;
        block7: {
            block6: {
                string = this.reportGuidToHighlight.get();
                if (string == null) break block6;
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                it = string2;
                boolean bl3 = false;
                string = this.getReportByGuid((String)it);
                if (string != null) break block7;
            }
            return;
        }
        String report = string;
        Object object = (Run)report.getRuns().get(0);
        if (object == null || (object = object.getResults()) == null) {
            return;
        }
        Object results = object;
        Iterable $this$flatMap$iv = (Iterable)results;
        boolean $i$f$flatMap = false;
        it = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Result it2 = (Result)element$iv$iv;
            boolean bl = false;
            Result result = it2;
            Intrinsics.checkNotNullExpressionValue((Object)result, (String)"it");
            Iterable list$iv$iv = ProblemsKt.toProblems(result, this.project, this.problemsProvider);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SarifProblem it3 = (SarifProblem)element$iv;
            boolean bl = false;
            block.invoke((Object)it3);
        }
    }

    private final void filterOutInvalidReports() {
        this.validateReportForHighlight();
        Map $this$filterValues$iv = this.reports;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        Map map = $this$filterValues$iv;
        boolean bl = false;
        for (Map.Entry entry$iv : map.entrySet()) {
            boolean bl2;
            ReportDescription it = (ReportDescription)entry$iv.getValue();
            boolean bl3 = false;
            if (it.getPath() != null) {
                Path path;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                boolean bl4 = false;
                bl2 = Files.notExists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
            } else {
                bl2 = false;
            }
            if (!bl2) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Set outdatedReportsGuids = ((Map)result$iv).keySet();
        Iterable $this$forEach$iv = outdatedReportsGuids;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl5 = false;
            this.reports.remove(it);
        }
    }

    private final void removeProblemsFromView() {
        Project $this$service$iv = this.project;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(ProblemsCollector.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
        ProblemsCollector collector = (ProblemsCollector)object;
        this.forEachProblem((Function1<? super SarifProblem, Unit>)((Function1)new Function1<SarifProblem, Unit>(collector){
            final /* synthetic */ ProblemsCollector $collector;

            public final void invoke(@NotNull SarifProblem it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$collector.problemDisappeared((Problem)it);
            }
            {
                this.$collector = problemsCollector;
                super(1);
            }
        }));
    }

    private final void addProblemsToView() {
        Project $this$service$iv = this.project;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(ProblemsCollector.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
        ProblemsCollector collector = (ProblemsCollector)object;
        this.forEachProblem((Function1<? super SarifProblem, Unit>)((Function1)new Function1<SarifProblem, Unit>(collector){
            final /* synthetic */ ProblemsCollector $collector;

            public final void invoke(@NotNull SarifProblem it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$collector.problemAppeared((Problem)it);
            }
            {
                this.$collector = problemsCollector;
                super(1);
            }
        }));
        ModalityState modalityState$iv = null;
        boolean $i$f$invokeLater = false;
        Application application = ApplicationManager.getApplication();
        Runnable runnable = new Runnable(this){
            final /* synthetic */ QodanaReportsService this$0;
            {
                this.this$0 = qodanaReportsService;
            }

            public final void run() {
                boolean bl = false;
                QodanaReportsService.access$activatePanel(this.this$0);
            }
        };
        ModalityState modalityState = ModalityState.defaultModalityState();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
        application.invokeLater(runnable, modalityState);
    }

    private final void activatePanel() {
        block2: {
            ToolWindow toolWindow = ProblemsView.getToolWindow((Project)this.project);
            if (toolWindow == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)toolWindow, (String)"ProblemsView.getToolWindow(project) ?: return");
            ToolWindow toolWindow2 = toolWindow;
            Content content = toolWindow2.getContentManager().getContent(1);
            if (content == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)content, (String)"toolWindow.contentManage\u2026RORS_TAB_INDEX) ?: return");
            Content content2 = content;
            toolWindow2.getContentManager().setSelectedContent(content2);
            ToolWindow toolWindow3 = ProblemsView.getToolWindow((Project)this.project);
            if (toolWindow3 == null) break block2;
            toolWindow3.activate(null);
        }
    }

    private final SarifReport getReportByGuid(String guid) {
        ReportDescription reportDescription2 = this.reports.get(guid);
        if (reportDescription2 == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)reportDescription2, (String)"reports[guid] ?: return null");
        ReportDescription description = reportDescription2;
        return (SarifReport)description.getReportProvider().invoke();
    }

    private final SarifReport parseReport(Path path) {
        Path path2;
        Path path3 = path;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        boolean bl = false;
        if (Files.notExists(path3, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Qodana");
            String string = QodanaBundle.message("notification.title.cant.parse.report", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"QodanaBundle.message(\"no\u2026title.cant.parse.report\")");
            String string2 = QodanaBundle.message("notification.content.report.file.does.not.exist", ((Object)path.toAbsolutePath()).toString());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"QodanaBundle.message(\"no\u2026bsolutePath().toString())");
            notificationGroup.createNotification(string, string2, NotificationType.WARNING).notify(this.project);
            return null;
        }
        SarifReport sarifReport = SarifUtil.readReport((Path)path);
        if (sarifReport != null) {
            path3 = sarifReport;
            boolean bl2 = false;
            bl = false;
            Path $this$apply = path3;
            boolean bl3 = false;
            ProblemsKt.filterOutAbsentResults((SarifReport)$this$apply);
            path2 = path3;
        } else {
            path2 = null;
        }
        return path2;
    }

    private final SarifReport parseReport(Path path, String reportId) {
        try {
            return this.parseReport(path);
        }
        catch (JsonParseException e) {
            NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Qodana");
            String string = QodanaBundle.message("notification.title.cant.parse.report", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"QodanaBundle.message(\"no\u2026title.cant.parse.report\")");
            String string2 = QodanaBundle.message("notification.content.cant.parse.report.from.file", reportId, ((Object)path.toAbsolutePath()).toString());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"QodanaBundle.message(\"no\u2026bsolutePath().toString())");
            notificationGroup.createNotification(string, string2, NotificationType.WARNING).notify(this.project);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public State getState() {
        void $this$mapTo$iv$iv;
        ReportDescription it;
        Iterable $this$filterTo$iv$iv;
        Collection<ReportDescription> collection = this.reports.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"reports.values");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ReportDescription)element$iv$iv;
            boolean bl = false;
            if (!(it.getPath() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection<ReportDescriptionState> collection2 = (List)destination$iv$iv;
        Iterable $this$map$iv = collection2;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void value;
            it = (ReportDescription)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl = false;
            ReportDescriptionState reportDescriptionState = new ReportDescriptionState();
            boolean bl2 = false;
            boolean bl3 = false;
            ReportDescriptionState it2 = reportDescriptionState;
            boolean bl4 = false;
            it2.setReportGuid(value.getReportGuid());
            it2.setReportId(value.getReportId());
            it2.setPath(String.valueOf(value.getPath()));
            ReportDescriptionState reportDescriptionState2 = reportDescriptionState;
            collection2.add(reportDescriptionState2);
        }
        collection2 = (List)destination$iv$iv;
        List list = collection2;
        return new State(list);
    }

    /*
     * WARNING - void declaration
     */
    public void loadState(@NotNull State state) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.reports.clear();
        Iterable iterable = state.getDescriptions();
        Map map = this.reports;
        boolean $i$f$mapNotNull = false;
        void var4_5 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Path path;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ReportDescriptionState it = (ReportDescriptionState)element$iv$iv;
            boolean bl2 = false;
            String string = it.getPath();
            Intrinsics.checkNotNull((Object)string);
            Path path2 = path = Paths.get(string, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path");
            if (PathKt.exists((Path)path2)) {
                String string2 = it.getReportGuid();
                Intrinsics.checkNotNull((Object)string2);
                String string3 = it.getReportGuid();
                Intrinsics.checkNotNull((Object)string3);
                String string4 = it.getReportId();
                Intrinsics.checkNotNull((Object)string4);
                pair = TuplesKt.to((Object)string2, (Object)new ReportDescription(string3, string4, path, (Function0<? extends SarifReport>)((Function0)new Function0<SarifReport>(path, it, this){
                    final /* synthetic */ Path $path;
                    final /* synthetic */ ReportDescriptionState $it;
                    final /* synthetic */ QodanaReportsService this$0;
                    {
                        this.$path = path;
                        this.$it = reportDescriptionState;
                        this.this$0 = qodanaReportsService;
                        super(0);
                    }

                    @Nullable
                    public final SarifReport invoke() {
                        Path path = this.$path;
                        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
                        String string = this.$it.getReportId();
                        Intrinsics.checkNotNull((Object)string);
                        return QodanaReportsService.access$parseReport(this.this$0, path, string);
                    }
                })));
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair pair2 = pair;
            boolean bl3 = false;
            boolean bl4 = false;
            Pair it$iv$iv = pair2;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list = (List)destination$iv$iv;
        MapsKt.putAll((Map)map, (Iterable)list);
    }

    public QodanaReportsService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.reports = new ConcurrentHashMap();
        this.problemsProvider = new SarifProblemsProvider(this.project);
        this.lock = new Object();
        this.reportGuidToHighlight = new AtomicReference();
    }

    public static final /* synthetic */ SarifReport access$parseReport(QodanaReportsService $this, Path path, String reportId) {
        return $this.parseReport(path, reportId);
    }

    public static final /* synthetic */ void access$activatePanel(QodanaReportsService $this) {
        $this.activatePanel();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0006\u0012\u0004\u0018\u00010\t0\bj\u0002`\n\u00a2\u0006\u0002\u0010\u000bR\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0011\"\u0004\b\u0015\u0010\u0013R\u001d\u0010\u0007\u001a\u000e\u0012\u0006\u0012\u0004\u0018\u00010\t0\bj\u0002`\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/qodana/highlight/QodanaReportsService$ReportDescription;", "", "reportGuid", "", "reportId", "path", "Ljava/nio/file/Path;", "reportProvider", "Lkotlin/Function0;", "Lcom/jetbrains/qodana/sarif/model/SarifReport;", "Lorg/jetbrains/qodana/highlight/ReportProvider;", "(Ljava/lang/String;Ljava/lang/String;Ljava/nio/file/Path;Lkotlin/jvm/functions/Function0;)V", "getPath", "()Ljava/nio/file/Path;", "setPath", "(Ljava/nio/file/Path;)V", "getReportGuid", "()Ljava/lang/String;", "setReportGuid", "(Ljava/lang/String;)V", "getReportId", "setReportId", "getReportProvider", "()Lkotlin/jvm/functions/Function0;", "intellij.qodana"})
    public static final class ReportDescription {
        @NotNull
        private String reportGuid;
        @NotNull
        private String reportId;
        @Nullable
        private Path path;
        @NotNull
        private final Function0<SarifReport> reportProvider;

        @NotNull
        public final String getReportGuid() {
            return this.reportGuid;
        }

        public final void setReportGuid(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.reportGuid = string;
        }

        @NotNull
        public final String getReportId() {
            return this.reportId;
        }

        public final void setReportId(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.reportId = string;
        }

        @Nullable
        public final Path getPath() {
            return this.path;
        }

        public final void setPath(@Nullable Path path) {
            this.path = path;
        }

        @NotNull
        public final Function0<SarifReport> getReportProvider() {
            return this.reportProvider;
        }

        public ReportDescription(@NotNull String reportGuid, @NotNull String reportId, @Nullable Path path, @NotNull Function0<? extends SarifReport> reportProvider) {
            Intrinsics.checkNotNullParameter((Object)reportGuid, (String)"reportGuid");
            Intrinsics.checkNotNullParameter((Object)reportId, (String)"reportId");
            Intrinsics.checkNotNullParameter(reportProvider, (String)"reportProvider");
            this.reportGuid = reportGuid;
            this.reportId = reportId;
            this.path = path;
            this.reportProvider = reportProvider;
        }
    }

    @Tag(value="ReportDescription")
    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001e\u0010\u0003\u001a\u0004\u0018\u00010\u00048GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u0004\u0018\u00010\u00048GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001e\u0010\f\u001a\u0004\u0018\u00010\u00048GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u0006\"\u0004\b\u000e\u0010\b\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/qodana/highlight/QodanaReportsService$ReportDescriptionState;", "", "()V", "path", "", "getPath", "()Ljava/lang/String;", "setPath", "(Ljava/lang/String;)V", "reportGuid", "getReportGuid", "setReportGuid", "reportId", "getReportId", "setReportId", "intellij.qodana"})
    public static final class ReportDescriptionState {
        @Nullable
        private String reportGuid;
        @Nullable
        private String reportId;
        @Nullable
        private String path;

        @Attribute
        @Nullable
        public final String getReportGuid() {
            return this.reportGuid;
        }

        public final void setReportGuid(@Nullable String string) {
            this.reportGuid = string;
        }

        @Attribute
        @Nullable
        public final String getReportId() {
            return this.reportId;
        }

        public final void setReportId(@Nullable String string) {
            this.reportId = string;
        }

        @Attribute
        @Nullable
        public final String getPath() {
            return this.path;
        }

        public final void setPath(@Nullable String string) {
            this.path = string;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u001c\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/qodana/highlight/QodanaReportsService$State;", "", "descriptions", "", "Lorg/jetbrains/qodana/highlight/QodanaReportsService$ReportDescriptionState;", "(Ljava/util/List;)V", "getDescriptions", "()Ljava/util/List;", "intellij.qodana"})
    public static final class State {
        @XCollection
        @NotNull
        private final List<ReportDescriptionState> descriptions;

        @NotNull
        public final List<ReportDescriptionState> getDescriptions() {
            return this.descriptions;
        }

        public State(@NotNull List<ReportDescriptionState> descriptions) {
            Intrinsics.checkNotNullParameter(descriptions, (String)"descriptions");
            this.descriptions = descriptions;
        }

        public /* synthetic */ State(List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                boolean bl = false;
                list = CollectionsKt.emptyList();
            }
            this(list);
        }

        public State() {
            this(null, 1, null);
        }
    }
}

