/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.highlight;

import com.intellij.analysis.problemsView.ProblemsProvider;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.qodana.sarif.model.ArtifactLocation;
import com.jetbrains.qodana.sarif.model.Level;
import com.jetbrains.qodana.sarif.model.Location;
import com.jetbrains.qodana.sarif.model.Message;
import com.jetbrains.qodana.sarif.model.PhysicalLocation;
import com.jetbrains.qodana.sarif.model.Region;
import com.jetbrains.qodana.sarif.model.Result;
import com.jetbrains.qodana.sarif.model.Run;
import com.jetbrains.qodana.sarif.model.SarifReport;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.QodanaBundle;
import org.jetbrains.qodana.highlight.SarifProblem;
import org.jetbrains.qodana.highlight.SarifProblemsProvider;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000l\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0000\u001a\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001a\u0019\u0010\u000f\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0010*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u001a\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0016H\u0000\u001a\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018*\u00020\u00072\u0006\u0010\f\u001a\u00020\u0001H\u0000\u001a\"\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0018*\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001dH\u0000\u001a$\u0010\u001e\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u0019\u0018\u00010\u001f*\u00020 2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001a\u0016\u0010!\u001a\u0004\u0018\u00010\t*\u00020\u00192\u0006\u0010\"\u001a\u00020#H\u0000\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0002\u0010\u0003\u00a8\u0006$"}, d2={"SRCROOT_URI_BASE", "", "getSRCROOT_URI_BASE$annotations", "()V", "buildHighlightInfo", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "result", "Lcom/jetbrains/qodana/sarif/model/Result;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "findRelativeVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "relativePath", "project", "Lcom/intellij/openapi/project/Project;", "buildEditorMessage", "Lcom/intellij/openapi/util/NlsSafe;", "Lcom/jetbrains/qodana/sarif/model/Message;", "sarifLevel", "Lcom/jetbrains/qodana/sarif/model/Level;", "filterOutAbsentResults", "", "Lcom/jetbrains/qodana/sarif/model/SarifReport;", "findRangesIn", "", "Lcom/jetbrains/qodana/sarif/model/Region;", "toProblems", "Lorg/jetbrains/qodana/highlight/SarifProblem;", "problemsProvider", "Lorg/jetbrains/qodana/highlight/SarifProblemsProvider;", "toRange", "Lkotlin/Pair;", "Lcom/jetbrains/qodana/sarif/model/PhysicalLocation;", "toTextRange", "document", "Lcom/intellij/openapi/editor/Document;", "intellij.qodana"})
public final class ProblemsKt {
    private static final String SRCROOT_URI_BASE = "SRCROOT";

    private static /* synthetic */ void getSRCROOT_URI_BASE$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Region> findRangesIn(@NotNull Result $this$findRangesIn, @NotNull String relativePath) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$findRangesIn, (String)"$this$findRangesIn");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        List list = $this$findRangesIn.getLocations();
        if (list == null) {
            return CollectionsKt.emptyList();
        }
        List locations = list;
        Iterable $this$mapNotNull$iv = locations;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Region region;
            ArtifactLocation artifactLocation;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Location it = (Location)element$iv$iv;
            boolean bl2 = false;
            Location location = it;
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"it");
            PhysicalLocation physicalLocation = location.getPhysicalLocation();
            ArtifactLocation artifactLocation2 = artifactLocation = physicalLocation != null ? physicalLocation.getArtifactLocation() : null;
            if (Intrinsics.areEqual((Object)(artifactLocation2 != null ? artifactLocation2.getUriBaseId() : null), (Object)SRCROOT_URI_BASE) && Intrinsics.areEqual((Object)artifactLocation.getUri(), (Object)relativePath)) {
                PhysicalLocation physicalLocation2 = it.getPhysicalLocation();
                Intrinsics.checkNotNullExpressionValue((Object)physicalLocation2, (String)"it.physicalLocation");
                region = physicalLocation2.getRegion();
            } else {
                region = null;
            }
            if (region == null) continue;
            Region region2 = region;
            boolean bl3 = false;
            boolean bl4 = false;
            Region it$iv$iv = region2;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final TextRange toTextRange(@NotNull Region $this$toTextRange, @NotNull Document document) {
        int offset;
        block11: {
            block10: {
                boolean bl;
                Integer n;
                block9: {
                    block8: {
                        Intrinsics.checkNotNullParameter((Object)$this$toTextRange, (String)"$this$toTextRange");
                        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
                        Integer n2 = $this$toTextRange.getCharLength();
                        if (n2 == null) {
                            return null;
                        }
                        n2.intValue();
                        n = $this$toTextRange.getStartLine();
                        if (n == null) break block8;
                        Integer n3 = n;
                        boolean bl2 = false;
                        bl = false;
                        int it = ((Number)n3).intValue();
                        boolean bl3 = false;
                        Integer n4 = it - 1 < document.getLineCount() ? Integer.valueOf(document.getLineStartOffset(it - 1)) : null;
                        n = n4;
                        if (n4 != null) break block9;
                    }
                    return null;
                }
                int lineStartOffset = n;
                Integer n5 = $this$toTextRange.getStartColumn();
                if (n5 == null) {
                    return null;
                }
                Integer n6 = n5;
                bl = false;
                boolean bl4 = false;
                int it = ((Number)n6).intValue();
                boolean bl5 = false;
                int offsetInsideLine = it - 1;
                offset = lineStartOffset + offsetInsideLine;
                if (offset > document.getLineEndOffset($this$toTextRange.getStartLine() - 1)) break block10;
                Integer n7 = $this$toTextRange.getCharLength();
                Intrinsics.checkNotNullExpressionValue((Object)n7, (String)"charLength");
                if (offset + n7 <= document.getTextLength()) break block11;
            }
            return null;
        }
        Integer n = $this$toTextRange.getCharLength();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"charLength");
        return new TextRange(offset, offset + n);
    }

    @Nullable
    public static final HighlightInfo buildHighlightInfo(@NotNull Result result, @Nullable TextRange textRange) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        if (textRange == null) {
            return null;
        }
        Level sarifLevel = result.getLevel();
        HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.GENERIC_WARNINGS_OR_ERRORS_FROM_SERVER);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"HighlightInfo.newHighlig\u2026GS_OR_ERRORS_FROM_SERVER)");
        HighlightInfo.Builder builder2 = builder;
        HighlightInfo.Builder builder3 = builder2.range(textRange).needsUpdateOnTyping(true);
        Message message = result.getMessage();
        Intrinsics.checkNotNullExpressionValue((Object)message, (String)"result.message");
        Level level = sarifLevel;
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"sarifLevel");
        return builder3.descriptionAndTooltip(ProblemsKt.buildEditorMessage(message, level)).create();
    }

    @NotNull
    public static final String buildEditorMessage(@NotNull Message $this$buildEditorMessage, @NotNull Level sarifLevel) {
        Intrinsics.checkNotNullParameter((Object)$this$buildEditorMessage, (String)"$this$buildEditorMessage");
        Intrinsics.checkNotNullParameter((Object)sarifLevel, (String)"sarifLevel");
        String string = ProblemDescriptorUtil.unescapeTags((String)$this$buildEditorMessage.getText());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ProblemDescriptorUtil.unescapeTags(text)");
        String message = string;
        String string2 = QodanaBundle.message("text.qodana.result", sarifLevel, message);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"QodanaBundle.message(\"te\u2026lt\", sarifLevel, message)");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<SarifProblem> toProblems(@NotNull Result $this$toProblems, @NotNull Project project, @NotNull SarifProblemsProvider problemsProvider) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        int n;
        Object element$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$toProblems, (String)"$this$toProblems");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)problemsProvider, (String)"problemsProvider");
        List list = $this$toProblems.getLocations();
        if (list == null) {
            return CollectionsKt.emptyList();
        }
        List locations = list;
        Iterable $this$mapNotNull$iv = locations;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Pair pair = $this$forEach$iv$iv$iv.iterator();
        while (pair.hasNext()) {
            Pair<VirtualFile, Region> pair2;
            Object element$iv$iv$iv;
            element$iv$iv = element$iv$iv$iv = pair.next();
            boolean bl = false;
            Location it = (Location)element$iv$iv;
            boolean bl2 = false;
            Location location = it;
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"it");
            PhysicalLocation physicalLocation = location.getPhysicalLocation();
            if ((physicalLocation != null ? ProblemsKt.toRange(physicalLocation, project) : null) == null) continue;
            pair2 = pair2;
            n = 0;
            boolean bl3 = false;
            Pair<VirtualFile, Region> it$iv$iv = pair2;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            int n2;
            Object object;
            int n3;
            int n4;
            int it;
            void var21_27;
            ProblemsProvider problemsProvider2;
            String string;
            boolean bl;
            boolean bl5;
            Object object2;
            void file;
            void $dstr$file$range;
            pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl6 = false;
            element$iv$iv = (VirtualFile)$dstr$file$range.component1();
            Region range = (Region)$dstr$file$range.component2();
            void v3 = file;
            ProblemsProvider problemsProvider3 = problemsProvider;
            Message message = $this$toProblems.getMessage();
            Intrinsics.checkNotNullExpressionValue((Object)message, (String)"message");
            Level level = $this$toProblems.getLevel();
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level");
            String string2 = ProblemsKt.buildEditorMessage(message, level);
            Object object3 = range;
            if (object3 != null && (object3 = object3.getStartLine()) != null) {
                object2 = object3;
                bl5 = false;
                bl = false;
                n = ((Number)object2).intValue();
                string = string2;
                problemsProvider2 = problemsProvider3;
                var21_27 = v3;
                boolean bl7 = false;
                n4 = it - 1;
                v3 = var21_27;
                problemsProvider3 = problemsProvider2;
                string2 = string;
                n3 = n4;
            } else {
                n3 = -1;
            }
            if ((object = range) != null && (object = object.getStartColumn()) != null) {
                object2 = object;
                bl5 = false;
                bl = false;
                it = ((Number)object2).intValue();
                n4 = n3;
                string = string2;
                problemsProvider2 = problemsProvider3;
                var21_27 = v3;
                boolean bl8 = false;
                int n5 = it - 1;
                v3 = var21_27;
                problemsProvider3 = problemsProvider2;
                string2 = string;
                n3 = n4;
                n2 = n5;
            } else {
                n2 = -1;
            }
            int n6 = n2;
            int n7 = n3;
            String string3 = string2;
            ProblemsProvider problemsProvider4 = problemsProvider3;
            void var33_37 = v3;
            SarifProblem sarifProblem = new SarifProblem((VirtualFile)var33_37, problemsProvider4, string3, n7, n6);
            collection.add(sarifProblem);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final VirtualFile findRelativeVirtualFile(@NotNull String relativePath, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Sequence sequence = SequencesKt.sequenceOf((Object[])new VirtualFile[]{ProjectUtil.guessProjectDir((Project)project)});
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)projectRootManager, (String)"ProjectRootManager.getInstance(project)");
        Object[] objectArray = projectRootManager.getContentRoots();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"ProjectRootManager.getIn\u2026nce(project).contentRoots");
        VirtualFile virtualFile = (VirtualFile)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.plus((Sequence)sequence, (Object[])objectArray)), (Function1)((Function1)new Function1<VirtualFile, VirtualFile>(relativePath){
            final /* synthetic */ String $relativePath;

            @Nullable
            public final VirtualFile invoke(@NotNull VirtualFile baseVirtualFile) {
                Intrinsics.checkNotNullParameter((Object)baseVirtualFile, (String)"baseVirtualFile");
                return baseVirtualFile.findFileByRelativePath(this.$relativePath);
            }
            {
                this.$relativePath = string;
                super(1);
            }
        })));
        if (virtualFile == null) {
            String string = project.getBasePath();
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                virtualFile = VfsUtil.findFileByIoFile((File)new File(it, relativePath), (boolean)true);
            } else {
                virtualFile = null;
            }
        }
        return virtualFile;
    }

    @Nullable
    public static final Pair<VirtualFile, Region> toRange(@NotNull PhysicalLocation $this$toRange, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$toRange, (String)"$this$toRange");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ArtifactLocation artifactLocation = $this$toRange.getArtifactLocation();
        Intrinsics.checkNotNullExpressionValue((Object)artifactLocation, (String)"artifactLocation");
        String string = artifactLocation.getUri();
        if (string == null) {
            return null;
        }
        String uri = string;
        ArtifactLocation artifactLocation2 = $this$toRange.getArtifactLocation();
        if (Intrinsics.areEqual((Object)(artifactLocation2 != null ? artifactLocation2.getUriBaseId() : null), (Object)SRCROOT_URI_BASE) ^ true) {
            return null;
        }
        VirtualFile virtualFile = ProblemsKt.findRelativeVirtualFile(uri, project);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        return TuplesKt.to((Object)virtualFile2, (Object)$this$toRange.getRegion());
    }

    /*
     * WARNING - void declaration
     */
    public static final void filterOutAbsentResults(@NotNull SarifReport $this$filterOutAbsentResults) {
        Intrinsics.checkNotNullParameter((Object)$this$filterOutAbsentResults, (String)"$this$filterOutAbsentResults");
        List list = $this$filterOutAbsentResults.getRuns();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"this.runs");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Run run;
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Run it = (Run)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            List list2 = it.getResults();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"it.results");
            Iterable iterable = list2;
            boolean $i$f$filter = false;
            void var10_10 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Result result = (Result)element$iv$iv;
                boolean bl2 = false;
                Result result2 = result;
                Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"result");
                if (!(result2.getBaselineState() != Result.BaselineState.ABSENT)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list3 = (List)destination$iv$iv;
            run.setResults(list3);
        }
    }
}

