/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.JavaCoverageOptionsProvider;
import com.intellij.coverage.PackageAnnotator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.rt.coverage.instrumentation.SourceLineCounter;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.coverage.gnu.trove.TIntObjectHashMap;
import org.jetbrains.coverage.org.objectweb.asm.ClassReader;
import org.jetbrains.coverage.org.objectweb.asm.ClassVisitor;

public final class SourceLineCounterUtil {
    public static boolean collectNonCoveredClassInfo(PackageAnnotator.ClassCoverageInfo classCoverageInfo, byte[] content, boolean excludeLines, boolean ignoreEmptyPrivateConstructors, boolean ignoreGeneratedDefaultConstructor, PsiClass psiClass) {
        if (content == null) {
            return false;
        }
        ClassReader reader = new ClassReader(content, 0, content.length);
        SourceLineCounter counter = new SourceLineCounter(null, excludeLines, null, ignoreEmptyPrivateConstructors);
        reader.accept((ClassVisitor)counter, 4);
        HashSet descriptions = new HashSet();
        TIntObjectHashMap lines = counter.getSourceLines();
        Ref isDefaultConstructorGenerated = new Ref();
        lines.forEachEntry((line, description) -> {
            if (isDefaultConstructorGenerated.isNull() && ignoreGeneratedDefaultConstructor && PackageAnnotator.isDefaultConstructor(description)) {
                isDefaultConstructorGenerated.set((Object)PackageAnnotator.isGeneratedDefaultConstructor(psiClass, description));
            }
            if (!isDefaultConstructorGenerated.isNull() && ((Boolean)isDefaultConstructorGenerated.get()).booleanValue() && PackageAnnotator.isDefaultConstructor(description)) {
                return true;
            }
            ++classCoverageInfo.totalLineCount;
            descriptions.add(description);
            return true;
        });
        classCoverageInfo.totalMethodCount += descriptions.size();
        classCoverageInfo.totalBranchCount += counter.getTotalBranches();
        if (!counter.isInterface()) {
            classCoverageInfo.totalClassCount = 1;
        }
        return !counter.isInterface();
    }

    public static void collectSrcLinesForUntouchedFiles(List<? super Integer> uncoveredLines, byte[] content, boolean excludeLines, Project project) {
        ClassReader reader = new ClassReader(content);
        SourceLineCounter collector = new SourceLineCounter(null, excludeLines, null, JavaCoverageOptionsProvider.getInstance(project).ignoreEmptyPrivateConstructors());
        reader.accept((ClassVisitor)collector, 0);
        String qualifiedName = reader.getClassName();
        Condition includeDescriptionCondition = description -> !JavaCoverageOptionsProvider.getInstance(project).isGeneratedConstructor(qualifiedName, (String)description);
        TIntObjectHashMap lines = collector.getSourceLines();
        lines.forEachEntry((line, description) -> {
            if (includeDescriptionCondition.value(description)) {
                uncoveredLines.add(--line);
            }
            return true;
        });
    }
}

