/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.ui;

import com.intellij.DynamicBundle;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.data.BuildParticipant;
import org.jetbrains.plugins.gradle.settings.CompositeDefinitionSource;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleProjectCompositeSelectorDialog
extends DialogWrapper {
    private static final int MAX_PATH_LENGTH = 40;
    @NotNull
    private final Project myProject;
    @Nullable
    private final GradleProjectSettings myCompositeRootSettings;
    private JPanel mainPanel;
    private JPanel contentPanel;
    private JBLabel myDescriptionLbl;
    private final ExternalSystemUiAware myExternalSystemUiAware;
    private final CheckboxTree myTree;

    public GradleProjectCompositeSelectorDialog(@NotNull Project project, String compositeRootProjectPath) {
        if (project == null) {
            GradleProjectCompositeSelectorDialog.$$$reportNull$$$0(0);
        }
        super(project, true);
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myCompositeRootSettings = (GradleProjectSettings)GradleSettings.getInstance(this.myProject).getLinkedProjectSettings(compositeRootProjectPath);
        this.myExternalSystemUiAware = ExternalSystemUiUtil.getUiAware((ProjectSystemId)GradleConstants.SYSTEM_ID);
        this.myTree = this.createTree();
        this.setTitle(GradleBundle.message("gradle.settings.composite.build.title", new Object[0]));
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTree)this.myTree).addExtraAction((AnActionButton)new SelectAllButton()).addExtraAction((AnActionButton)new UnselectAllButton()).setToolbarPosition(ActionToolbarPosition.BOTTOM);
        this.contentPanel.add(decorator.createPanel());
        return this.mainPanel;
    }

    protected void doOKAction() {
        if (this.myCompositeRootSettings != null) {
            Pair[] compositeParticipants = (Pair[])this.myTree.getCheckedNodes(Pair.class, null);
            if (compositeParticipants.length == 0) {
                this.myCompositeRootSettings.setCompositeBuild(null);
            } else {
                GradleProjectSettings.CompositeBuild compositeBuild = new GradleProjectSettings.CompositeBuild();
                compositeBuild.setCompositeDefinitionSource(CompositeDefinitionSource.IDE);
                for (Pair participant : compositeParticipants) {
                    BuildParticipant buildParticipant = new BuildParticipant();
                    buildParticipant.setRootProjectName(participant.first.toString());
                    buildParticipant.setRootPath(participant.second.toString());
                    compositeBuild.getCompositeParticipants().add(buildParticipant);
                }
                this.myCompositeRootSettings.setCompositeBuild(compositeBuild);
            }
        }
        super.doOKAction();
    }

    public void doCancelAction() {
        super.doCancelAction();
    }

    public void dispose() {
        super.dispose();
    }

    private CheckboxTree createTree() {
        CheckedTreeNode root = new CheckedTreeNode();
        if (this.myCompositeRootSettings != null) {
            ArrayList<CheckedTreeNode> nodes = new ArrayList<CheckedTreeNode>();
            for (GradleProjectSettings projectSettings : GradleSettings.getInstance(this.myProject).getLinkedProjectsSettings()) {
                if (projectSettings == this.myCompositeRootSettings || projectSettings.getCompositeBuild() != null && projectSettings.getCompositeBuild().getCompositeDefinitionSource() == CompositeDefinitionSource.SCRIPT) continue;
                GradleProjectSettings.CompositeBuild compositeBuild = this.myCompositeRootSettings.getCompositeBuild();
                boolean added = compositeBuild != null && compositeBuild.getCompositeParticipants().stream().anyMatch(participant -> FileUtil.pathsEqual((String)participant.getRootPath(), (String)projectSettings.getExternalProjectPath()));
                String representationName = this.myExternalSystemUiAware.getProjectRepresentationName(projectSettings.getExternalProjectPath(), projectSettings.getExternalProjectPath());
                CheckedTreeNode treeNode = new CheckedTreeNode((Object)Pair.create((Object)representationName, (Object)projectSettings.getExternalProjectPath()));
                treeNode.setChecked(added);
                nodes.add(treeNode);
            }
            ContainerUtil.sort(nodes, (o1, o2) -> StringUtil.naturalCompare((String)((String)((Pair)o1.getUserObject()).first), (String)((String)((Pair)o2.getUserObject()).first)));
            TreeUtil.addChildrenTo((MutableTreeNode)root, nodes);
        }
        CheckboxTree tree = new CheckboxTree(new CheckboxTree.CheckboxTreeCellRenderer(true, false){

            public void customizeRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (!(value instanceof CheckedTreeNode)) {
                    return;
                }
                CheckedTreeNode node = (CheckedTreeNode)value;
                if (!(node.getUserObject() instanceof Pair)) {
                    return;
                }
                Pair pair = (Pair)node.getUserObject();
                ColoredTreeCellRenderer renderer = this.getTextRenderer();
                renderer.setIcon(GradleProjectCompositeSelectorDialog.this.myExternalSystemUiAware.getProjectIcon());
                String projectName = (String)pair.first;
                renderer.append(projectName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                String projectPath = StringUtil.trimMiddle((String)((String)pair.second), (int)40);
                renderer.append(" (" + projectPath + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
                this.setToolTipText((String)pair.second);
            }
        }, root);
        TreeUtil.expand((JTree)tree, (int)1);
        return tree;
    }

    private void walkTree(Consumer<? super CheckedTreeNode> consumer) {
        TreeModel treeModel = this.myTree.getModel();
        Object root = treeModel.getRoot();
        if (!(root instanceof CheckedTreeNode)) {
            return;
        }
        for (TreeNode node : TreeUtil.listChildren((TreeNode)((CheckedTreeNode)root))) {
            if (!(node instanceof CheckedTreeNode)) continue;
            consumer.consume((Object)((CheckedTreeNode)node));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/ui/GradleProjectCompositeSelectorDialog", "<init>"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JPanel jPanel;
        JPanel jPanel2;
        this.mainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(5, 5));
        ((Component)jPanel2).setEnabled(true);
        jPanel2.setMinimumSize(new Dimension(300, 100));
        jPanel2.setOpaque(false);
        jPanel2.setPreferredSize(new Dimension(400, 300));
        this.contentPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.setAutoscrolls(true);
        jPanel.setMinimumSize(new Dimension(0, 0));
        jPanel.setPreferredSize(new Dimension(0, 0));
        jPanel2.add((Component)jPanel, "Center");
        this.myDescriptionLbl = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/GradleBundle", GradleProjectCompositeSelectorDialog.class).getString("gradle.settings.composite.selector.description"));
        jPanel2.add((Component)jBLabel, "North");
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string2.length(); ++j) {
            if (string2.charAt(j) == '&') {
                if (++j == string2.length()) break;
                if (!bl && string2.charAt(j) != '&') {
                    bl = true;
                    c = string2.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string2.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private class UnselectAllButton
    extends AnActionButton {
        UnselectAllButton() {
            super(GradleBundle.messagePointer("gradle.settings.composite.unselect.all", new Object[0]), AllIcons.Actions.Unselectall);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                UnselectAllButton.$$$reportNull$$$0(0);
            }
            GradleProjectCompositeSelectorDialog.this.walkTree((Consumer<? super CheckedTreeNode>)((Consumer)node -> node.setChecked(false)));
            ((DefaultTreeModel)GradleProjectCompositeSelectorDialog.this.myTree.getModel()).reload();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/gradle/ui/GradleProjectCompositeSelectorDialog$UnselectAllButton", "actionPerformed"));
        }
    }

    private class SelectAllButton
    extends AnActionButton {
        SelectAllButton() {
            super(GradleBundle.messagePointer("gradle.settings.composite.select.all", new Object[0]), AllIcons.Actions.Selectall);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                SelectAllButton.$$$reportNull$$$0(0);
            }
            GradleProjectCompositeSelectorDialog.this.walkTree((Consumer<? super CheckedTreeNode>)((Consumer)node -> node.setChecked(true)));
            ((DefaultTreeModel)GradleProjectCompositeSelectorDialog.this.myTree.getModel()).reload();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/gradle/ui/GradleProjectCompositeSelectorDialog$SelectAllButton", "actionPerformed"));
        }
    }
}

