/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.open;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.importing.AbstractOpenProjectProvider;
import com.intellij.openapi.externalSystem.importing.ImportSpecBuilder;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.internal.InternalExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectRefreshCallback;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.service.ui.ExternalProjectDataSelectorDialog;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.project.open.GradleProjectImportUtil;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleJvmResolutionUtil;
import org.jetbrains.plugins.gradle.util.GradleJvmValidationUtil;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001e\u0010\u0013\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\u0018\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\r\u001a\u00020\u000eH\u0014J&\u0010\u001e\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002R\u001e\u0010\u0003\u001a\f0\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\u0002\b\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/plugins/gradle/service/project/open/GradleOpenProjectProvider;", "Lcom/intellij/openapi/externalSystem/importing/AbstractOpenProjectProvider;", "()V", "systemId", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/NonNls;", "getSystemId", "()Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "attachGradleProjectAndRefresh", "", "settings", "Lcom/intellij/openapi/externalSystem/settings/ExternalProjectSettings;", "project", "Lcom/intellij/openapi/project/Project;", "createFinalImportCallback", "Lcom/intellij/openapi/externalSystem/service/project/ExternalProjectRefreshCallback;", "externalProjectPath", "", "importData", "externalProject", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "isProjectFile", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "linkAndRefreshProject", "projectDirectory", "Ljava/nio/file/Path;", "selectDataToImport", "intellij.gradle.common"})
public final class GradleOpenProjectProvider
extends AbstractOpenProjectProvider {
    @NotNull
    private final ProjectSystemId systemId;

    @NotNull
    protected ProjectSystemId getSystemId() {
        return this.systemId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isProjectFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (file.isDirectory()) return false;
        Intrinsics.checkNotNullExpressionValue((Object)GradleConstants.BUILD_FILE_EXTENSIONS, (String)"BUILD_FILE_EXTENSIONS");
        String[] $this$any$iv = GradleConstants.BUILD_FILE_EXTENSIONS;
        boolean $i$f$any = false;
        String[] stringArray = $this$any$iv;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String element$iv;
            String it = element$iv = stringArray[n2];
            boolean bl = false;
            String string2 = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.name");
            String string3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it");
            if (StringsKt.endsWith$default((String)string2, (String)string3, (boolean)false, (int)2, null)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void linkAndRefreshProject(@NotNull Path projectDirectory, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)projectDirectory, (String)"projectDirectory");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        GradleProjectSettings gradleProjectSettings = GradleProjectImportUtil.createLinkSettings(projectDirectory, project);
        this.attachGradleProjectAndRefresh(gradleProjectSettings, project);
        GradleVersion gradleVersion2 = gradleProjectSettings.resolveGradleVersion();
        Intrinsics.checkNotNullExpressionValue((Object)gradleVersion2, (String)"gradleProjectSettings.resolveGradleVersion()");
        GradleJvmValidationUtil.validateJavaHome(project, projectDirectory, gradleVersion2);
    }

    private final void attachGradleProjectAndRefresh(ExternalProjectSettings settings2, Project project) {
        String externalProjectPath = settings2.getExternalProjectPath();
        ExternalSystemApiUtil.getSettings((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID).linkProject(settings2);
        if (Registry.is((String)"external.system.auto.import.disabled")) {
            return;
        }
        ExternalSystemUtil.refreshProject((String)externalProjectPath, (ImportSpecBuilder)new ImportSpecBuilder(project, GradleConstants.SYSTEM_ID).usePreviewMode().use(ProgressExecutionMode.MODAL_SYNC));
        ExternalProjectsManagerImpl.getInstance((Project)project).runWhenInitialized(new Runnable(this, project, externalProjectPath){
            final /* synthetic */ GradleOpenProjectProvider this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ String $externalProjectPath;

            public final void run() {
                ExternalSystemUtil.ensureToolWindowInitialized((Project)this.$project, (ProjectSystemId)GradleConstants.SYSTEM_ID);
                ImportSpecBuilder importSpecBuilder = new ImportSpecBuilder(this.$project, GradleConstants.SYSTEM_ID);
                String string2 = this.$externalProjectPath;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"externalProjectPath");
                ExternalSystemUtil.refreshProject((String)this.$externalProjectPath, (ImportSpecBuilder)importSpecBuilder.callback(GradleOpenProjectProvider.access$createFinalImportCallback(this.this$0, this.$project, string2)));
            }
            {
                this.this$0 = gradleOpenProjectProvider;
                this.$project = project;
                this.$externalProjectPath = string2;
            }
        });
    }

    private final ExternalProjectRefreshCallback createFinalImportCallback(Project project, String externalProjectPath) {
        return new ExternalProjectRefreshCallback(this, project, externalProjectPath){
            final /* synthetic */ GradleOpenProjectProvider this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ String $externalProjectPath;

            public void onSuccess(@Nullable DataNode<ProjectData> externalProject) {
                if (externalProject == null) {
                    return;
                }
                GradleOpenProjectProvider.access$selectDataToImport(this.this$0, this.$project, this.$externalProjectPath, externalProject);
                GradleOpenProjectProvider.access$importData(this.this$0, this.$project, externalProject);
                GradleJvmResolutionUtil.updateGradleJvm(this.$project, this.$externalProjectPath);
            }
            {
                this.this$0 = this$0;
                this.$project = $captured_local_variable$1;
                this.$externalProjectPath = $captured_local_variable$2;
            }
        };
    }

    private final void selectDataToImport(Project project, String externalProjectPath, DataNode<ProjectData> externalProject) {
        GradleSettings gradleSettings = GradleSettings.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gradleSettings), (String)"GradleSettings.getInstance(project)");
        GradleSettings settings2 = gradleSettings;
        boolean showSelectiveImportDialog = settings2.showSelectiveImportDialogOnInitialImport();
        Application application = ApplicationManager.getApplication();
        if (showSelectiveImportDialog) {
            Application application2 = application;
            Intrinsics.checkNotNullExpressionValue((Object)application2, (String)"application");
            if (!application2.isHeadlessEnvironment()) {
                application.invokeAndWait(new Runnable(externalProjectPath, externalProject, project){
                    final /* synthetic */ String $externalProjectPath;
                    final /* synthetic */ DataNode $externalProject;
                    final /* synthetic */ Project $project;

                    public final void run() {
                        InternalExternalProjectInfo projectInfo = new InternalExternalProjectInfo(GradleConstants.SYSTEM_ID, this.$externalProjectPath, this.$externalProject);
                        ExternalProjectDataSelectorDialog dialog = new ExternalProjectDataSelectorDialog(this.$project, (ExternalProjectInfo)projectInfo);
                        if (dialog.hasMultipleDataToSelect()) {
                            dialog.showAndGet();
                        } else {
                            Disposer.dispose((Disposable)dialog.getDisposable());
                        }
                    }
                    {
                        this.$externalProjectPath = string2;
                        this.$externalProject = dataNode;
                        this.$project = project;
                    }
                });
            }
        }
    }

    private final void importData(Project project, DataNode<ProjectData> externalProject) {
        ProjectDataManager.getInstance().importData(externalProject, project, false);
    }

    public GradleOpenProjectProvider() {
        ProjectSystemId projectSystemId = GradleConstants.SYSTEM_ID;
        Intrinsics.checkNotNullExpressionValue((Object)projectSystemId, (String)"SYSTEM_ID");
        this.systemId = projectSystemId;
    }

    public static final /* synthetic */ ExternalProjectRefreshCallback access$createFinalImportCallback(GradleOpenProjectProvider $this, Project project, String externalProjectPath) {
        return $this.createFinalImportCallback(project, externalProjectPath);
    }

    public static final /* synthetic */ void access$selectDataToImport(GradleOpenProjectProvider $this, Project project, String externalProjectPath, DataNode externalProject) {
        $this.selectDataToImport(project, externalProjectPath, (DataNode<ProjectData>)externalProject);
    }

    public static final /* synthetic */ void access$importData(GradleOpenProjectProvider $this, Project project, DataNode externalProject) {
        $this.importData(project, (DataNode<ProjectData>)externalProject);
    }
}

