/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.scopes.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirCallableMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.scopes.FirOverrideChecker;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J\u001c\u0010\u0015\u001a\u00020\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00162\u0006\u0010\u0014\u001a\u00020\u0017H\u0002J \u0010\u0018\u001a\u00020\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00162\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0004J(\u0010\u0019\u001a\b\u0012\u0002\b\u0003\u0018\u00010\t*\u0006\u0012\u0002\b\u00030\t2\u0010\u0010\u001a\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u001bH\u0014R'\u0010\u0007\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/fir/scopes/impl/AbstractFirOverrideScope;", "Lorg/jetbrains/kotlin/fir/scopes/FirTypeScope;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "overrideChecker", "Lorg/jetbrains/kotlin/fir/scopes/FirOverrideChecker;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/scopes/FirOverrideChecker;)V", "overrideByBase", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "getOverrideByBase", "()Ljava/util/Map;", "getOverrideChecker", "()Lorg/jetbrains/kotlin/fir/scopes/FirOverrideChecker;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "isOverriddenFunction", "", "overrideCandidate", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "baseDeclaration", "isOverriddenProperty", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableMemberDeclaration;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "similarFunctionsOrBothProperties", "getOverridden", "overrideCandidates", "", "resolve"})
public abstract class AbstractFirOverrideScope
extends FirTypeScope {
    @NotNull
    private final FirSession session;
    @NotNull
    private final FirOverrideChecker overrideChecker;
    @NotNull
    private final Map<FirCallableSymbol<?>, FirCallableSymbol<?>> overrideByBase;

    public AbstractFirOverrideScope(@NotNull FirSession session, @NotNull FirOverrideChecker overrideChecker) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)overrideChecker, (String)"overrideChecker");
        this.session = session;
        this.overrideChecker = overrideChecker;
        boolean bl = false;
        this.overrideByBase = new LinkedHashMap();
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @NotNull
    protected final FirOverrideChecker getOverrideChecker() {
        return this.overrideChecker;
    }

    @NotNull
    public final Map<FirCallableSymbol<?>, FirCallableSymbol<?>> getOverrideByBase() {
        return this.overrideByBase;
    }

    private final boolean isOverriddenFunction(FirSimpleFunction overrideCandidate, FirSimpleFunction baseDeclaration) {
        return this.overrideChecker.isOverriddenFunction(overrideCandidate, baseDeclaration);
    }

    private final boolean isOverriddenProperty(FirCallableMemberDeclaration<?> overrideCandidate, FirProperty baseDeclaration) {
        return this.overrideChecker.isOverriddenProperty(overrideCandidate, baseDeclaration);
    }

    protected final boolean similarFunctionsOrBothProperties(@NotNull FirCallableMemberDeclaration<?> overrideCandidate, @NotNull FirCallableMemberDeclaration<?> baseDeclaration) {
        boolean bl;
        Intrinsics.checkNotNullParameter(overrideCandidate, (String)"overrideCandidate");
        Intrinsics.checkNotNullParameter(baseDeclaration, (String)"baseDeclaration");
        FirCallableMemberDeclaration<?> firCallableMemberDeclaration = overrideCandidate;
        if (firCallableMemberDeclaration instanceof FirSimpleFunction) {
            FirCallableMemberDeclaration<?> firCallableMemberDeclaration2 = baseDeclaration;
            bl = firCallableMemberDeclaration2 instanceof FirSimpleFunction ? this.isOverriddenFunction((FirSimpleFunction)overrideCandidate, (FirSimpleFunction)baseDeclaration) : (firCallableMemberDeclaration2 instanceof FirProperty ? this.isOverriddenProperty(overrideCandidate, (FirProperty)baseDeclaration) : false);
        } else if (firCallableMemberDeclaration instanceof FirConstructor) {
            bl = false;
        } else if (firCallableMemberDeclaration instanceof FirProperty) {
            bl = baseDeclaration instanceof FirProperty && this.isOverriddenProperty(overrideCandidate, (FirProperty)baseDeclaration);
        } else if (firCallableMemberDeclaration instanceof FirField) {
            bl = baseDeclaration instanceof FirField;
        } else {
            String string2 = "Unknown fir callable type: " + overrideCandidate + ", " + baseDeclaration;
            boolean bl2 = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return bl;
    }

    @Nullable
    protected FirCallableSymbol<?> getOverridden(@NotNull FirCallableSymbol<?> $this$getOverridden, @NotNull Set<? extends FirCallableSymbol<?>> overrideCandidates) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter($this$getOverridden, (String)"<this>");
            Intrinsics.checkNotNullParameter(overrideCandidates, (String)"overrideCandidates");
            if (this.overrideByBase.containsKey($this$getOverridden)) {
                return this.overrideByBase.get($this$getOverridden);
            }
            FirCallableMemberDeclaration baseDeclaration = (FirCallableMemberDeclaration)$this$getOverridden.getFir();
            Iterable $this$firstOrNull$iv = overrideCandidates;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FirCallableSymbol it = (FirCallableSymbol)element$iv;
                boolean bl = false;
                FirCallableMemberDeclaration overrideCandidate = (FirCallableMemberDeclaration)it.getFir();
                FirMemberDeclaration $this$modality$iv = baseDeclaration;
                boolean $i$f$getModality = false;
                if (!($this$modality$iv.getStatus().getModality() != Modality.FINAL && this.similarFunctionsOrBothProperties(overrideCandidate, baseDeclaration))) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        FirCallableSymbol override = v0;
        Map<FirCallableSymbol<?>, FirCallableSymbol<?>> map = this.overrideByBase;
        boolean bl = false;
        map.put($this$getOverridden, override);
        return override;
    }
}

