/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend.generators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.fir.backend.ConversionUtilsKt;
import org.jetbrains.kotlin.fir.backend.Fir2IrComponents;
import org.jetbrains.kotlin.fir.backend.Fir2IrSignatureComposer;
import org.jetbrains.kotlin.fir.backend.Fir2IrTypeConverterKt;
import org.jetbrains.kotlin.fir.backend.FirMetadataSource;
import org.jetbrains.kotlin.fir.backend.generators.DataClassMembersGenerator;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.builder.FirSimpleFunctionBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirValueParameterBuilder;
import org.jetbrains.kotlin.fir.declarations.impl.FirDeclarationStatusImpl;
import org.jetbrains.kotlin.fir.scopes.KotlinScopeProviderKt;
import org.jetbrains.kotlin.fir.symbols.CallableId;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.ConeClassifierLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitBooleanTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitIntTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitNullableAnyTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitStringTypeRef;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.ir.builders.IrGeneratorContextBase;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrValueParameterSymbolImpl;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.DataClassMembersGenerator;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00162\u00020\u0001:\u0002\u0016\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ \u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0013\u001a\u00020\u0014J \u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0013\u001a\u00020\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/fir/backend/generators/DataClassMembersGenerator;", "", "components", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "(Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;)V", "getComponents", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "generateDataClassComponentBody", "", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "lookupTag", "Lorg/jetbrains/kotlin/fir/symbols/ConeClassLikeLookupTag;", "generateDataClassCopyBody", "generateDataClassMembers", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "klass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "generateInlineClassMembers", "Companion", "MyDataClassMethodsGenerator", "fir2ir"})
public final class DataClassMembersGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Fir2IrComponents components;
    @NotNull
    private static final Name copyName;
    @NotNull
    private static final Name equalsName;
    @NotNull
    private static final Name hashCodeName;
    @NotNull
    private static final Name toStringName;

    public DataClassMembersGenerator(@NotNull Fir2IrComponents components2) {
        Intrinsics.checkNotNullParameter((Object)components2, (String)"components");
        this.components = components2;
    }

    @NotNull
    public final Fir2IrComponents getComponents() {
        return this.components;
    }

    @NotNull
    public final List<FirDeclaration> generateInlineClassMembers(@NotNull FirClass<?> klass, @NotNull IrClass irClass2) {
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        return new MyDataClassMethodsGenerator(irClass2, klass.getSymbol().toLookupTag(), IrDeclarationOrigin.GENERATED_INLINE_CLASS_MEMBER.INSTANCE).generate(klass);
    }

    @NotNull
    public final List<FirDeclaration> generateDataClassMembers(@NotNull FirClass<?> klass, @NotNull IrClass irClass2) {
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        return new MyDataClassMethodsGenerator(irClass2, klass.getSymbol().toLookupTag(), IrDeclarationOrigin.GENERATED_DATA_CLASS_MEMBER.INSTANCE).generate(klass);
    }

    public final void generateDataClassComponentBody(@NotNull IrFunction irFunction2, @NotNull ConeClassLikeLookupTag lookupTag) {
        Intrinsics.checkNotNullParameter((Object)irFunction2, (String)"irFunction");
        Intrinsics.checkNotNullParameter((Object)lookupTag, (String)"lookupTag");
        new MyDataClassMethodsGenerator(IrUtilsKt.getParentAsClass(irFunction2), lookupTag, IrDeclarationOrigin.GENERATED_DATA_CLASS_MEMBER.INSTANCE).generateComponentBody(irFunction2);
    }

    public final void generateDataClassCopyBody(@NotNull IrFunction irFunction2, @NotNull ConeClassLikeLookupTag lookupTag) {
        Intrinsics.checkNotNullParameter((Object)irFunction2, (String)"irFunction");
        Intrinsics.checkNotNullParameter((Object)lookupTag, (String)"lookupTag");
        new MyDataClassMethodsGenerator(IrUtilsKt.getParentAsClass(irFunction2), lookupTag, IrDeclarationOrigin.GENERATED_DATA_CLASS_MEMBER.INSTANCE).generateCopyBody(irFunction2);
    }

    static {
        Name name = Name.identifier("copy");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(\"copy\")");
        copyName = name;
        name = Name.identifier("equals");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(\"equals\")");
        equalsName = name;
        name = Name.identifier("hashCode");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(\"hashCode\")");
        hashCodeName = name;
        name = Name.identifier("toString");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(\"toString\")");
        toStringName = name;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000k\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003*\u0001\f\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\"\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\b\b\u0002\u0010#\u001a\u00020\u0013H\u0002J*\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010'\u001a\u00020\"2\b\b\u0002\u0010(\u001a\u00020)H\u0002J\u0018\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+2\n\u0010-\u001a\u0006\u0012\u0002\b\u00030.J\u000e\u0010/\u001a\u0002002\u0006\u0010&\u001a\u00020\u001eJ\u000e\u00101\u001a\u0002002\u0006\u0010&\u001a\u00020\u001eJ\u000e\u00102\u001a\u00020%2\u0006\u0010&\u001a\u00020\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0012\u001a\u00020\u0013*\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0018\u0010\u0017\u001a\u00020\u0013*\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016R\u0018\u0010\u0019\u001a\u00020\u0013*\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0016R\u0018\u0010\u001b\u001a\u00020\u0013*\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0016\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/fir/backend/generators/DataClassMembersGenerator$MyDataClassMethodsGenerator;", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "lookupTag", "Lorg/jetbrains/kotlin/fir/symbols/ConeClassLikeLookupTag;", "origin", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;", "(Lorg/jetbrains/kotlin/fir/backend/generators/DataClassMembersGenerator;Lorg/jetbrains/kotlin/ir/declarations/IrClass;Lorg/jetbrains/kotlin/fir/symbols/ConeClassLikeLookupTag;Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;)V", "getIrClass", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "irDataClassMembersGenerator", "org/jetbrains/kotlin/fir/backend/generators/DataClassMembersGenerator$MyDataClassMethodsGenerator$irDataClassMembersGenerator$1", "Lorg/jetbrains/kotlin/fir/backend/generators/DataClassMembersGenerator$MyDataClassMethodsGenerator$irDataClassMembersGenerator$1;", "getLookupTag", "()Lorg/jetbrains/kotlin/fir/symbols/ConeClassLikeLookupTag;", "getOrigin", "()Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;", "matchesDataClassSyntheticMemberSignatures", "", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "getMatchesDataClassSyntheticMemberSignatures", "(Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;)Z", "matchesEqualsSignature", "getMatchesEqualsSignature", "matchesHashCodeSignature", "getMatchesHashCodeSignature", "matchesToStringSignature", "getMatchesToStringSignature", "createSyntheticIrFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "name", "Lorg/jetbrains/kotlin/name/Name;", "returnType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "otherParameterNeeded", "createSyntheticIrParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "irFunction", "type", "index", "", "generate", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "klass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "generateComponentBody", "", "generateCopyBody", "generateDispatchReceiverParameter", "fir2ir"})
    private final class MyDataClassMethodsGenerator {
        @NotNull
        private final IrClass irClass;
        @NotNull
        private final ConeClassLikeLookupTag lookupTag;
        @NotNull
        private final IrDeclarationOrigin origin;
        @NotNull
        private final irDataClassMembersGenerator.1 irDataClassMembersGenerator;

        public MyDataClassMethodsGenerator(@NotNull IrClass irClass2, @NotNull ConeClassLikeLookupTag lookupTag, IrDeclarationOrigin origin) {
            Intrinsics.checkNotNullParameter((Object)DataClassMembersGenerator.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
            Intrinsics.checkNotNullParameter((Object)lookupTag, (String)"lookupTag");
            Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
            this.irClass = irClass2;
            this.lookupTag = lookupTag;
            this.origin = origin;
            IrGeneratorContextBase irGeneratorContextBase = new IrGeneratorContextBase(DataClassMembersGenerator.this.getComponents().getIrBuiltIns());
            SymbolTable symbolTable = DataClassMembersGenerator.this.getComponents().getSymbolTable();
            IrClass irClass3 = this.irClass;
            IrDeclarationOrigin irDeclarationOrigin = this.origin;
            this.irDataClassMembersGenerator = new org.jetbrains.kotlin.ir.util.DataClassMembersGenerator(DataClassMembersGenerator.this, irGeneratorContextBase, symbolTable, irClass3, irDeclarationOrigin){
                final /* synthetic */ DataClassMembersGenerator this$0;
                {
                    this.this$0 = $receiver;
                    super($super_call_param$1, $super_call_param$2, $super_call_param$3, $super_call_param$4);
                }

                @NotNull
                public IrFunction declareSimpleFunction(int startOffset, int endOffset, @NotNull FunctionDescriptor functionDescriptor) {
                    Intrinsics.checkNotNullParameter((Object)functionDescriptor, (String)"functionDescriptor");
                    throw new IllegalStateException("Not expect to see function declaration.");
                }

                public void generateSyntheticFunctionParameterDeclarations(@NotNull IrFunction irFunction2) {
                    Intrinsics.checkNotNullParameter((Object)irFunction2, (String)"irFunction");
                }

                @Nullable
                public IrProperty getProperty(@Nullable ValueParameterDescriptor parameter, @Nullable IrValueParameter irValueParameter) {
                    IrProperty irProperty2;
                    IrValueParameter irValueParameter2 = irValueParameter;
                    if (irValueParameter2 == null) {
                        irProperty2 = null;
                    } else {
                        IrValueParameter irValueParameter3 = irValueParameter2;
                        boolean bl = false;
                        boolean bl2 = false;
                        IrValueParameter it = irValueParameter3;
                        boolean bl3 = false;
                        Sequence<IrProperty> $this$single$iv = IrUtilsKt.getProperties(this.getIrClass());
                        boolean $i$f$single = false;
                        Object single$iv = null;
                        boolean found$iv = false;
                        for (E element$iv : $this$single$iv) {
                            IrField irField;
                            IrProperty irProperty3 = (IrProperty)element$iv;
                            boolean bl4 = false;
                            if (!(Intrinsics.areEqual((Object)irProperty3.getName(), (Object)irValueParameter.getName()) && Intrinsics.areEqual((Object)((irField = irProperty3.getBackingField()) == null ? null : irField.getType()), (Object)irValueParameter.getType()))) continue;
                            if (found$iv) {
                                throw (Throwable)new IllegalArgumentException("Sequence contains more than one matching element.");
                            }
                            single$iv = element$iv;
                            found$iv = true;
                        }
                        if (!found$iv) {
                            throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
                        }
                        irProperty2 = single$iv;
                    }
                    return irProperty2;
                }

                @NotNull
                public IrType transform(@NotNull TypeParameterDescriptor typeParameterDescriptor) {
                    Intrinsics.checkNotNullParameter((Object)typeParameterDescriptor, (String)"typeParameterDescriptor");
                    return this.this$0.getComponents().getIrBuiltIns().getAnyType();
                }

                private final IrSimpleFunctionSymbol getHashCodeFunction(IrClass klass) {
                    IrSimpleFunctionSymbol irSimpleFunctionSymbol;
                    IrSimpleFunctionSymbol irSimpleFunctionSymbol2;
                    Object v0;
                    block7: {
                        Sequence<IrSimpleFunction> $this$singleOrNull$iv = IrUtilsKt.getFunctions(klass);
                        boolean $i$f$singleOrNull = false;
                        Object single$iv = null;
                        boolean found$iv = false;
                        for (E element$iv : $this$singleOrNull$iv) {
                            IrSimpleFunction it = (IrSimpleFunction)element$iv;
                            boolean bl = false;
                            if (!(Intrinsics.areEqual((Object)it.getName().asString(), (Object)"hashCode") && it.getValueParameters().isEmpty() && it.getExtensionReceiverParameter() == null)) continue;
                            if (found$iv) {
                                v0 = null;
                                break block7;
                            }
                            single$iv = element$iv;
                            found$iv = true;
                        }
                        v0 = !found$iv ? null : single$iv;
                    }
                    IrSimpleFunction irSimpleFunction = v0;
                    IrSimpleFunctionSymbol irSimpleFunctionSymbol3 = irSimpleFunctionSymbol2 = irSimpleFunction == null ? null : irSimpleFunction.getSymbol();
                    if (irSimpleFunctionSymbol2 == null) {
                        Sequence<IrSimpleFunctionSymbol> $this$single$iv = IrUtilsKt.getFunctions(this.getContext().getIrBuiltIns().getAnyClass());
                        boolean $i$f$single = false;
                        Object single$iv = null;
                        boolean found$iv = false;
                        for (E element$iv : $this$single$iv) {
                            IrSimpleFunctionSymbol it = (IrSimpleFunctionSymbol)element$iv;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)((IrSimpleFunction)it.getOwner()).getName().asString(), (Object)"hashCode")) continue;
                            if (found$iv) {
                                throw (Throwable)new IllegalArgumentException("Sequence contains more than one matching element.");
                            }
                            single$iv = element$iv;
                            found$iv = true;
                        }
                        if (!found$iv) {
                            throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
                        }
                        irSimpleFunctionSymbol = single$iv;
                    } else {
                        irSimpleFunctionSymbol = irSimpleFunctionSymbol2;
                    }
                    return irSimpleFunctionSymbol;
                }

                @NotNull
                public final IrClass getErasedUpperBound(@NotNull IrTypeParameter $this$erasedUpperBound) {
                    IrClass irClass2;
                    IrSymbolOwner firstSuper;
                    Intrinsics.checkNotNullParameter((Object)$this$erasedUpperBound, (String)"<this>");
                    for (IrType type2 : $this$erasedUpperBound.getSuperTypes()) {
                        IrClass irClass3;
                        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(type2);
                        IrClass irClass4 = irClassSymbol == null ? null : (IrClass)irClassSymbol.getOwner();
                        if (irClass4 == null || IrUtilsKt.isInterface(irClass3 = irClass4) || IrUtilsKt.isAnnotationClass(irClass3)) continue;
                        return irClass3;
                    }
                    Object object = IrTypesKt.getClassifierOrNull((IrType)CollectionsKt.first($this$erasedUpperBound.getSuperTypes()));
                    IrSymbolOwner irSymbolOwner = firstSuper = object == null ? null : object.getOwner();
                    if (firstSuper instanceof IrClass) {
                        irClass2 = (IrClass)firstSuper;
                    } else if (firstSuper instanceof IrTypeParameter) {
                        irClass2 = this.getErasedUpperBound((IrTypeParameter)firstSuper);
                    } else {
                        object = Intrinsics.stringPlus((String)"unknown supertype kind ", (Object)firstSuper);
                        boolean bl = false;
                        throw (Throwable)new IllegalStateException(object.toString());
                    }
                    return irClass2;
                }

                @NotNull
                public DataClassMembersGenerator.HashCodeFunctionInfo getHashCodeFunctionInfo(@NotNull IrType type2) {
                    IrSimpleFunctionSymbol irSimpleFunctionSymbol;
                    Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
                    IrClassifierSymbol classifier = IrTypesKt.getClassifierOrNull(type2);
                    if (this.isArrayOrPrimitiveArray(classifier)) {
                        irSimpleFunctionSymbol = this.getContext().getIrBuiltIns().getDataClassArrayMemberHashCodeSymbol();
                    } else if (classifier instanceof IrClassSymbol) {
                        irSimpleFunctionSymbol = this.getHashCodeFunction((IrClass)((IrClassSymbol)classifier).getOwner());
                    } else if (classifier instanceof IrTypeParameterSymbol) {
                        irSimpleFunctionSymbol = this.getHashCodeFunction(this.getErasedUpperBound((IrTypeParameter)((IrTypeParameterSymbol)classifier).getOwner()));
                    } else {
                        String string2 = Intrinsics.stringPlus((String)"Unknown classifier kind ", (Object)classifier);
                        boolean bl = false;
                        throw (Throwable)new IllegalStateException(string2.toString());
                    }
                    IrSimpleFunctionSymbol symbol2 = irSimpleFunctionSymbol;
                    return new irDataClassMembersGenerator.Fir2IrHashCodeFunctionInfo(this, symbol2);
                }
            };
        }

        @NotNull
        public final IrClass getIrClass() {
            return this.irClass;
        }

        @NotNull
        public final ConeClassLikeLookupTag getLookupTag() {
            return this.lookupTag;
        }

        @NotNull
        public final IrDeclarationOrigin getOrigin() {
            return this.origin;
        }

        @NotNull
        public final IrValueParameter generateDispatchReceiverParameter(@NotNull IrFunction irFunction2) {
            Intrinsics.checkNotNullParameter((Object)irFunction2, (String)"irFunction");
            return ConversionUtilsKt.declareThisReceiverParameter(irFunction2, DataClassMembersGenerator.this.getComponents().getSymbolTable(), IrUtilsKt.getDefaultType(this.irClass), this.origin, -1, -1);
        }

        private final boolean getMatchesEqualsSignature(FirSimpleFunction $this$matchesEqualsSignature) {
            return $this$matchesEqualsSignature.getValueParameters().size() == 1 && Intrinsics.areEqual((Object)Fir2IrTypeConverterKt.toIrType$default($this$matchesEqualsSignature.getValueParameters().get(0).getReturnTypeRef(), DataClassMembersGenerator.this.getComponents().getTypeConverter(), null, 2, null), (Object)DataClassMembersGenerator.this.getComponents().getIrBuiltIns().getAnyNType()) && Intrinsics.areEqual((Object)Fir2IrTypeConverterKt.toIrType$default($this$matchesEqualsSignature.getReturnTypeRef(), DataClassMembersGenerator.this.getComponents().getTypeConverter(), null, 2, null), (Object)DataClassMembersGenerator.this.getComponents().getIrBuiltIns().getBooleanType());
        }

        private final boolean getMatchesHashCodeSignature(FirSimpleFunction $this$matchesHashCodeSignature) {
            return $this$matchesHashCodeSignature.getValueParameters().isEmpty() && Intrinsics.areEqual((Object)Fir2IrTypeConverterKt.toIrType$default($this$matchesHashCodeSignature.getReturnTypeRef(), DataClassMembersGenerator.this.getComponents().getTypeConverter(), null, 2, null), (Object)DataClassMembersGenerator.this.getComponents().getIrBuiltIns().getIntType());
        }

        private final boolean getMatchesToStringSignature(FirSimpleFunction $this$matchesToStringSignature) {
            return $this$matchesToStringSignature.getValueParameters().isEmpty() && Intrinsics.areEqual((Object)Fir2IrTypeConverterKt.toIrType$default($this$matchesToStringSignature.getReturnTypeRef(), DataClassMembersGenerator.this.getComponents().getTypeConverter(), null, 2, null), (Object)DataClassMembersGenerator.this.getComponents().getIrBuiltIns().getStringType());
        }

        private final boolean getMatchesDataClassSyntheticMemberSignatures(FirSimpleFunction $this$matchesDataClassSyntheticMemberSignatures) {
            return Intrinsics.areEqual((Object)$this$matchesDataClassSyntheticMemberSignatures.getName(), (Object)equalsName) && this.getMatchesEqualsSignature($this$matchesDataClassSyntheticMemberSignatures) || Intrinsics.areEqual((Object)$this$matchesDataClassSyntheticMemberSignatures.getName(), (Object)hashCodeName) && this.getMatchesHashCodeSignature($this$matchesDataClassSyntheticMemberSignatures) || Intrinsics.areEqual((Object)$this$matchesDataClassSyntheticMemberSignatures.getName(), (Object)toStringName) && this.getMatchesToStringSignature($this$matchesDataClassSyntheticMemberSignatures);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<FirDeclaration> generate(@NotNull FirClass<?> klass) {
            Object element$iv$iv;
            void $this$mapNotNullTo$iv$iv;
            void $this$filterIsInstanceTo$iv$iv;
            void $this$filterIsInstance$iv;
            int n;
            Intrinsics.checkNotNullParameter(klass, (String)"klass");
            Object object = IrUtilsKt.getPrimaryConstructor(this.irClass);
            List<IrValueParameter> list2 = object == null ? null : IrUtilsKt.getExplicitParameters((IrFunction)object);
            int propertyParametersCount = list2 == null ? 0 : (n = list2.size());
            object = this.irClass.getDeclarations();
            boolean $i$f$filterIsInstance = false;
            void var6_8 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo22 = false;
            for (Object element$iv$iv2 : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv2 instanceof IrProperty)) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            List properties2 = CollectionsKt.take((Iterable)((List)destination$iv$iv), (int)propertyParametersCount);
            if (properties2.isEmpty()) {
                return CollectionsKt.emptyList();
            }
            $i$f$filterIsInstance = false;
            List result2 = new ArrayList();
            Iterable $this$mapNotNull$iv = klass.getDeclarations();
            boolean $i$f$mapNotNull22 = false;
            Iterable $i$f$filterIsInstanceTo22 = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Name name;
                Object element$iv$iv$iv;
                element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                FirDeclaration it = (FirDeclaration)element$iv$iv;
                boolean bl2 = false;
                if ((it instanceof FirSimpleFunction && this.getMatchesDataClassSyntheticMemberSignatures((FirSimpleFunction)it) ? ((FirSimpleFunction)it).getName() : null) == null) continue;
                name = name;
                boolean bl3 = false;
                boolean bl4 = false;
                Name it$iv$iv = name;
                boolean bl5 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List contributedFunctionsInThisType = (List)destination$iv$iv2;
            DataClassMembersGenerator $i$f$mapNotNull22 = DataClassMembersGenerator.this;
            boolean bl = false;
            boolean bl6 = false;
            bl6 = false;
            Map map = MapsKt.createMapBuilder();
            boolean bl7 = false;
            boolean bl8 = false;
            Map $this$generate_u24lambda_u2d1 = map;
            boolean bl9 = false;
            element$iv$iv = new Name[]{equalsName, hashCodeName, toStringName};
            for (Name name : CollectionsKt.listOf(element$iv$iv)) {
                KotlinScopeProviderKt.unsubstitutedScope(klass, $i$f$mapNotNull22.getComponents().getSession(), $i$f$mapNotNull22.getComponents().getScopeSession(), true).processFunctionsByName(name, (Function1<? super FirNamedFunctionSymbol, Unit>)((Function1)new Function1<FirNamedFunctionSymbol, Unit>(this, (Map<Name, FirSimpleFunction>)$this$generate_u24lambda_u2d1){
                    final /* synthetic */ MyDataClassMethodsGenerator this$0;
                    final /* synthetic */ Map<Name, FirSimpleFunction> $this_buildMap;
                    {
                        this.this$0 = $receiver;
                        this.$this_buildMap = $receiver2;
                        super(1);
                    }

                    public final void invoke(@NotNull FirNamedFunctionSymbol it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        FirSimpleFunction declaration = (FirSimpleFunction)it.getFir();
                        if (MyDataClassMethodsGenerator.access$getMatchesDataClassSyntheticMemberSignatures(this.this$0, declaration)) {
                            this.$this_buildMap.putIfAbsent(declaration.getName(), declaration);
                        }
                    }
                }));
            }
            Map contributedFunctionsInSupertypes2 = MapsKt.build((Map)map);
            if (!contributedFunctionsInThisType.contains(equalsName) && MyDataClassMethodsGenerator.generate$isOverridableDeclaration(contributedFunctionsInSupertypes2, equalsName)) {
                result2.add(MapsKt.getValue((Map)contributedFunctionsInSupertypes2, (Object)equalsName));
                IrFunction equalsFunction = this.createSyntheticIrFunction(equalsName, DataClassMembersGenerator.this.getComponents().getIrBuiltIns().getBooleanType(), true);
                this.irDataClassMembersGenerator.generateEqualsMethod(equalsFunction, properties2);
                this.irClass.getDeclarations().add(equalsFunction);
            }
            if (!contributedFunctionsInThisType.contains(hashCodeName) && MyDataClassMethodsGenerator.generate$isOverridableDeclaration(contributedFunctionsInSupertypes2, hashCodeName)) {
                result2.add(MapsKt.getValue((Map)contributedFunctionsInSupertypes2, (Object)hashCodeName));
                IrFunction hashCodeFunction = MyDataClassMethodsGenerator.createSyntheticIrFunction$default(this, hashCodeName, DataClassMembersGenerator.this.getComponents().getIrBuiltIns().getIntType(), false, 4, null);
                this.irDataClassMembersGenerator.generateHashCodeMethod(hashCodeFunction, properties2);
                this.irClass.getDeclarations().add(hashCodeFunction);
            }
            if (!contributedFunctionsInThisType.contains(toStringName) && MyDataClassMethodsGenerator.generate$isOverridableDeclaration(contributedFunctionsInSupertypes2, toStringName)) {
                result2.add(MapsKt.getValue((Map)contributedFunctionsInSupertypes2, (Object)toStringName));
                IrFunction toStringFunction = MyDataClassMethodsGenerator.createSyntheticIrFunction$default(this, toStringName, DataClassMembersGenerator.this.getComponents().getIrBuiltIns().getStringType(), false, 4, null);
                this.irDataClassMembersGenerator.generateToStringMethod(toStringFunction, properties2);
                this.irClass.getDeclarations().add(toStringFunction);
            }
            return result2;
        }

        public final void generateComponentBody(@NotNull IrFunction irFunction2) {
            Intrinsics.checkNotNullParameter((Object)irFunction2, (String)"irFunction");
            Integer n = Companion.getComponentIndex(irFunction2);
            Intrinsics.checkNotNull((Object)n);
            int index2 = n;
            IrConstructor irConstructor2 = IrUtilsKt.getPrimaryConstructor(this.irClass);
            Intrinsics.checkNotNull((Object)irConstructor2);
            IrValueParameter valueParameter2 = irConstructor2.getValueParameters().get(index2 - 1);
            IrProperty irProperty2 = this.irDataClassMembersGenerator.getProperty(null, valueParameter2);
            Intrinsics.checkNotNull((Object)irProperty2);
            IrProperty irProperty3 = irProperty2;
            this.irDataClassMembersGenerator.generateComponentFunction(irFunction2, irProperty3);
        }

        public final void generateCopyBody(@NotNull IrFunction irFunction2) {
            Intrinsics.checkNotNullParameter((Object)irFunction2, (String)"irFunction");
            IrConstructor irConstructor2 = IrUtilsKt.getPrimaryConstructor(this.irClass);
            Intrinsics.checkNotNull((Object)irConstructor2);
            this.irDataClassMembersGenerator.generateCopyFunction(irFunction2, irConstructor2.getSymbol());
        }

        /*
         * WARNING - void declaration
         */
        private final IrFunction createSyntheticIrFunction(Name name, IrType returnType2, boolean otherParameterNeeded) {
            Object v2;
            IrSimpleFunction $this$createSyntheticIrFunction_u24lambda_u2d7;
            IrSimpleFunction irSimpleFunction;
            Object object;
            Object object2;
            Object object3;
            block12: {
                void $this$singleOrNull$iv;
                Iterable $this$toTypedArray$iv;
                Collection<ConeStarProjection> collection;
                void $this$mapTo$iv$iv;
                Collection $this$map$iv;
                Object object4;
                FirTypeRef firTypeRef;
                DataClassMembersGenerator dataClassMembersGenerator = DataClassMembersGenerator.this;
                boolean $i$f$buildSimpleFunction = false;
                boolean bl = false;
                object3 = new FirSimpleFunctionBuilder();
                boolean bl2 = false;
                boolean bl3 = false;
                FirSimpleFunctionBuilder $this$createSyntheticIrFunction_u24lambda_u2d4 = object3;
                boolean bl4 = false;
                $this$createSyntheticIrFunction_u24lambda_u2d4.setOrigin(FirDeclarationOrigin.Synthetic.INSTANCE);
                $this$createSyntheticIrFunction_u24lambda_u2d4.setName(name);
                $this$createSyntheticIrFunction_u24lambda_u2d4.setSymbol(new FirNamedFunctionSymbol(new CallableId(this.getLookupTag().getClassId(), name)));
                $this$createSyntheticIrFunction_u24lambda_u2d4.setStatus(new FirDeclarationStatusImpl(Visibilities.Public.INSTANCE, Modality.FINAL));
                $this$createSyntheticIrFunction_u24lambda_u2d4.setSession(dataClassMembersGenerator.getComponents().getSession());
                object2 = returnType2;
                if (Intrinsics.areEqual((Object)object2, (Object)dataClassMembersGenerator.getComponents().getIrBuiltIns().getBooleanType())) {
                    firTypeRef = new FirImplicitBooleanTypeRef(null);
                } else if (Intrinsics.areEqual((Object)object2, (Object)dataClassMembersGenerator.getComponents().getIrBuiltIns().getIntType())) {
                    firTypeRef = new FirImplicitIntTypeRef(null);
                } else if (Intrinsics.areEqual((Object)object2, (Object)dataClassMembersGenerator.getComponents().getIrBuiltIns().getStringType())) {
                    firTypeRef = new FirImplicitStringTypeRef(null);
                } else {
                    String string2 = Intrinsics.stringPlus((String)"Unexpected synthetic data class function return type: ", (Object)returnType2);
                    boolean bl5 = false;
                    throw (Throwable)new IllegalStateException(string2.toString());
                }
                $this$createSyntheticIrFunction_u24lambda_u2d4.setReturnTypeRef(firTypeRef);
                if (otherParameterNeeded) {
                    void $this$createSyntheticIrFunction_u24lambda_u2d4_u24lambda_u2d2;
                    boolean $i$f$buildValueParameter = false;
                    boolean bl6 = false;
                    FirValueParameterBuilder firValueParameterBuilder = new FirValueParameterBuilder();
                    boolean bl7 = false;
                    boolean bl8 = false;
                    FirValueParameterBuilder firValueParameterBuilder2 = firValueParameterBuilder;
                    object4 = $this$createSyntheticIrFunction_u24lambda_u2d4.getValueParameters();
                    boolean bl9 = false;
                    Name name2 = Name.identifier("other");
                    Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(\"other\")");
                    $this$createSyntheticIrFunction_u24lambda_u2d4_u24lambda_u2d2.setName(name2);
                    $this$createSyntheticIrFunction_u24lambda_u2d4_u24lambda_u2d2.setOrigin(FirDeclarationOrigin.Synthetic.INSTANCE);
                    $this$createSyntheticIrFunction_u24lambda_u2d4_u24lambda_u2d2.setSession(dataClassMembersGenerator.getComponents().getSession());
                    $this$createSyntheticIrFunction_u24lambda_u2d4_u24lambda_u2d2.setReturnTypeRef(new FirImplicitNullableAnyTypeRef(null));
                    $this$createSyntheticIrFunction_u24lambda_u2d4_u24lambda_u2d2.setSymbol(new FirVariableSymbol<FirValueParameter>($this$createSyntheticIrFunction_u24lambda_u2d4_u24lambda_u2d2.getName()));
                    $this$createSyntheticIrFunction_u24lambda_u2d4_u24lambda_u2d2.setCrossinline(false);
                    $this$createSyntheticIrFunction_u24lambda_u2d4_u24lambda_u2d2.setNoinline(false);
                    $this$createSyntheticIrFunction_u24lambda_u2d4_u24lambda_u2d2.setVararg(false);
                    object = Unit.INSTANCE;
                    object4.add(firValueParameterBuilder.build());
                }
                Iterable $i$f$buildValueParameter = (Iterable)new IntRange(1, this.getIrClass().getTypeParameters().size());
                object = this.getLookupTag();
                object4 = $this$createSyntheticIrFunction_u24lambda_u2d4;
                boolean $i$f$map = false;
                void var14_21 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator bl9 = $this$mapTo$iv$iv.iterator();
                while (bl9.hasNext()) {
                    int item$iv$iv;
                    int n = item$iv$iv = ((IntIterator)bl9).nextInt();
                    collection = destination$iv$iv;
                    boolean bl10 = false;
                    ConeStarProjection coneStarProjection = ConeStarProjection.INSTANCE;
                    collection.add(coneStarProjection);
                }
                collection = (List)destination$iv$iv;
                $this$map$iv = collection;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                ConeStarProjection[] coneStarProjectionArray = thisCollection$iv.toArray(new ConeStarProjection[0]);
                if (coneStarProjectionArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                ((FirSimpleFunctionBuilder)object4).setDispatchReceiverType(TypeConstructionUtilsKt.constructType$default((ConeClassifierLookupTag)object, coneStarProjectionArray, false, null, 4, null));
                FirSimpleFunction firFunction = ((FirSimpleFunctionBuilder)object3).build();
                IdSignature signature2 = this.lookupTag.getClassId().isLocal() ? null : Fir2IrSignatureComposer.DefaultImpls.composeSignature$default(DataClassMembersGenerator.this.getComponents().getSignatureComposer(), firFunction, null, 2, null);
                irSimpleFunction = DataClassMembersGenerator.this.getComponents().getDeclarationStorage().declareIrSimpleFunction$fir2ir(signature2, null, (Function1<? super IrSimpleFunctionSymbol, ? extends IrSimpleFunction>)((Function1)new Function1<IrSimpleFunctionSymbol, IrSimpleFunction>(DataClassMembersGenerator.this, this, name, returnType2, otherParameterNeeded, firFunction){
                    final /* synthetic */ DataClassMembersGenerator this$0;
                    final /* synthetic */ MyDataClassMethodsGenerator this$1;
                    final /* synthetic */ Name $name;
                    final /* synthetic */ IrType $returnType;
                    final /* synthetic */ boolean $otherParameterNeeded;
                    final /* synthetic */ FirSimpleFunction $firFunction;
                    {
                        this.this$0 = $receiver;
                        this.this$1 = $receiver2;
                        this.$name = $name;
                        this.$returnType = $returnType;
                        this.$otherParameterNeeded = $otherParameterNeeded;
                        this.$firFunction = $firFunction;
                        super(1);
                    }

                    @NotNull
                    public final IrSimpleFunction invoke(@NotNull IrSimpleFunctionSymbol symbol2) {
                        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
                        IrFactory irFactory = this.this$0.getComponents().getIrFactory();
                        IrDeclarationOrigin irDeclarationOrigin = this.this$1.getOrigin();
                        Object object = DescriptorVisibilities.PUBLIC;
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"PUBLIC");
                        object = IrFactory.DefaultImpls.createFunction$default(irFactory, -1, -1, irDeclarationOrigin, symbol2, this.$name, (DescriptorVisibility)object, Modality.OPEN, this.$returnType, false, false, false, false, false, false, false, false, null, 65536, null);
                        boolean bl = this.$otherParameterNeeded;
                        MyDataClassMethodsGenerator myDataClassMethodsGenerator = this.this$1;
                        FirSimpleFunction firSimpleFunction = this.$firFunction;
                        DataClassMembersGenerator dataClassMembersGenerator = this.this$0;
                        boolean bl2 = false;
                        boolean bl3 = false;
                        Object $this$invoke_u24lambda_u2d0 = object;
                        boolean bl4 = false;
                        if (bl) {
                            IrValueParameter irValueParameter = MyDataClassMethodsGenerator.createSyntheticIrParameter$default(myDataClassMethodsGenerator, (IrFunction)$this$invoke_u24lambda_u2d0, ((FirValueParameter)CollectionsKt.first(firSimpleFunction.getValueParameters())).getName(), dataClassMembersGenerator.getComponents().getIrBuiltIns().getAnyNType(), 0, 8, null);
                            ((IrFunction)$this$invoke_u24lambda_u2d0).setValueParameters(CollectionsKt.listOf((Object)irValueParameter));
                        }
                        $this$invoke_u24lambda_u2d0.setMetadata(new FirMetadataSource.Function(firSimpleFunction));
                        return object;
                    }
                }));
                object3 = DataClassMembersGenerator.this;
                bl2 = false;
                bl3 = false;
                $this$createSyntheticIrFunction_u24lambda_u2d7 = irSimpleFunction;
                boolean bl11 = false;
                $this$createSyntheticIrFunction_u24lambda_u2d7.setParent(this.getIrClass());
                $this$createSyntheticIrFunction_u24lambda_u2d7.setDispatchReceiverParameter(this.generateDispatchReceiverParameter($this$createSyntheticIrFunction_u24lambda_u2d7));
                $this$toTypedArray$iv = ((ClassDescriptor)((DataClassMembersGenerator)object3).getComponents().getIrBuiltIns().getAnyClass().getDescriptor()).getUnsubstitutedMemberScope().getContributedFunctions($this$createSyntheticIrFunction_u24lambda_u2d7.getName(), NoLookupLocation.FROM_BACKEND);
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    SimpleFunctionDescriptor function2 = (SimpleFunctionDescriptor)element$iv;
                    boolean bl12 = false;
                    if (!Intrinsics.areEqual((Object)function2.getName(), (Object)$this$createSyntheticIrFunction_u24lambda_u2d7.getName())) continue;
                    if (found$iv) {
                        v2 = null;
                        break block12;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v2 = !found$iv ? null : single$iv;
            }
            object = v2;
            if (object != null) {
                object2 = object;
                boolean bl = false;
                boolean bl13 = false;
                Object it = object2;
                boolean bl14 = false;
                $this$createSyntheticIrFunction_u24lambda_u2d7.setOverriddenSymbols(CollectionsKt.listOf((Object)((DataClassMembersGenerator)object3).getComponents().getSymbolTable().referenceSimpleFunction((FunctionDescriptor)it)));
            }
            return irSimpleFunction;
        }

        static /* synthetic */ IrFunction createSyntheticIrFunction$default(MyDataClassMethodsGenerator myDataClassMethodsGenerator, Name name, IrType irType, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            return myDataClassMethodsGenerator.createSyntheticIrFunction(name, irType, bl);
        }

        private final IrValueParameter createSyntheticIrParameter(IrFunction irFunction2, Name name, IrType type2, int index2) {
            IrValueParameter irValueParameter = DataClassMembersGenerator.this.getComponents().getIrFactory().createValueParameter(-1, -1, this.origin, new IrValueParameterSymbolImpl(null, 1, null), name, index2, type2, null, false, false, false, false);
            boolean bl = false;
            boolean bl2 = false;
            IrValueParameter $this$createSyntheticIrParameter_u24lambda_u2d8 = irValueParameter;
            boolean bl3 = false;
            $this$createSyntheticIrParameter_u24lambda_u2d8.setParent(irFunction2);
            return irValueParameter;
        }

        static /* synthetic */ IrValueParameter createSyntheticIrParameter$default(MyDataClassMethodsGenerator myDataClassMethodsGenerator, IrFunction irFunction2, Name name, IrType irType, int n, int n2, Object object) {
            if ((n2 & 8) != 0) {
                n = 0;
            }
            return myDataClassMethodsGenerator.createSyntheticIrParameter(irFunction2, name, irType, n);
        }

        private static final boolean generate$isOverridableDeclaration(Map<Name, ? extends FirSimpleFunction> contributedFunctionsInSupertypes2, Name name) {
            FirSimpleFunction firSimpleFunction = contributedFunctionsInSupertypes2.get(name);
            if (firSimpleFunction == null) {
                return false;
            }
            FirSimpleFunction declaration = firSimpleFunction;
            FirMemberDeclaration $this$modality$iv = declaration;
            boolean $i$f$getModality = false;
            return $this$modality$iv.getStatus().getModality() != Modality.FINAL;
        }

        public static final /* synthetic */ boolean access$getMatchesDataClassSyntheticMemberSignatures(MyDataClassMethodsGenerator $this, FirSimpleFunction $receiver) {
            return $this.getMatchesDataClassSyntheticMemberSignatures($receiver);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/backend/generators/DataClassMembersGenerator$Companion;", "", "()V", "copyName", "Lorg/jetbrains/kotlin/name/Name;", "equalsName", "hashCodeName", "toStringName", "getComponentIndex", "", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Ljava/lang/Integer;", "isComponentN", "", "isCopy", "fir2ir"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isCopy(@NotNull IrFunction irFunction2) {
            Intrinsics.checkNotNullParameter((Object)irFunction2, (String)"irFunction");
            return Intrinsics.areEqual((Object)irFunction2.getName(), (Object)copyName);
        }

        public final boolean isComponentN(@NotNull IrFunction irFunction2) {
            Intrinsics.checkNotNullParameter((Object)irFunction2, (String)"irFunction");
            if (irFunction2.getName().isSpecial()) {
                return false;
            }
            String string2 = irFunction2.getName().getIdentifier();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"irFunction.name.identifier");
            String name = string2;
            if (!StringsKt.startsWith$default((String)name, (String)"component", (boolean)false, (int)2, null)) {
                return false;
            }
            Integer n = this.getComponentIndex(irFunction2);
            return n != null && n > 0;
        }

        @Nullable
        public final Integer getComponentIndex(@NotNull IrFunction irFunction2) {
            Intrinsics.checkNotNullParameter((Object)irFunction2, (String)"irFunction");
            String string2 = irFunction2.getName().getIdentifier();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"irFunction.name.identifier");
            int n = "component".length();
            boolean bl = false;
            String string3 = string2.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            return StringsKt.toIntOrNull((String)string3);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

