/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;
import org.jetbrains.kotlin.fir.references.FirErrorNamedReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeAmbiguityError;
import org.jetbrains.kotlin.fir.symbols.AbstractFirBasedSymbol;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J$\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r*\u00020\u000e2\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u000e\u0010\u0010\u001a\u0004\u0018\u00010\u000e*\u00020\u000eH\u0002J\u0016\u0010\u0011\u001a\u00020\u0006*\u00020\u000b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\u0016\u0010\u0014\u001a\u00020\u0006*\u00020\u000b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\u0016\u0010\u0015\u001a\u00020\u0006*\u00020\u000b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirCommonConstructorDelegationIssuesChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "findCycle", "", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "knownCyclicConstructors", "getDelegated", "reportCyclicConstructorDelegationCall", "source", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "reportExplicitDelegationCallRequired", "reportPrimaryConstructorDelegationCallExpected", "checkers"})
public final class FirCommonConstructorDelegationIssuesChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirCommonConstructorDelegationIssuesChecker INSTANCE = new FirCommonConstructorDelegationIssuesChecker();

    private FirCommonConstructorDelegationIssuesChecker() {
    }

    @Override
    public void check(@NotNull FirRegularClass declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        boolean bl = false;
        Set cyclicConstructors = new LinkedHashSet();
        boolean hasPrimaryConstructor = false;
        boolean bl2 = false;
        Set otherConstructors = new LinkedHashSet();
        for (FirDeclaration it : declaration.getDeclarations()) {
            if (!(it instanceof FirConstructor)) continue;
            if (!((FirConstructor)it).isPrimary()) {
                object2 = otherConstructors;
                object = it;
                boolean bl3 = false;
                object2.add(object);
                object2 = this.findCycle((FirConstructor)it, cyclicConstructors);
                if (object2 == null) continue;
                object = object2;
                bl3 = false;
                boolean bl4 = false;
                Object visited2 = object;
                boolean bl5 = false;
                Collection collection = cyclicConstructors;
                boolean bl6 = false;
                CollectionsKt.addAll((Collection)collection, (Iterable)((Iterable)visited2));
                continue;
            }
            hasPrimaryConstructor = true;
        }
        Iterator iterator2 = otherConstructors;
        boolean it = false;
        CollectionsKt.removeAll((Collection)((Object)iterator2), (Iterable)cyclicConstructors);
        if (hasPrimaryConstructor) {
            for (FirConstructor it2 : otherConstructors) {
                object2 = it2.getDelegatedConstructor();
                if (Intrinsics.areEqual((Object)(object2 == null ? null : Boolean.valueOf(((FirDelegatedConstructorCall)object2).isThis())), (Object)true)) continue;
                object2 = it2.getDelegatedConstructor();
                if ((object2 == null ? null : ((FirDelegatedConstructorCall)object2).getSource()) != null) {
                    object2 = it2.getDelegatedConstructor();
                    this.reportPrimaryConstructorDelegationCallExpected(reporter, object2 == null ? null : ((FirDelegatedConstructorCall)object2).getSource());
                    continue;
                }
                this.reportPrimaryConstructorDelegationCallExpected(reporter, it2.getSource());
            }
        } else {
            for (FirConstructor it3 : otherConstructors) {
                FirSourceElement firSourceElement;
                object = it3.getDelegatedConstructor();
                FirReference callee = object == null ? null : ((FirDelegatedConstructorCall)object).getCalleeReference();
                if (!(callee instanceof FirErrorNamedReference) || !(((FirErrorNamedReference)callee).getDiagnostic() instanceof ConeAmbiguityError) || !(((object = it3.getDelegatedConstructor()) == null ? null : ((firSourceElement = ((FirDelegatedConstructorCall)object).getSource()) == null ? null : firSourceElement.getKind())) instanceof FirFakeSourceElementKind)) continue;
                this.reportExplicitDelegationCallRequired(reporter, it3.getSource());
            }
        }
        Iterable $this$forEach$iv = cyclicConstructors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirConstructor it4 = (FirConstructor)element$iv;
            boolean bl7 = false;
            FirDelegatedConstructorCall firDelegatedConstructorCall = it4.getDelegatedConstructor();
            INSTANCE.reportCyclicConstructorDelegationCall(reporter, firDelegatedConstructorCall == null ? null : firDelegatedConstructorCall.getSource());
        }
    }

    private final Set<FirConstructor> findCycle(FirConstructor $this$findCycle, Set<? extends FirConstructor> knownCyclicConstructors) {
        Object[] objectArray = new FirConstructor[]{$this$findCycle};
        Set visitedConstructors = SetsKt.mutableSetOf((Object[])objectArray);
        FirConstructor it = $this$findCycle;
        FirConstructor delegated = this.getDelegated($this$findCycle);
        while (!it.isPrimary() && delegated != null) {
            if (visitedConstructors.contains(delegated) || knownCyclicConstructors.contains(delegated)) {
                return visitedConstructors;
            }
            it = delegated;
            delegated = this.getDelegated(delegated);
            visitedConstructors.add(it);
        }
        return null;
    }

    static /* synthetic */ Set findCycle$default(FirCommonConstructorDelegationIssuesChecker firCommonConstructorDelegationIssuesChecker, FirConstructor firConstructor, Set set, int n, Object object) {
        if ((n & 1) != 0) {
            set = SetsKt.emptySet();
        }
        return firCommonConstructorDelegationIssuesChecker.findCycle(firConstructor, set);
    }

    private final FirConstructor getDelegated(FirConstructor $this$getDelegated) {
        FirResolvedNamedReference firResolvedNamedReference;
        FirDelegatedConstructorCall firDelegatedConstructorCall = $this$getDelegated.getDelegatedConstructor();
        Object $this$safeAs$iv = firDelegatedConstructorCall == null ? null : firDelegatedConstructorCall.getCalleeReference();
        boolean $i$f$safeAs = false;
        Object object = $this$safeAs$iv;
        if (!(object instanceof FirResolvedNamedReference)) {
            object = null;
        }
        Object $this$safeAs$iv2 = (firResolvedNamedReference = (FirResolvedNamedReference)object) == null ? null : (($this$safeAs$iv = firResolvedNamedReference.getResolvedSymbol()) == null ? null : ((AbstractFirBasedSymbol)$this$safeAs$iv).getFir());
        boolean $i$f$safeAs2 = false;
        Object v1 = $this$safeAs$iv2;
        if (!(v1 instanceof FirConstructor)) {
            v1 = null;
        }
        return v1;
    }

    private final void reportCyclicConstructorDelegationCall(DiagnosticReporter $this$reportCyclicConstructorDelegationCall, FirSourceElement source) {
        FirSourceElement firSourceElement = source;
        if (firSourceElement != null) {
            FirSourceElement firSourceElement2 = firSourceElement;
            boolean bl = false;
            boolean bl2 = false;
            FirSourceElement it = firSourceElement2;
            boolean bl3 = false;
            $this$reportCyclicConstructorDelegationCall.report((FirDiagnostic)FirErrors.INSTANCE.getCYCLIC_CONSTRUCTOR_DELEGATION_CALL().on(it));
        }
    }

    private final void reportPrimaryConstructorDelegationCallExpected(DiagnosticReporter $this$reportPrimaryConstructorDelegationCallExpected, FirSourceElement source) {
        FirSourceElement firSourceElement = source;
        if (firSourceElement != null) {
            FirSourceElement firSourceElement2 = firSourceElement;
            boolean bl = false;
            boolean bl2 = false;
            FirSourceElement it = firSourceElement2;
            boolean bl3 = false;
            $this$reportPrimaryConstructorDelegationCallExpected.report((FirDiagnostic)FirErrors.INSTANCE.getPRIMARY_CONSTRUCTOR_DELEGATION_CALL_EXPECTED().on(it));
        }
    }

    private final void reportExplicitDelegationCallRequired(DiagnosticReporter $this$reportExplicitDelegationCallRequired, FirSourceElement source) {
        FirSourceElement firSourceElement = source;
        if (firSourceElement != null) {
            FirSourceElement firSourceElement2 = firSourceElement;
            boolean bl = false;
            boolean bl2 = false;
            FirSourceElement it = firSourceElement2;
            boolean bl3 = false;
            $this$reportExplicitDelegationCallRequired.report((FirDiagnostic)FirErrors.INSTANCE.getEXPLICIT_DELEGATION_CALL_REQUIRED().on(it));
        }
    }
}

