/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentProviderKt;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.KotlinMangler;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001%B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ'\u0010\t\u001a\u0004\u0018\u00010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\u0012J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\u0014H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J$\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\f2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0002J\"\u0010!\u001a\b\u0012\u0004\u0012\u00020\n0\f*\u00020\"2\u0006\u0010#\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020\u0018H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/DescriptorByIdSignatureFinder;", "", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "mangler", "Lorg/jetbrains/kotlin/ir/util/KotlinMangler$DescriptorMangler;", "lookupMode", "Lorg/jetbrains/kotlin/backend/common/serialization/DescriptorByIdSignatureFinder$LookupMode;", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/ir/util/KotlinMangler$DescriptorMangler;Lorg/jetbrains/kotlin/backend/common/serialization/DescriptorByIdSignatureFinder$LookupMode;)V", "findDescriptorByHash", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "candidates", "", "id", "", "(Ljava/util/Collection;Ljava/lang/Long;)Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "findDescriptorBySignature", "signature", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "findDescriptorForAccessorSignature", "Lorg/jetbrains/kotlin/ir/util/IdSignature$AccessorSignature;", "findDescriptorForPublicSignature", "Lorg/jetbrains/kotlin/ir/util/IdSignature$PublicSignature;", "isConstructorName", "", "n", "Lorg/jetbrains/kotlin/name/Name;", "performLookup", "nameSegments", "", "", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "loadDescriptors", "Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;", "name", "isLeaf", "LookupMode", "ir.serialization.common"})
public final class DescriptorByIdSignatureFinder {
    @NotNull
    private final ModuleDescriptor moduleDescriptor;
    @NotNull
    private final KotlinMangler.DescriptorMangler mangler;
    @NotNull
    private final LookupMode lookupMode;

    public DescriptorByIdSignatureFinder(@NotNull ModuleDescriptor moduleDescriptor, @NotNull KotlinMangler.DescriptorMangler mangler, @NotNull LookupMode lookupMode) {
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        Intrinsics.checkNotNullParameter((Object)mangler, (String)"mangler");
        Intrinsics.checkNotNullParameter((Object)((Object)lookupMode), (String)"lookupMode");
        this.moduleDescriptor = moduleDescriptor;
        this.mangler = mangler;
        this.lookupMode = lookupMode;
        boolean bl = this.lookupMode != LookupMode.MODULE_ONLY || this.moduleDescriptor instanceof ModuleDescriptorImpl;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string2 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
    }

    @Nullable
    public final DeclarationDescriptor findDescriptorBySignature(@NotNull IdSignature signature2) {
        DeclarationDescriptor declarationDescriptor;
        Intrinsics.checkNotNullParameter((Object)signature2, (String)"signature");
        IdSignature idSignature = signature2;
        if (idSignature instanceof IdSignature.AccessorSignature) {
            declarationDescriptor = this.findDescriptorForAccessorSignature((IdSignature.AccessorSignature)signature2);
        } else if (idSignature instanceof IdSignature.PublicSignature) {
            declarationDescriptor = this.findDescriptorForPublicSignature((IdSignature.PublicSignature)signature2);
        } else {
            String string2 = Intrinsics.stringPlus((String)"only PublicSignature or AccessorSignature should reach this point, got ", (Object)signature2);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return declarationDescriptor;
    }

    private final DeclarationDescriptor findDescriptorForAccessorSignature(IdSignature.AccessorSignature signature2) {
        Object v1;
        block3: {
            PropertyDescriptor propertyDescriptor;
            Object object = this.findDescriptorBySignature(signature2.getPropertySignature());
            PropertyDescriptor propertyDescriptor2 = propertyDescriptor = object instanceof PropertyDescriptor ? (PropertyDescriptor)object : null;
            if (propertyDescriptor == null) {
                return null;
            }
            PropertyDescriptor propertyDescriptor3 = propertyDescriptor;
            String shortName = signature2.getAccessorSignature().getShortName();
            object = propertyDescriptor3.getAccessors();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"propertyDescriptor.accessors");
            Iterable $this$singleOrNull$iv = (Iterable)object;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                PropertyAccessorDescriptor it = (PropertyAccessorDescriptor)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName().asString(), (Object)shortName)) continue;
                if (found$iv) {
                    v1 = null;
                    break block3;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v1 = !found$iv ? null : single$iv;
        }
        return v1;
    }

    private final boolean isConstructorName(Name n) {
        return n.isSpecial() && Intrinsics.areEqual((Object)n.asString(), (Object)"<init>");
    }

    private final Collection<DeclarationDescriptor> loadDescriptors(MemberScope $this$loadDescriptors, String name, boolean isLeaf) {
        Name name2 = Name.guessByFirstCharacter(name);
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"guessByFirstCharacter(name)");
        Name descriptorName = name2;
        ClassifierDescriptor classifier = $this$loadDescriptors.getContributedClassifier(descriptorName, NoLookupLocation.FROM_BACKEND);
        if (!isLeaf) {
            return kotlin.collections.CollectionsKt.listOfNotNull((Object)classifier);
        }
        boolean bl = false;
        List result2 = new ArrayList();
        ClassifierDescriptor classifierDescriptor = classifier;
        if (classifierDescriptor != null) {
            ClassifierDescriptor classifierDescriptor2 = classifierDescriptor;
            boolean bl2 = false;
            boolean bl3 = false;
            ClassifierDescriptor it = classifierDescriptor2;
            boolean bl4 = false;
            result2.add(it);
        }
        result2.addAll($this$loadDescriptors.getContributedFunctions(descriptorName, NoLookupLocation.FROM_BACKEND));
        result2.addAll($this$loadDescriptors.getContributedVariables(descriptorName, NoLookupLocation.FROM_BACKEND));
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<DeclarationDescriptor> performLookup(List<String> nameSegments, FqName packageFqName) {
        Collection collection;
        String declarationName = nameSegments.get(0);
        boolean isLeaf = nameSegments.size() == 1;
        LookupMode lookupMode = this.lookupMode;
        int n = WhenMappings.$EnumSwitchMapping$0[lookupMode.ordinal()];
        switch (n) {
            case 1: {
                collection = this.loadDescriptors(this.moduleDescriptor.getPackage(packageFqName).getMemberScope(), declarationName, isLeaf);
                break;
            }
            case 2: {
                void $this$flatMapTo$iv$iv;
                void $this$flatMap$iv;
                Iterable iterable = PackageFragmentProviderKt.packageFragments(((ModuleDescriptorImpl)this.moduleDescriptor).getPackageFragmentProviderForModuleContentWithoutDependencies(), packageFqName);
                boolean $i$f$flatMap = false;
                void var9_9 = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    PackageFragmentDescriptor it = (PackageFragmentDescriptor)element$iv$iv;
                    boolean bl = false;
                    Iterable list$iv$iv = this.loadDescriptors(it.getMemberScope(), declarationName, isLeaf);
                    kotlin.collections.CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                collection = (List)destination$iv$iv;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    private final DeclarationDescriptor findDescriptorForPublicSignature(IdSignature.PublicSignature signature2) {
        DeclarationDescriptor declarationDescriptor;
        Collection candidates2;
        Collection toplevelDescriptors2;
        List<String> nameSegments = signature2.getNameSegments();
        Collection collection = this.performLookup(nameSegments, signature2.packageFqName());
        boolean bl = false;
        if (collection.isEmpty()) {
            boolean bl2 = false;
            return null;
        }
        Collection acc = toplevelDescriptors2 = collection;
        int lastIndex = kotlin.collections.CollectionsKt.getLastIndex(nameSegments);
        int bl2 = 1;
        int n = nameSegments.size();
        if (bl2 < n) {
            do {
                void $this$flatMapTo$iv$iv;
                int i = bl2++;
                Name name = Name.guessByFirstCharacter(nameSegments.get(i));
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"guessByFirstCharacter(nameSegments[i])");
                Name current2 = name;
                Iterable $this$flatMap$iv = acc;
                boolean $i$f$flatMap = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    List list2;
                    ClassDescriptor classDescriptor;
                    DeclarationDescriptor container = (DeclarationDescriptor)element$iv$iv;
                    boolean bl3 = false;
                    ClassDescriptor classDescriptor2 = classDescriptor = container instanceof ClassDescriptor ? (ClassDescriptor)container : null;
                    if (classDescriptor == null) {
                        list2 = kotlin.collections.CollectionsKt.emptyList();
                    } else {
                        List list3;
                        ClassDescriptor classDescriptor3 = classDescriptor;
                        boolean isLeaf = i == lastIndex;
                        MemberScope memberScope2 = classDescriptor3.getUnsubstitutedMemberScope();
                        Intrinsics.checkNotNullExpressionValue((Object)memberScope2, (String)"classDescriptor.unsubstitutedMemberScope");
                        MemberScope memberScope3 = memberScope2;
                        ClassifierDescriptor classifier = memberScope3.getContributedClassifier(current2, NoLookupLocation.FROM_BACKEND);
                        if (!isLeaf) {
                            List list4;
                            ClassifierDescriptor classifierDescriptor = classifier;
                            if (classifierDescriptor == null) {
                                list4 = null;
                            } else {
                                ClassifierDescriptor classifierDescriptor2 = classifierDescriptor;
                                boolean bl4 = false;
                                boolean bl5 = false;
                                ClassifierDescriptor it = classifierDescriptor2;
                                boolean bl6 = false;
                                list4 = kotlin.collections.CollectionsKt.listOf((Object)it);
                            }
                            list3 = list4;
                            list2 = list3 == null ? kotlin.collections.CollectionsKt.emptyList() : list3;
                        } else {
                            boolean bl7 = false;
                            list3 = new ArrayList();
                            boolean bl8 = false;
                            boolean bl9 = false;
                            List $this$findDescriptorForPublicSignature_u24lambda_u2d6_u24lambda_u2d5 = list3;
                            boolean bl10 = false;
                            CollectionsKt.addIfNotNull($this$findDescriptorForPublicSignature_u24lambda_u2d6_u24lambda_u2d5, classifier);
                            if (signature2.getId() != null) {
                                Object object;
                                if (this.isConstructorName(current2)) {
                                    object = classDescriptor3.getConstructors();
                                    Intrinsics.checkNotNullExpressionValue(object, (String)"classDescriptor.constructors");
                                    $this$findDescriptorForPublicSignature_u24lambda_u2d6_u24lambda_u2d5.addAll(object);
                                }
                                $this$findDescriptorForPublicSignature_u24lambda_u2d6_u24lambda_u2d5.addAll(memberScope3.getContributedFunctions(current2, NoLookupLocation.FROM_BACKEND));
                                $this$findDescriptorForPublicSignature_u24lambda_u2d6_u24lambda_u2d5.addAll(memberScope3.getContributedVariables(current2, NoLookupLocation.FROM_BACKEND));
                                object = classDescriptor3.getStaticScope();
                                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"classDescriptor.staticScope");
                                $this$findDescriptorForPublicSignature_u24lambda_u2d6_u24lambda_u2d5.addAll(ResolutionScope.DefaultImpls.getContributedDescriptors$default((ResolutionScope)object, null, (Function1)new Function1<Name, Boolean>(current2){
                                    final /* synthetic */ Name $current;
                                    {
                                        this.$current = $current;
                                        super(1);
                                    }

                                    public final boolean invoke(@NotNull Name it) {
                                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                        return Intrinsics.areEqual((Object)it, (Object)this.$current);
                                    }
                                }, 1, null));
                            }
                            list2 = list3;
                        }
                    }
                    Iterable list$iv$iv = list2;
                    kotlin.collections.CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                acc = (List)destination$iv$iv;
            } while (bl2 < n);
        }
        if ((n = (candidates2 = acc).size()) == 1) {
            declarationDescriptor = (DeclarationDescriptor)kotlin.collections.CollectionsKt.first((Iterable)candidates2);
        } else {
            DeclarationDescriptor declarationDescriptor2 = this.findDescriptorByHash(candidates2, signature2.getId());
            if (declarationDescriptor2 == null) {
                String string2 = Intrinsics.stringPlus((String)"No descriptor found for ", (Object)signature2);
                boolean bl11 = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            declarationDescriptor = declarationDescriptor2;
        }
        return declarationDescriptor;
    }

    private final DeclarationDescriptor findDescriptorByHash(Collection<? extends DeclarationDescriptor> candidates2, Long id) {
        Object v1;
        block3: {
            Iterable $this$firstOrNull$iv = candidates2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                boolean bl;
                DeclarationDescriptor candidate2 = (DeclarationDescriptor)element$iv;
                boolean bl2 = false;
                if (id == null) {
                    bl = candidate2 instanceof ClassDescriptor || candidate2 instanceof TypeAliasDescriptor;
                } else {
                    KotlinMangler.DescriptorMangler descriptorMangler = this.mangler;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    KotlinMangler.DescriptorMangler $this$findDescriptorByHash_u24lambda_u2d8_u24lambda_u2d7 = descriptorMangler;
                    boolean bl5 = false;
                    long candidateHash = $this$findDescriptorByHash_u24lambda_u2d8_u24lambda_u2d7.getSignatureMangle(candidate2);
                    bl = candidateHash == id;
                }
                if (!bl) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        return v1;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/DescriptorByIdSignatureFinder$LookupMode;", "", "(Ljava/lang/String;I)V", "MODULE_WITH_DEPENDENCIES", "MODULE_ONLY", "ir.serialization.common"})
    public static final class LookupMode
    extends Enum<LookupMode> {
        public static final /* enum */ LookupMode MODULE_WITH_DEPENDENCIES = new LookupMode();
        public static final /* enum */ LookupMode MODULE_ONLY = new LookupMode();
        private static final /* synthetic */ LookupMode[] $VALUES;

        public static LookupMode[] values() {
            LookupMode[] lookupModeArray = $VALUES;
            LookupMode[] lookupModeArray2 = new LookupMode[lookupModeArray.length];
            System.arraycopy(lookupModeArray, 0, lookupModeArray2, 0, lookupModeArray.length);
            return lookupModeArray2;
        }

        public static LookupMode valueOf(String value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            return Enum.valueOf(LookupMode.class, value2);
        }

        static {
            $VALUES = lookupModeArray = new LookupMode[]{LookupMode.MODULE_WITH_DEPENDENCIES, LookupMode.MODULE_ONLY};
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LookupMode.values().length];
            nArray[LookupMode.MODULE_WITH_DEPENDENCIES.ordinal()] = 1;
            nArray[LookupMode.MODULE_ONLY.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

